
// xbr.h for duuumb xlib only curses clone. replaces #include <curses.h>

#define ERR     (-1)
#define OK      (0)
#define TRUE    (1)
#define FALSE   (0)
//#define EOF     (-1)
#define A_CHARTEXT   0xFF
#define A_NORMAL        0 & 0xff00
#define A_REVERSE       0x100 & 0xff00
#define A_UNDERLINE     0x200 & 0xff00
#define A_BOLD          0x400 & 0xff00
#define COLS screen_width
#define LINES screen_height
#define BUTTON1_CLICKED 1
#define BUTTON2_CLICKED 2
#define BUTTON3_CLICKED 3

// curses replacement defs:

#define KEY_BACKSPACE 0xff08
#define KEY_DEL 0xffff
#define KEY_END 0xff57
#define KEY_ENTER 0xff0d
#define KEY_HOME 0xff50
#define KEY_NPAGE 0xff56
#define KEY_PPAGE 0xff55
#define KEY_LEFT 0xff51
#define KEY_UP 0xff52
#define KEY_RIGHT 0xff53
#define KEY_DOWN 0xff54
#define KEY_HELP 0xffbe
#define KEY_CANCEL 0xFF69
#define KEY_TAB 0xFF09
#define KEY_IC 0xFF63
#define KEY_DC 0xFFFF

typedef unsigned long chtype;
typedef chtype attr_t;
typedef struct
{
        int _cury, _curx;		/* current cursor position */
        int nlines, ncols;		/* height, width */
        int begin_y, begin_x;	/* upper left y,x */
} WINDOW;

extern int ats[];
extern WINDOW *stdscr;
#define  cursorp_x stdscr->_curx
#define  cursorp_y stdscr->_cury
extern int screen_width;
extern int screen_height;
extern int COLOR_PAIRS;
#define COLOR_PAIR(x) ((x) << 8)
#define COLS screen_width
#define LINES screen_height

extern void cbreak(void);
extern void nonl(void);
extern void intrflush(void *, int);
extern void keypad(void *, int);
extern void nodelay(void *, int);
extern void echo(void);
extern void noecho(void);
extern void echo(void);
extern void raw(void);
extern void noraw(void);
extern void scrollok(void *, int);
extern void endwin(void);
extern void initscr(void);

extern void move(int, int);

extern void attron(int);
extern void attroff(int);

extern int inch(void);
extern int mvinch(int y, int x);

extern void addch(int);
extern void addnstr(const char *s, int n);
extern void addstr(const char *);

extern void mvaddch(int, int, int);
extern void mvaddnstr(int y, int x, const char *s, int n);
extern void mvaddstr(int, int, const char *);

extern void scroll(void *);

extern void clrtoeol(void);
extern void clrtobot(void);
extern void clear(void);
extern void erase(void);
extern void refresh(void);

extern int getch();
extern int getstr(char *);
extern void sys_exit(int);

// done
// real (sic) xcurses

extern void redraw();
extern void unredraw();

#define wgetch(win) getch(0)
#define erasechar() KEY_BACKSPACE
#define doupdate() refresh()
#define redrawwin(win) redraw()
#define wnoutrefresh(win) redraw()
#define wrefresh(win) refresh()
#define getyx(w, y, x) { y = cursorp_y - w->begin_y; x = cursorp_x - w->begin_x; }
#define getmaxyx(w, y, x) { y = w->nlines; x = w->ncols;}
#define wmove(w,y,x) move(w->begin_y + y, w->begin_x + x)
#define wattron(w,c) attron(c)
#define wattroff(w,c) attroff(c)
#define mvwaddch(w, y, x, c) mvaddch(w->begin_y + y, w->begin_x + x, c)
#define waddch(w, c) addch(c)
#define waddstr(w, s) addstr(s)
#define mvwaddstr(w, y, x, s) mvaddstr(w->begin_y + y, w->begin_x + x, s)

#include <stdlib.h>
WINDOW *newwin(int nlines, int ncols, int begin_y, int begin_x)
{
	WINDOW *w = (WINDOW *) malloc(sizeof(WINDOW));
	w->_cury = 0;w->_curx = 0;
	w->nlines = nlines;w->ncols = ncols;
	w->begin_y = begin_y;w->begin_x = begin_x;
	return(w);
}
void delwin(WINDOW *win){ if(win) free(win); }

void def_prog_mode(void){};
void reset_prog_mode(void){};

void wclrtoeol(WINDOW *w)
{
	char s[2048];
	int i = 0, y = cursorp_y, x = cursorp_x;
	int l = w->begin_x + w->ncols - cursorp_x;
	while( i < l) s[i++] = ' ';
	s[i] = '\0';
	addstr(s);
	move(y,x);
}
void werase(WINDOW *w)
{
	int i = 1, y = cursorp_y, x = cursorp_x;
	int l = w->nlines;
	while(i < l) {
		move(w->begin_y + i++, w->begin_x);
		wclrtoeol(w);
	}
	move(y,x);
}

