
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <ctype.h>
#include <math.h>
#include <pwd.h>
#include <grp.h>
#include <signal.h>

#ifndef DOCURSES

/* linux before 2.0.0 #include <ncurses.h> */
//#include <curses.h>
#include "xbr.h"

#else

// curses replacement defs:
int COLS, LINES;
#define ERR     (-1)
#define OK      (0)
#define TRUE    (-1)
#define FALSE   (0)
#define EOF     (-1)

typedef struct _win_st WINDOW;

WINDOW *stdscr;

extern int mvaddstr(int, int, const char *);

extern int attron(int);
extern int attroff(int);
extern int noecho(void);
extern int refresh(void);
extern int getch(void);

extern int addstr(const char *);
extern int clrtoeol(void);
extern int echo(void);
extern int getstr(char *);

extern int clear(void);

extern int mvaddch(int, int, int);

extern void initscr(void);
extern int raw(void);
extern int scrollok(void *, int);

extern int move(int, int);
extern int noraw(void);
extern int endwin(void);

extern int scroll(void *);
extern int addch(int);

extern int clrtobot(void);
extern int erase(void);

// end of curses replacement stuff
#endif

#include <sys/sysmacros.h>
char Version[] = "@(#)fmx.c 4.1 (Linux) 01/11/05";

/* O P T I O N S
	Includes the currently active options but also options that are even
    more dynamic
*/
#define POP			0x00000001
#define USER		0x00000002
#define LINKS		0x00000004
#define SEEN		0x00000008
#define INODE		0x00000010
#define HMBUSY		0x00000020
#define SIZE		0x00000040
#define DATE		0x00000080
#define GROUP		0x00000100
#define FOLLOW		0x00000200
#define ACCESS		0x00000400
#define MODE		0x00000800
#define DATESORT	0x00001000
#define SIZESORT	0x00002000
#define ASORT		0x00004000
#define REV			0x00008000
#define RETURN		0x00010000
#define ACTUAL		0x00020000
#define DONE		0x00040000
#define HEX			0x00080000
#define STACK		0x00100000
#define CHANGE		0x00200000
#define CSORT		0x00400000
#define ISORT		0x00800000
#define SPACE		0x01000000
#define HIDE		0x02000000
/* Options that are saved on the stacks (and restored when popped off): */
#define SAVEFLAGS (USER|LINKS|INODE|SIZE|DATE|GROUP|FOLLOW|ACCESS|MODE|CSORT|\
DATESORT|SIZESORT|ASORT|RETURN|ACTUAL|HEX|STACK|CHANGE|ISORT|SPACE|REV)

/* Options available on the command line or in the HMOPT variable: */
#define Options "123AabDdfghIinpRSsuXYy^"

#define digs(n) ((int)ceil(log10((double)(n+1))))
#define CWD (strcmp(Cwd, "/") ? Cwd : "")

#ifdef PATH_MAX
#define MAXSTR PATH_MAX
#else
#define MAXSTR 1024
#endif

#ifndef NAME_MAX
#ifdef MAXNAMELEN
#define NAME_MAX MAXNAMELEN
#else
#define NAME_MAX 255
#endif
#endif

/* Options for system-wrapper */
#define sw_End		0x0001 /* call EndCurses before */
#define sw_Init		0x0002 /* call InitCurses after */
#define sw_Pag		0x0004 /* use pager ( | more ) */
#define sw_Wait		0x0008 /* call goon before returning */
#define sw_Clear1	0x0010 /* clear screen before */
#define sw_Check	0x0020 /* filter stdin and stderr thru pipe */

struct NBuf {			/* all info of an entry (in linked list) */
	char name[NAME_MAX+1];	/* file name */
	char pname[NAME_MAX+1];	/* printed file name */
	char qname[NAME_MAX+1];	/* quoted file name */
	struct NBuf *next;	/* next entry in list */
	struct NBuf *prev;	/* previous entry */
	char pw_name[20];	/* name of the owner */
	char gr_name[20];	/* name of the group */
	long seq;			/* sequence number in the list */
	struct stat st;		/* all other data in structure returned by (l)stat */
};

struct Stack {
	unsigned long flgs;	/* Options saved along with this place */
	char dir[MAXSTR];	/* The directory */
	char ent[NAME_MAX+1];	/* The filename */
	struct Stack *next;	/* Next place in this list */
};

struct opthlp {
	char *op;
	char **hlp;
};

/* Globals (yes, I know...) */
unsigned long flags;	/* All currently active options */
int c;					/* Character by user or simulated as such */
char Cwd[MAXSTR];		/* Current working directory */
char aux[MAXSTR];		/* some auxiliary strings */
char aux2[MAXSTR];
FILE *ls;
struct NBuf *List,	/* Head of the list of all entries in current dir */
	*Fos,			/* First entry visible on screen */
	*Los,			/* Last entry on screen */
	*Files,			/* First file in the list (after all directories) */
	*CurPtr,		/* Currently highlighted entry */
	*FreeList;		/* List of free structures */
struct Stack *DirStack, *Pstack;
#ifdef pid_t
	pid_t p;
#else
	int p;
#endif

#if 0
int ats[]={
#ifdef A_REVERSE
	A_REVERSE,
#endif
#ifdef A_UNDERLINE
	A_UNDERLINE,
#endif
#ifdef A_BLINK
	A_BLINK,
#endif
#ifdef A_DIM
	A_DIM,
#endif
#ifdef A_BOLD
	A_BOLD,
#endif
	0};
#endif

int high, bold;

char *about[]={
"   ABOUT fm",
"   --------",
"   fm was written by Hans de Hartog (dehartog@csi.com) in 1995 for Linux",
"   and Ultrix and 2 years later built on AIX, IRIX and OSF1. It should",
"   easily build on other unixes.",
"",
"   fm is a robust and easy-to-use tool, especially for system managers.",
"",
"   fm is a curses-based file manager for quickly browsing directories and",
"   files. The screen can be dynamically adjusted to include all information",
"   (like 'ls -ail'), or just the filenames (multi-column), or anything in",
"   between.",
"   All basic file and directory manipulations are possible with 1 keystroke:",
"   copy, move, delete, view, execute, change owner/group/mode, edit, diff,",
"   link (hard/symbolic), wc, tail -f, sum and others.",
"",
"   Documentation is self-contained in fm and consists of two screens from",
"   which each option or subject can be selected to show its info screen.",
"   ----",
NULL};

char *altk[]={
"Alternative keys",
"----------------",
"For each of the following keys, it is possible that your curses-library",
"supports them. It might also be possible that your terminal physically has",
"one or more of those keys. If both are true, it is also possible that those",
"keys are actually recognized as such...",
"Well, having said that, here is the list of keys and their (always working)",
"equivalent keystrokes:",
"",
"  BackSpace =^H            Delete    =^H            End       = z",
"  Enter     =^J            F1        = ?            Help      = ?",
"  Home      = H            PageDown  = F            PageUp    = B",
NULL};

char *bnr[]={
"",
"   fm version 4.1, Copyright (C) 1998 Hans de Hartog (dehartog@csi.com)",
"",
"          curses-based file manager for unix system managers",
"",
"   fm comes with ABSOLUTELY NO WARRANTY; type ? and select Warranty",
"",
"   This is free software, and you are welcome to redistribute it under",
"   certain conditions; type ? and select Copyright",
"",
"----------------------------------------------------------------------------",
"",
"   If you don't want to see this banner when you start fm, don't send money",
"   but specify the b option (fm -b) or include the b option in the HMOPT",
"   environment variable (HMOPT=b; export HMOPT).",
"   You can put lots of other options in HMOPT. For instance: to make the",
"   screen look like the output of 'ls -al', use HMOPT=bpugds (b to skip",
"   this banner, p to show the protection (a.k.a. mode), u to show the user",
"   (a.k.a. owner), g to show the group, d to show the date+time and s to",
"   show the size of files and directories).",
NULL};

char *bugs[]={
"BUGS",
"----",
"On some systems (seen on later versions of IRIX and AIX) the constituents",
"of the arrow-keys are not always passed as separate characters to this",
"program but are buffered by 4 characters.",
"This is annoying (random options will be set or cleared) but impossible to",
"solve. Workaround: use the h, j, k and l keys instead of the arrow-keys.",
"This bug is likely to occur on X11-connections to slow or busy systems.",
"----",
"Due to deficiencies of certain curses-libraries and the wide variation of",
"mechanisms to realize character attributes, emphasizing directories and/or",
"highlighting of the current file or directory might not always work.",
"If you do not see any highlighted entry and/or the directories are displayed",
"in the same way as files, hit the + or - keys to adjust the screen to your",
"preferences.",
"----",
"Other bugs certainly exist; please email them to dehartog@csi.com and I'll",
"try to fix them for the next version.",
NULL};

char *cont[]={
"Continuation and confirmation",
"-----------------------------",
"Several occasions might occur when fm has to get a confirmation from the",
"user, indicating that the information on screen was read and fm can go on.",
"Because the user might be used to certain conventions in other programs, fm",
"offers a few options for confirmation.",
"The options are (mutually exclusive) 1, 2 or 3 and can be (un)set by simply",
"typing 1, 2 and 3 (the current options are always displayed at the end of",
"the second line on the screen).",
"The option setting for confirmation is also active while the help screens",
"are displayed.",
"",
"Here are the messages displayed for the three options:",
" 1  Hit Return to continue",
" 2  Hit Space to continue",
" 3  Awaiting next command",
"When none of the options 1, 2 or 3 is set, the message is:",
"    Hit any key to continue",
"These messages speak for themselves except maybe option 3: any keystroke",
"will allow fm to continue AND that keystroke is used as the next command",
"(only for the experienced user).",
NULL};

char *cr[]={
"",
"    Copyright (C) 1998  Hans de Hartog (dehartog@csi.com)",
"",
"    This program is free software; you can redistribute it and/or modify",
"    it under the terms of the GNU General Public License as published by",
"    the Free Software Foundation; either version 2 of the License, or",
"    (at your option) any later version.",
"",
"    This program is distributed in the hope that it will be useful,",
"    but WITHOUT ANY WARRANTY; without even the implied warranty of",
"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the",
"    GNU General Public License for more details.",
"",
"    You should have received a copy of the GNU General Public License",
"    along with this program; if not, write to the Free Software",
"    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.",
"",
"        O      Hans de Hartog, 173 Adamsdreef",
"       / \\     6716 ML  Ede, The Netherlands",
"    * / G \\ *  Home  : +31 318 638560",
"     /*   *\\   Mobile: +31 653 252774",
"        *      Fax   : +31 842 122576",
NULL};

char *envi[]={
" ENVIRONMENT: The following environment variables are used by fm:",
" ----------------------------------------------------------------",
" EDITOR is used whenever a file is opened for editing. When EDITOR is not",
" set, the vi editor wil be used.",
"",
" HMOPT is an environment variable that is specific for hm. It contains the",
" options that are set when fm starts (by default, no options are set).",
" Example: HMOPT=dgpsu will display the date, group, protection, size and",
" owner of files and directories (will look like 'ls -al').",
"",
" HOME is used for two things: the ~ command (to directly visit your home-",
" directory) and to save the stack in $HOME/.hmstack (if the stack is used).",
"",
" PAGER is used to display the contents of files and to view the output of",
" commands called by fm (e.g. od). If not set, the default is 'more'.",
"",
" PS1 (the shell prompt) is prefixed with 'fm:' every time a subshell is",
" spawned by hm.",
"",
" SHELL is used to exec a sub-shell by the ! command. For other commands,",
" either /bin/sh is used or the command is spawned by (v)fork and execlp.",
" ----",
NULL};

char *filat[]={
"Attributes of files and directories that can be shown or hidden",
"---------------------------------------------------------------",
"The following options are toggle switches and determine whether certain",
"attributes are 'on screen' or not:",
" g gid (group identification)       i inode",
" n number of hard links             p protection (rwx-format) ",
" s size (in bytes)                  u uid (user identification)", 
"",
"If you have the privilege, you can change some of those attributes with",
"the corresponding upper case character (G, P and U).",
"",
"See the a, d and y options for showing various times of files/directories.",
"",
"The order of the attributes is fixed: i, p, n, u, g, s, times, name.",
NULL};

char *filcont[]={
"The following options run commands to get information about the contents of",
"regular files. The output of those commands is appended to the bottom of the",
"screen. So, the toplines are (temporarily) scrolled off. After confirmation,",
"the original screen is restored.",
"",
"  C  Computes the checksum of the currently highlighted file.",
"",
"  t  Tries to determine the type of the file. The result might differ from",
"     one unix version to an other. However, this method is also used by fm",
"     internally to decide between ascii or binary displaying of the file's",
"     contents.",
"",
"  w  Computes the line, word and character count of the file.",
"-------",
NULL};

char *filop[]={
"Operations on file and directories",
"----------------------------------",
" c copy; prompts for destination; works also for directories and remote copy",
"   (if destination contains a :); command used: rcp -pr source destination.",
"",
" e edit; uses $EDITOR or vi.",
"",
" G change gid; prompts for new group.",
"",
" m move; prompts for destination; works also for directories; command used:",
"   mv -f source dest || ( cp -pr source dest && rm -rf source)",
"",
" P change protection (a.k.a. mode); prompts for new protection (octal!).",
"",
" r remove; works also for directories; confirmation is needed.",
"",
" U change uid; prompts for new owner.",
"",
" % changes the time of last modifcation to the current time (touch).",
NULL};

char *highl[]={
"Highlighting and emphasizing attributes",
"---------------------------------------",
"This program can add two attributes to the characters on the screen.",
"One to emphasize text (e.g. to distinguish directories from files),",
"and another attribute to highlight the current selection.",
"Because it is far beyond the control of this program to influence the",
"way these attributes are actually realized (e.g. color-settings for an",
"xterm or a bold character font), two options are provided to cycle",
"through a list of possible ways to do this:",
"",
" + cycles through the list of attributes to emphasize text",
" - cycles through the list of attributes to highlight text",
"",
"Use these options to adjust the screen to your preferences.",
NULL};

char *hist[]={
"HISTORY",
"-------",
"november 1995  Version 1.0 for Linux and Ultrix",
"may      1997  Tested on Digital UNIX 3.2G, IRIX 5.3 and AIX",
"               Restricted c and m to dirs and regular files",
"june     1997  Ask confirmation before moving file or directory",
"               Lots of changes (inode sort, help text, etc.); Version 2.0",
"july     1997  Added wrapper around system(...) using popen(...)",
"march    1998  Minor cosmetic changes; made this version 2.3",
"april    1998  Fixed (undiscovered) bugs with PS1 and ERR-return from getch",
"august   1998  Added lots of options and an easy help-facility",
"               Fixed never discovered bug with multiple sort options",
"               Minor changes to comply with GNU GPL",
"               Made this version 3.0 (uploaded to sunsite.unc.edu)",
"sept.    1998  Show special or non-printable characters in filenames",
"               Solved problems with special chars in names (thank you Simon)",
"               Completely rewrote the highlght/reverse-video stuff",
"               Tested on FreeBSD 2.2.6 (thank you Toni) and HP-UX 10.20",
"               (thank you Guenther). Started commenting the source...",
"               Version 3.1 (uploaded to sunsite.unc.edu)",
NULL};

char *invo[]={
"INVOCATION",
"----------",
"Syntax: fm [-options] [path]",
"The options can be any combination of options that are marked as a toggles",
"in the previous help screen. Additionally, the command 'fm -h' gives a short",
"usage message that lists those options (and exits).",
"",
"The priority of options is as follows: initially, all options are off; then,",
"the options in the environment variable HMOPT (if any) are set; finally,",
"any options given on the command line (if any) are toggled. This means that",
"if an option is set in HMOPT, you can switch it off again by specifying it",
"explicitly on the commandline (got that?).",
"",
"If the (optional) path is specified, it should be a directory and fm will",
"use that as initial working directory. Otherwise, your current working",
"directory will be used by hm.",
"----",
NULL};

char *lnk[]={
"Links, how to create them and how are they displayed",
"----------------------------------------------------------------------",
"There are two commands to create links:",
" @  Prompts for a name and creates a symbolic link with that name which",
"    points to the currently highlighted directory/file.",
" =  Same as @ but creates a hard link.",
"",
"fm by default, shows symbolic links as links. If the currently highlighted",
"entry is a symbolic link and you hit Return, fm brings you to wherever the",
"link points to.",
"This behaviour can be changed by the f toggle. If f is set, links are not",
"displayed as such, but fm displays the entries where the links point to.",
"If f is set, and you are 'on' a file that is in fact a link and you hit",
"Return, the contents of the file is displayed (just as with normal files).",
"Note that whenever the f-option is (un)set, the current directory will be",
"rescanned.",
NULL};

char *lsm[]={
"LSM entry for 4.1:",
"",
"Begin3",
"Title:          fm",
"Version:        4.1",
"Entered-date:   13SEP98",
"Description:    Multiplatform cursesbased filemanager.",
"                Developed, adjusted and matured for 3",
"                years by and for unix system managers.",
"                Versatile look from ls-like to ls -ail.",
"                All the basics with one keystroke: cd, cat,",
"                chgrp, chmod, chown, cp, diff, file, ln, man,",
"                mkdir, mv, od, rm, sh, sum, tail -f, vi, wc.",
"                Help-facility built in (no man page needed).",
"Keywords:       filemanager",
"Author:         dehartog@csi.com (Hans de Hartog)",
"Maintained-by:  dehartog@csi.com (Hans de Hartog)",
"Primary-site:   sunsite.unc.edu /pub/Linux/utils/file/managers",
"                31Kb hm-4.1.tar.gz",
"                 1Kb hm.lsm",
"Platforms:      Linux Ultrix OSF AIX IRIX FreeBSD HP-UX",
"Copying-policy: GPL",
"End",
NULL};

char *misc[]={
"Miscelaneous options and commands:",
"  b  When fm starts and the b option is set (by specifying -b on the command",
"     line or the b option is included in the environment variable HMOPT),",
"     the banner is skipped. You can always see the banner by typing the b",
"     option (this will not change fm's action at startup).",
" ^C  Exits from hm. It does NOT interrupt any operation that is in progress;",
"     i.e. you have to wait for a directory scan, copying, etc.",
"  K  runs the man -k command with the current item as argument.",
"  M  runs the man command with the current item as argument.",
"  N  Shows the version, target platform and date of this build of hm.",
" ^R  Refreshes the complete screen (e.g. after wall-messages). Note that it",
"     does NOT refresh the informaton (see next option).",
"  .  Rescans the current directory and updates all information. The file or",
"     directory that was highlighted stays focussed but might be repositioned",
"     towards the middle of the screen.",
"  $  Syncs the disks (for the paranoid: hit it 3 times).",
"  V  Changes your umask; you will be prompted for a new umask (specify in",
"     octal!). Your umask is always shown in the second line of the screen.",
"  ?  Shows a screen with all options for quick reference. In that screen,",
"     you can easily select an option or some other item with the arrowkeys",
"     to display more information about that subject. On some systems, F1 or",
"     the Help-key (if any) might do the same.",
NULL};

char *mrk[]={
"The mark and what you can do with it",
"------------------------------------",
"The mark is simply a pathname. It can be used to remember a specific",
"directory/file to refer to, or go back to. Mark-related commands:",
" J  Jump; leaves the current directory and go back to the mark.",
" W  Where's the mark? Simply types the current mark.",
" X  Runs diff between the current entry and the mark.",
" #  Exchange current place and mark (go to mark and set mark to where you",
"    came from)",
" \\  set the mark to where you are now (previous mark is lost).",
"",
"Note the differences between the mark and stack-mechanisms used by fm:",
"If you just want to go back to previously visited places, use the stacks.",
"If you frequently switch between two directories or want to use the diff",
"facilty, use the mark. Also, the mark is lost when you exit hm. The stack",
"can be saved from one session to another.",
NULL};

char *navin[]={
"Options to navigate within the current directory",
"------------------------------------------------",
"If you don't want to read this terrible explanation, just go back and try",
"the arrow-keys, see what happens and get the feel of it. Later, you might",
"find the last 3 options useful.",
"",
"B   Go back one screenfull",
"F   Go forward one screenfull",
"H   Go to the entry at the top of the leftmost column",
"h   Go one column to the left (shifts columns if at the leftmost column)",
"j   Go to next entry (top of next column if at the bottom of current column)",
"k   Go to previous entry (bottom of previous column if at the top)",
"L   Go to the entry at the bottom of the rightmost column",
"l   Go one column to the right (shifts columns if at the rightmost column)",
"z   Go to the last entry in this directory",
"[   Move to the first directory (i.e. top of the whole list)",
"]   Move to the last directory, i.e. just above the first file (if any)",
"",
"If only one file/directory fits on a line, a column is the same as a screen",
"",
"Your terminal and curses-library might also support the following keys:",
"End      = z       Home   = H       Up-arrow   = k       Down-arrow  = j",
"PageDown = F       PageUp = B       Left-arrow = h       Right-arrow = l",
NULL};

char *navout[]={
"Navigating between directories",
"------------------------------",
"The following commands will move you to some specific directories:",
" ~  Takes you to your home directory (cd $HOME).",
" :  Takes you to the parent directory of the current directory (cd ..).",
" /  Takes you to the root directory (cd /).",
" o  Prompts you for a directory name and takes you there. If the directory",
"    does not exist, fm will ask you to create it (type y to confirm).",
"",
"Lots of other possibilities exist to change to another directory.",
"See the following subjects (from the 'Help by subject' helpscreen):",
"  Mark options",
"  Stacks in fm and how to use them",
"  Visiting files/directories",
NULL};

char *screen[]={
"What's on the screen?",
"---------------------",
"fm is always displaying the contents of a directory onto the 3rd line of the",
"screen upto (but not including) the bottom line. Directories are displayed",
"first (in bold characters to distinguish them from other files).",
"Whenever possible, the files and directories are displayed in multi-column",
"format automatically.",
"",
"The first line contains the hostname of the machine fm is running on, the",
"full pathname of the directory the contents of which is currently displayed",
"(highlighted) and (right justified) the current date and time.",
"",
"The second line contains the number of entries in the directory, the amount",
"of diskspace used by this directory (NOT including subdirectories!), the",
"current umask, the name and primary group of the user and (right justified)",
"the options that are currently set.",
"",
"The last line shows what fm is doing, what input is asked from the user, or",
"any (maybe unsollicited) output from commands (error messages).",
"In the last case, the top lines might scroll off the screen. However, it is",
"considered more important by fm to show that information than to maintain",
"the top lines; after confirmation, the screen is always restored correctly.",
"----",
NULL};

char *srt[]={
"About SORTING (options A, D, I, S, Y and ^)",
"-------------------------------------------",
"By default, all sort options are off. That means: directories and files are",
"sorted descending by name. The options A, D, I, S and Y establish another",
"way to sort: by Access time, modification Date and time, Inode, Size and",
"mode-change time (respectively). These sort modes are mutually exclusive",
"(i.e. setting one unsets another) and therefore considered to be toggles.",
"",
"Whenever one of the A, D, I, S or Y sort modes is in effect (as can be seen",
"in the upper right corner of the screen where currently active options are",
"shown) and you want to return to the default (sort by name), type that",
"option again and it will be off. So, in that sense they are really toggles.",
"",
"The ^ option is a real toggle and switches between descending and ascending",
"sort. This is very handy with the z option; for instance: D^z sorts by date",
"and moves you to last entry, i.e. the latest modified file.",
"",
"When changing the sort mode, the currently highlighted directory or file",
"stays focussed but might be repositioned towards the middle of the screen.",
NULL};

char *stks[]={
"About STACKS in fm (also read 'Navigating between directories'):",
"fm maintains two stacks: the history stack (hstack) and the push-down stack",
"(pstack). The items on both stacks are places (directories and files) that",
"were visited. Along with those places, the options that were set at that",
"time, are also saved on the stacks (and restored when you go back there).",
"Places are automatically pushed onto the hstack by fm whenever another place",
"is visited (i.e. another directory). The pstack however, is controlled by",
"the user with the pop and push options (< and > respectively).",
"",
"Options and commands for the stacks:",
"^H  (or Delete or BackSpace keys) uses the history stack to go back to the",
"    directory (and file) you were before; the current place is forgotten.",
" Q  queries the contents of the push-down stack.",
" q  queries the contents of the history stack.",
" R  a toggle switch; if set when fm exits, the complete history stack is",
"    saved in the file .hmstack in the users home-directory ($HOME). If R",
"    is set when fm starts (only possible if explicitly  given as 'fm -R'",
"    or when the environment variable HMOPT containts R), the history stack",
"    is restored from $HOME/.hmstack (if that file exist). The initial",
"    directory however, is always the current working directory.",
" Z  clears the history stack.",
" >  pushes the current place onto the pstack (you stay where you are).",
" <  pushes the current place onto the hstack and pops a place from the",
"    pstack and moves you there.",
NULL};

char *times[]={
"About the TIME of files (and directories)",
"-----------------------------------------",
"Every file has three times associated with it: mtime, ctime and atime.",
"These can be shown/hidden by the toggle options d, y and a respectively.",
"They can even be shown simultaneously (in the order as mentioned).",
"",
"mtime is the time of the last modification to the file; it is set by the",
"      system calls mknod, utime and write (and any subroutines that use",
"      those system calls). Can be changed to 'now' with the % command.",
"ctime is time of the last modification of the file status; it is set by",
"      the following system calls: chmod, chown, link, mknod, unlink,",
"      utime and write.",
"atime is the time when file data was last accessed. It is set by utime,",
"      mknod, truncate, write and read.",
"",
"The rules above are not fully implemented on all filesystems and all unix",
"implementations. For instance: atime might not be updated for directories",
"when they are searched (for efficiency).",
"",
"For other attributes of files and directories that can be shown or hidden,",
"see the g, i, n, p, s and u options.",
"----",
NULL};

char *visits[]={
"Visiting files and directories",
"------------------------------",
"The ^I, ^J and ^M commands (or their equivalent keys: Tab, Return, Enter)",
"visit files and directories. If the currently highlighted entry is a file,",
"its contents is simply shown through $PAGER (or 'more' if PAGER is not set).",
"If the contents of the file is not recognized as readable text, the od -c",
"command (or od -x if the X-option is set) will be used to show the file in",
"octal or hexadecimal. Normal Ascii mode (i.e. NOT using od) will be forced",
"by ^I (Tab).",
"",
"If the current entry is a directory, these commands are all equivalent and",
"will change to that the directory.",
"Special directories can be visited with ~ ($HOME), / (root), : (parent)",
"and previously visited directories with ^H (or BackSpace or Del).",
"You can also 'remember' places (directories and files) by the push command",
"(>) and go back to them later with the pop command (<).",
"Finally, quickly switching between two files or directories can be done with",
"the # command (see 'Mark options').",
NULL};

char *vw[]={
"Viewing the contents of files",
"-----------------------------",
"The following options show the contents of regular files:",
" ^A view compressed archive .tar tar.gz .tgz .bz2 .zip... with guitar",
" O  the file is shown by hexdump (and piped through $PAGER or less)",
" T  the last part of the file is shown (with tail -f) and fm waits for",
"    more data to show (hit ^C to continue).",
" v  view the file; this will force a hex dump view with the current",
"    file as argument. Typically, it will run less.",
" X  is a toggle switch; when set, the od command (O) will be changed to",
"    show the file in hexadecimal (od -x).",
"",
"Furthermore, the commands ^I, ^J and ^M and their equivalents (Tab, Enter",
"and Return) will simply pipe any regular file through $PAGER or less. Tab",
"will force the output to be ASCII (i.e. not use od even when it might be",
"necessary).",
"If the currently highlighted entry is a directory however, ^I, ^J and ^M",
"will switch to that directory.",
NULL};

char *war[]={
"                            NO WARRANTY",
"",
"BECAUSE THIS PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY",
"FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN",
"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES",
"PROVIDE THE PROGRAM 'AS IS' WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED",
"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF",
"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS",
"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE",
"PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,",
"REPAIR OR CORRECTION.",
"",
"IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING",
"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR",
"REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,",
"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING",
"OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED",
"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY",
"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER",
"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE",
"POSSIBILITY OF SUCH DAMAGES.",
"",
"                     END OF TERMS AND CONDITIONS",
NULL};

char *xct[]={
"Options to execute other programs",
"---------------------------------",
" x evaluate the currently highlighted file using 'x' script.",
"",
" E prompts for arguments and executes the currently highlighted file as",
"   command with the arguments appended.",
"",
" & same as E but also appends an & (i.e. it runs in the background).",
"",
" * prompts for a command; replaces every occurrence of {} in that command",
"   with the currently highlighted file and executes the command.",
"",
" ! spawns a subshell (using $SHELL or /bin/sh); the shell-prompt (PS1) is",
"   prefixed with fm:",
"",
"Except for x and the subshell, the commands to be executed are shown and",
"fm waits for confirmation; if you type y, the command is executed.",
NULL};

struct opthlp ih[] = {
	{ "Help by option", NULL },
	{ " INDEX OF SUBJECTS", NULL },
	{ "About fm", about },
	{ "Alternative (function) keys", altk },
	{ "Appearance (what's on the screen?)", screen },
	{ "Bugs (only the known bugs ...)", bugs },
	{ "Character attributes on the screen", highl },
	{ "Continuation and confirmation", cont },
	{ "Copyright notice", cr },
	{ "Environment variables used by fm", envi },
	{ "Execute options (spawning programs)", xct },
	{ "File attributes (show and change)", filat },
	{ "File contents information", filcont },
	{ "File operations", filop },
	{ "History of fm", hist },
	{ "Invocation (the fm command)", invo },
	{ "Link options", lnk },
	{ "Lsm entry (Linux Software Map)", lsm },
	{ "Mark options", mrk },
	{ "Miscelaneous options", misc },
	{ "Navigating between directories", navout },
	{ "Navigating within a directory", navin },
	{ "Opening screen", bnr },
	{ "Sort options", srt },
	{ "Stacks in fm and how to use them", stks },
	{ "Times (of files)", times },
	{ "Viewing the contents of files", vw },
	{ "Visiting files/directories", visits },
	{ "Warranty notice", war },
	{ NULL, NULL }
};

struct opthlp oh[] = {
	{ "Help by subject", NULL },
	{ " OPTIONS", NULL },
	{ "^A  archive...", vw },
	{ "A + sort by a", srt },
	{ "a + show atime", times },
	{ "B   back screen", navin },
	{ "b   see banner", misc },
	{ "q   quit", misc },
	{ "C   sum ...", filcont },
	{ "c   rcp -pr ...", filop },
	{ "D + sort by d", srt },
	{ "d + show mtime", times },
	{ "E   exec ...", xct },
	{ "e   edit ...", filop },
	{ "F   forw screen", navin },
	{ "f + follow link", lnk },
	{ "G   set gid", filop },
	{ "g + show gid", filat },
	{ "^H  go back", stks },
	{ "H   upper left", navin },
	{ "h   left", navin },
	{ "^I  visit (ASC)", visits },
	{ "I + sort by i", srt },
	{ "i + show inode", filat },
	{ "^J  visit", visits },
	{ "J   go to mark", mrk },
	{ "j   down", navin },
	{ "K   man -k ...", misc },
	{ "k   up", navin },
	{ "L   low right", navin },
	{ "l   right", navin },
	{ "^M  visit", visits },
	{ "M   man ...", misc },
	{ "m   mv -f ...", filop },
	{ "N   version?", misc },
	{ "n + show links", filat },
	{ "O   od ...", vw },
	{ "o   open dir", navout },
	{ "P   set mode", filop },
	{ "p + show mode", filat },
	{ "^C  pstack?", stks },
	{ "Q   stack?", stks },
	{ "^R  refresh", misc },
	{ "R + restore", stks },
	{ "r   rm -rf ...", filop },
	{ "S + sort by s", srt },
	{ "s + show size", filat },
	{ "T   tail -f", vw },
	{ "t   file ...", filcont },
	{ "U   set uid", filop },
	{ "u + show uid", filat },
	{ "V   set umask", misc },
	{ "v   hex view ...", vw },
	{ "W   mark?", mrk },
	{ "w   wc ...", filcont },
	{ "X   diff ...", mrk },
	{ "x   x ...", xct },
	{ "Y + sort by y", srt },
	{ "y + show ctime", times },
	{ "Z   clr stack", stks },
	{ "z   last entry", navin },
	{ "~   cd $HOME", navout },
	{ "!   shell", xct },
	{ "@   symb. link", lnk },
	{ "#   exchange", mrk },
	{ "$   sync", misc },
	{ "%   touch ...", filop },
	{ "^ + reverse", srt },
	{ "&   exec ... &", xct },
	{ "*   use ...", xct },
	{ "+   emphasize", highl },
	{ "-   highlight", highl },
	{ "=   hard link", lnk },
	{ "[   first dir", navin },
	{ "]   last dir", navin },
	{ "\\   set mark", mrk },
	{ ":   cd ..", navout },
	{ "<   pop", stks },
	{ ">   push", stks },
	{ ".   rescan", misc },
	{ "/   cd /", navout },
	{ "?   help", misc },
	{ " CONTINUE", NULL },
	{ "1 + return", cont },
	{ "2 + space", cont },
	{ "3 + command", cont },
	{ " OTHER KEYS", NULL },
#ifdef KEY_BACKSPACE
	{ "BackSpace =^H", stks },
#endif
#ifdef KEY_DEL
	{ "Delete    =^H", stks },
#endif
#ifdef KEY_END
	{ "End       = z", navin },
#endif
#ifdef KEY_ENTER
	{ "Enter     =^J", visits },
#endif
#ifdef KEY_F
	{ "F1        = ?", misc },
#endif
#ifdef KEY_HELP
	{ "Help      = ?", misc },
#endif
#ifdef KEY_HOME
	{ "Home      = H", navin },
#endif
#ifdef KEY_NPAGE
	{ "PageDown  = F", navin },
#endif
#ifdef KEY_PPAGE
	{ "PageUp    = B", navin },
#endif
	{ "Return    =^J", visits },
	{ "Tab       =^I", visits },
	{ " GENERAL INFO", NULL },
	{ "About fm", about },
	{ "Appearance", screen },
	{ "Bugs", bugs },
	{ "Copyright", cr },
	{ "Environment", envi },
	{ "Function keys", altk },
	{ "History", hist },
	{ "Invocation", invo },
	{ "Lsm entry", lsm },
	{ "Warranty", war },
	{ NULL, NULL }
};

void striplf(char *s)	/* Truncate string at rightmost line feed */
{
	char *sp;

	if((sp = strrchr(s, '\n'))) {
		*sp = '\0';
	}
}

void MvRight(int row, char *s)	/* Put string right adjusted on row */
{
	mvaddstr(row, COLS - strlen(s) - 1, s);
}

void goon(int fl)	/* Wait for user confirmation to go on */
{
//	attron(ats[high]);
	if(flags & RETURN)
		MvRight(LINES - 1, "Hit Return to continue");
	else if(flags & SPACE)
		MvRight(LINES - 1, "Hit Space to continue");
	else if((flags & ACTUAL) && (fl == 0))
		MvRight(LINES - 1, "Awaiting next command");
	else
		MvRight(LINES - 1, "Hit any key to continue");
//	attroff(ats[high]);
	noecho();	/* Typically needed when echo() is done and Error is called */
	refresh();
	if(flags & RETURN)
		while(((c = getch()) != '\r') && (c != '\n'));
	else if(flags & SPACE)
		while(getch() != ' ');
	else {
		while((c = getch()) == ERR);
		if((flags & ACTUAL) && (fl == 0)) flags |= DONE;
	}
}

int Confirm(char *s)	/* Need a YES or NO from the user */
{
	char yon[MAXSTR];

	mvaddstr(LINES - 1, 0, s);
	addstr(" (confirm with y) ");
	clrtoeol();
	refresh();
	echo();
	if(getstr(yon) != OK) {
		noecho();
		return(0);
	}
	noecho();
	return(strlen(yon) && (yon[0] == 'y' || yon[0] == 'Y'));
}

void Beep()
{
	putchar('\007');
	refresh();
}

void putscrn(char *scrn[])	/* Display one of the help screens */
{
	int j;

	clear();
	for(j = 0; scrn[j]; j++) mvaddstr(j, 0, scrn[j]);
	goon(1);
	clear();
}

void QuickRef(void)	/* Quick reference screen (after ?, Help or F1) */
{
	int i, j;
	int rw, cl;
	int mx, cur,ch;
	int tot;
	struct opthlp *hs;
	struct NBuf *nb;
	char flm[100];

	cur = 0;
	hs = oh;
	clear();
	while(1) {
		rw = 0;
		cl = 0;
		mx = 0;
		tot = 0;
		for(i = 0; hs[i].op; i++) {
			tot++;
			if(rw > LINES - 2) {
				cl += mx;
				attron(ats[high]);
				for(j = 0; j <= LINES - 2; j++) {
					mvaddch(j, cl, ' ');
				}
				attroff(ats[high]);
				cl += 2;
				mx = 0;
				rw = 0;
			}
			if(cur == i) attron(ats[high]);
			if(hs[i].op[0] == ' ') attron(ats[bold]);
			mvaddstr(rw++, cl, hs[i].op);
			attroff(ats[bold] | ats[high]);
			if(strlen(hs[i].op) > mx) mx = strlen(hs[i].op);
		}
		if(hs == oh) {
			mvaddstr(LINES - 3, cl, "Options with +");
			mvaddstr(LINES - 2, cl, "are toggles.  ");
		} else {
			attron(ats[bold]);
			mvaddstr(LINES - 5, cl, "fm internal info");
			attroff(ats[bold]);
			sprintf(flm, "Highlight method = %d", high);
			mvaddstr(LINES - 4, cl, flm);
			sprintf(flm, "Emphasize method = %d", bold);
			mvaddstr(LINES - 3, cl, flm);
			i = 0;
			for(nb = FreeList; nb; nb = nb->next) i++;
			sprintf(flm, "FreeList = %d x %d = %dKb", i, sizeof(struct NBuf),
				(i * sizeof(struct NBuf) + 512) / 1024);
			mvaddstr(LINES - 2, cl, flm);
		}
		attron(ats[high]);
		mvaddstr(LINES - 1, 0,
"Select item with arrow-keys and hit Return. Any other key leaves help.");
		attroff(ats[high]);
		refresh();
		while((ch = getch()) == ERR);
		switch(ch) {
		case 'h':
#ifdef KEY_LEFT
		case KEY_LEFT:
#endif
			do {
				cur = cur - LINES + 1;
				if(cur < 0) {
					cur--;
					while(cur + LINES - 1 < tot) {
						cur = cur + LINES - 1;
					}
				}
			} while(hs[cur].op[0] == ' ');
			break;
		case 'j':
#ifdef KEY_DOWN
		case KEY_DOWN:
#endif
			do {
				if(hs[++cur].op == NULL) cur = 0;
			} while(hs[cur].op[0] == ' ');
			break;
		case 'k':
#ifdef KEY_UP
		case KEY_UP:
#endif
			do {
				if(--cur < 0) cur = tot - 1;
			} while(hs[cur].op[0] == ' ');
			break;
		case 'l':
#ifdef KEY_RIGHT
		case KEY_RIGHT:
#endif
			do {
				cur = cur + LINES - 1;
				if(cur >= tot) {
					cur++;
					while(cur - LINES + 1 >= 0) {
						cur = cur - LINES + 1;
					}
				}
			} while(hs[cur].op[0] == ' ');
			break;
#ifdef KEY_ENTER
		case KEY_ENTER:
#endif
		case '\r': case '\n':
			if(cur == 0) {
				clear();
				if(hs == oh) hs = ih; else hs = oh;
			} else {
				putscrn(hs[cur].hlp);
			}
			break;
		default:
			return;
		}
	}
}

void Error(char *fmt, char *s) /* Any error, wait for user to swallow */
{
	char stmp[MAXSTR];

	Beep();
	sprintf(stmp, fmt, s);
	mvaddstr(LINES - 1, 0, stmp);
	clrtoeol();
	goon(0);
}

long filcmp(struct NBuf *file1, struct NBuf *file2)
/* Compare two files according to currently selected sorting criterium */
{
	long ltmp;

	ltmp = 0;
	if(flags & DATESORT) {
		ltmp = (long)file1->st.st_mtime - file2->st.st_mtime;
	}
	if(flags & ASORT) {
		ltmp = (long)file1->st.st_atime - file2->st.st_atime;
	}
	if(flags & CSORT) {
		ltmp = (long)file1->st.st_ctime - file2->st.st_ctime;
	}
	if(flags & SIZESORT) {
		ltmp = (long)file1->st.st_size - file2->st.st_size;
	}
	if(flags & ISORT) {
		ltmp = (long)file1->st.st_ino - file2->st.st_ino;
	}
	if(ltmp == 0) ltmp = (long)strcmp(file1->name, file2->name);
	return((flags & REV) ? -ltmp : ltmp);
}

/* Put an entry somewhere in the list of entries: directories first, other
   files after that and both sorted according to the currently selected
   sorting options. There are some gotcha's here ... */
void Insert(struct NBuf *new)
{
	struct NBuf *obj;

	if((new->st.st_mode & S_IFMT) == S_IFDIR) {
		if(List == NULL) {
			List = new;
			List->prev = NULL;
			List->next = NULL;
		} else {
			if((filcmp(new, List) < 0) || (Files == List)) {
				new->next = List;
				new->prev = NULL;
				List->prev = new;
				List = new;
			} else {
				for(obj = List; obj->next &&
					((obj->next->st.st_mode & S_IFMT) == S_IFDIR) &&
					(filcmp(new, obj->next) > 0); obj = obj->next);
				if(obj->next) {
					obj->next->prev = new;
				}
				new->next = obj->next;
				obj->next = new;
				new->prev = obj;
			}
		}
	} else {
		if(Files == NULL) {
			if(List == NULL) {
				List = new;
				List->prev = NULL;
				List->next = NULL;
				Files = List;
			} else {
				for(obj = List; obj->next; obj = obj->next);
				obj->next = new;
				new->prev = obj;
				new->next = NULL;
				Files = new;
			}
		} else {
			if(filcmp(new, Files) < 0) {
				if(Files->prev) {
					Files->prev->next = new;
				}
				new->prev = Files->prev;
				new->next = Files;
				Files->prev = new;
				if(List == Files) {
					List = new;
				}
				Files = new;
			} else {
				for(obj = Files; obj->next &&
					(filcmp(new, obj->next) > 0); obj = obj->next);
				if(obj->next) {
					obj->next->prev = new;
				}
				new->next = obj->next;
				obj->next = new;
				new->prev = obj;
			}
		}
	}
}

void Usage(char *s)
{
	fprintf(stderr, "\nUsage: %s [-%s] [path]\n", s, Options);
	fprintf(stderr,
"-h gives this text and exits; path opens path as initial directory.\n");
	fprintf(stderr,
"All other options are toggles (initially all off); they can be preset by\n");
	fprintf(stderr,
"defining environment variable HMOPT (e.g. HMOPT=3dfgpsu; export HMOPT).\n");
	fprintf(stderr, "Run %s and type ? for help about them.\n\n", s);
}

void InitCurses(void)
{
	initscr();
	noecho();
	raw();
#ifdef KEY_UP
	keypad(stdscr, TRUE);
	nodelay(stdscr, TRUE);
	while(getch() != ERR);		/* flush input buffer */
	nodelay(stdscr, FALSE);
#endif
	scrollok(stdscr, TRUE);
}

void EndCurses(void)
{
	move(LINES - 1, 0);
	clrtoeol();
	refresh();
#ifdef KEY_UP
	keypad(stdscr, FALSE);
#endif
	noraw();
	echo();
	endwin();
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
}

/* Generalized system(...) call. Takes care of stopping/starting curses,
   paged output, scrolling, error messages, clearing screen and autowrap */
void System(char *cmd, int sw_Options)
{
	int c, d;
	FILE *fp;

	if(sw_Options & sw_Clear1) clear();
	if(sw_Options & sw_End) EndCurses();
	if(sw_Options & sw_Pag) {
		sprintf(cmd + strlen(cmd), " | %s",
			getenv("PAGER") ? getenv("PAGER") : "edx");
	}
	if(sw_Options & sw_Check) {
		fp = popen(cmd, "r");
		d = 0;
		while((c = getc(fp)) != EOF) {
			sw_Options |= sw_Wait;
			if(sw_Options & sw_End) {
				putchar((char)c);
			} else {
				if(d++ % (COLS - 1) == 0) {
					scroll(stdscr);
					move(LINES - 1, 0);
					refresh();
				}
				addch(isspace(c) ? ' ' : (char)c);
			}
		}
		if(!(sw_Options & sw_End)) {
			scroll(stdscr);
			move(LINES - 1, 0);
			refresh();
		}
		pclose(fp);
	} else system(cmd);
	if(sw_Options & sw_Wait) {
		if(sw_Options & sw_End) {
			printf("[ Hit Return to go back to fm ] ");
			fflush(stdout);
			getchar();
		} else {
			goon(0);
		}
	}
	if(sw_Options & sw_Init) InitCurses();
}

/* Turn the name into a printable one */
char *pname(char *name)
{
	char *tmp, *tmp2;
	static char tmp3[MAXSTR];

	tmp2 = tmp3;
	for(tmp = name; *tmp; tmp++) {
		if((*tmp > 32) && (*tmp < 127)) {
			*(tmp2++) = *tmp;
		} else {
			sprintf(tmp2, "\\%03o", *tmp);
			tmp2 += 4;
		}
	}
	*tmp2 = '\0';
	return(tmp3);
}

/* Quote a filename by prefixing some characters with a backslash */
char *qname(char *name)
{
	char *tmp, *tmp2;
	static char tmp3[MAXSTR];

	tmp2 = tmp3;
	for(tmp = name; *tmp; tmp++) {
		if(!isalnum(*tmp) && !strchr("+-.:_~/", *tmp)) *(tmp2++) ='\\';
		*(tmp2++) = *tmp;
	}
	*tmp2 = '\0';
	return(tmp3);
}

/* Visit a file or directory; handles the commands Enter, T, O and paging */
void GoFile(int c)
{
	if(access(CurPtr->name, R_OK)) {
		Error("No permission to read %s", CurPtr->pname);
		return;
	}
	sprintf(aux, "file %s", CurPtr->qname);
	if(!(ls = popen(aux, "r"))) {
		Error("Can not open pipe for %s", CurPtr->pname);
		return;
	}
	if(!fgets(aux2, MAXSTR, ls)) {
		Error("Can not read from pipe %s", CurPtr->pname);
		pclose(ls);
		return;
	}
	pclose(ls);

	if(c!='T') {
		sprintf(aux, "cat %s 2>&1", CurPtr->qname);
	}
	if((c == 'O') || (!strstr(aux2, "text") && !strstr(aux2, "script") &&
		!strstr(aux2, "shell") && (c != '\t'))) {
		if(c == 'T') {
			Error("Can not tail -f %s", CurPtr->pname);
			return;
		} else {
//			sprintf(aux + strlen(aux), " | od -%c", flags & HEX ? 'x' : 'c');
			sprintf(aux + strlen(aux), " | hexdump");
		}
	}
	clear();
	if(c == 'T') {
		attron(ats[high]);
		MvRight(LINES - 2, "Hit ^C to return from tail -f");
		attroff(ats[high]);
		EndCurses();
#ifdef vfork
		if(p = vfork())
#else
		if((p = fork()))
#endif
			wait(&p);
		else {
			signal(SIGINT, SIG_DFL);
			signal(SIGQUIT, SIG_DFL);
			execlp("tail", "tail", "-f", CurPtr->qname, (char *)NULL);
		}
	} else {
		System(aux, sw_End | sw_Pag);
	}
	InitCurses();
}

/* Saveit is called every time the user changes directory and puts the current
   place onto the stack */
void saveit(void)
{
	struct Stack *ns;

	if((DirStack == NULL) || strcmp(DirStack->dir, Cwd) ||
		strcmp(DirStack->ent, CurPtr->name)) {
		if((ns = (struct Stack *)malloc(sizeof(struct Stack)))) {
			ns->next = DirStack;
			strcpy(ns->dir, Cwd);
			strcpy(ns->ent, CurPtr->name);
			ns->flgs = flags & SAVEFLAGS;
			DirStack = ns;
		}
	}
}

/* Show user we're doing something */
void working(char *w)
{
	mvaddstr(LINES - 1, 0, w);
	addstr(" ...");
	clrtoeol();
	refresh();
	move(LINES - 1, 0);
}

/* This handles navigating within the current directory. Parameter n denotes
   how many entries to go forward (>0) or backward (<0). Note that currently
   highlighted entry might not be visible anymore and a new one has to be
   choosen in an intuitive fashion */
void browse(int n)
{
	int nn;

	if(n < 0) {
		for(nn = n; nn && CurPtr->prev; nn++) {
			CurPtr = CurPtr->prev;
		}
	} else {
		for(nn = n; nn && CurPtr->next; nn--) {
			CurPtr = CurPtr->next;
		}
	}
	if(CurPtr->seq < Fos->seq) {
//		for(nn = ((n == -1) ? 3 - LINES : n); nn && Fos->prev; nn++){
		for(nn = n; nn && Fos->prev; nn++){
			Fos = Fos->prev;
		}
		return;
	}
	if(CurPtr->seq <= Los->seq) {
		return;
	}
//	for(nn = 1; nn <= ((n == 1) ? LINES - 3 : n); nn++) {
	for(nn = 1; nn <= n; nn++) {
		Fos = Fos->next;
		if(Los) {
			Los = Los->next;
		}
		if(((nn % (LINES - 2)) == 0) && (Los == NULL)) {
			return;
		}
	}
}

struct NBuf *mymalloc(void)
{
	struct NBuf *nb;

	if(FreeList) {
		nb = FreeList;
		FreeList = FreeList->next;
		return(nb);
	} else {
		return((struct NBuf *)malloc(sizeof(struct NBuf)));
	}
}

void myfree(struct NBuf *nb)
{
	if(nb) {
		nb->next = FreeList;
		FreeList = nb;
	}
}


int exec_main(int argc, char *argv[])
{
	char *av[2];
	static char saux[MAXSTR];
	struct stat st;
	struct NBuf *newn;
	int i;
	int row, col;
	char tp;
	char *tmp;
	long ltmp=0, mxn=0, mxs=0, mxu=0, mxg=0, mxi=0, mxl=0, maxlen=0;
	extern char *optarg;
	extern int optind, opterr;
	char ListEntry[MAXSTR];
	struct Stack *ns;
	struct group *gr;
	struct passwd *pw;
	long totdir=0, totdirs=0, lcount=0;
	time_t now;
	mode_t oumask;
	struct passwd *spwd;
	struct group *sgrp;
	char mark[MAXSTR] = { '\0' };

	if(getcwd(Cwd, MAXSTR-2) == NULL) {
		perror("getcwd");
		exit(1);
	}
//	flags = 0;	/* All options are OFF by default */
	flags = HIDE+MODE+USER+GROUP+DATE+SIZE+HEX;	/* these options "-bpugdsX" ON */
	high = -1;	/* means: highlight method not yet set */
	bold = -1;	/* means: bold mode not yet set */

	/* Handle any options in HMOPT (they'll be switched ON) */
	if((tmp = getenv("HMOPT"))) while(*tmp) {
		switch(c = *(tmp++)) {
			case '-': case ',': case ' ': break;
			case '1': flags |= RETURN; flags &= ~(SPACE | ACTUAL); break;
			case '2': flags |= SPACE; flags &= ~(RETURN | ACTUAL); break;
			case '3': flags |= ACTUAL; flags &= ~(RETURN | SPACE); break;
			case 'A': flags |= ASORT;
				flags &= ~(DATESORT | ISORT | CSORT | SIZESORT);
				break;
			case 'a': flags |= ACCESS; break;
			case 'b': flags |= HIDE; break;
			case 'D': flags |= DATESORT;
				flags &= ~(ASORT | ISORT | CSORT | SIZESORT);
				break;
			case 'd': flags |= DATE; break;
			case 'f': flags |= FOLLOW; break;
			case 'g': flags |= GROUP; break;
			case 'I': flags |= ISORT;
				flags &= ~(ASORT | DATESORT | CSORT | SIZESORT);
				break;
			case 'i': flags |= INODE; break;
			case 'n': flags |= LINKS; break;
			case 'p': flags |= MODE; break;
			case 'R': flags |= STACK; break;
			case 'S': flags |= SIZESORT;
				flags &= ~(ASORT | DATESORT | CSORT | ISORT);
				break;
			case 's': flags |= SIZE; break;
			case 'u': flags |= USER; break;
//			case 'X': flags |= HEX; break;
			case 'Y': flags |= CSORT;
				flags &= ~(ASORT | DATESORT | SIZESORT | ISORT);
				break;
			case 'y': flags |= CHANGE; break;
			case '^': flags |= REV; break;
			default:
				fprintf(stderr, "Unknown option in HMOPT (%c)\n", *(tmp-1));
				exit(6);
		}
	}

	/* Now handle any options on the command line. They will switch OFF any
       options that were found in HMOPT and switch ON others */
	while((c = getopt(argc, argv, Options)) != EOF) switch(c) {
		case '1': flags ^= RETURN;
			if(flags & RETURN) flags &= ~(ACTUAL | SPACE);
			break;
		case '2': flags ^= SPACE;
			if(flags & SPACE) flags &= ~(ACTUAL | RETURN);
			break;
		case '3': flags ^= ACTUAL;
			if(flags & ACTUAL) flags &= ~(RETURN | SPACE);
			break;
		case 'A': flags ^= ASORT;
			if(flags & ASORT) flags &= ~(DATESORT | ISORT | CSORT | SIZESORT);
			break;
		case 'a': flags ^= ACCESS; break;
		case 'b': flags ^= HIDE; break;
		case 'D': flags ^= DATESORT;
			if(flags & DATESORT) flags &= ~(ASORT | ISORT | CSORT | SIZESORT);
			break;
		case 'd': flags ^= DATE; break;
		case 'f': flags ^= FOLLOW; break;
		case 'g': flags ^= GROUP; break;
		case 'h': Usage(argv[0]); exit(0);
		case 'I': flags ^= ISORT;
			if(flags & ISORT) flags &= ~(ASORT | DATESORT | CSORT | SIZESORT);
			break;
		case 'i': flags ^= INODE; break;
		case 'n': flags ^= LINKS; break;
		case 'p': flags ^= MODE; break;
		case 'R': flags ^= STACK; break;
		case 'S': flags ^= SIZESORT;
			if(flags & SIZESORT) flags &= ~(ASORT | DATESORT | CSORT | ISORT);
			break;
		case 's': flags ^= SIZE; break;
		case 'u': flags ^= USER; break;
//		case 'X': flags ^= HEX; break;
		case 'Y': flags ^= CSORT;
			if(flags & CSORT) flags &= ~(ASORT | DATESORT | SIZESORT | ISORT);
			break;
		case 'y': flags ^= CHANGE; break;
		case '^': flags ^= REV; break;
		default: Usage(argv[0]); exit(2);
	}
	if(optind < argc) {
		strcpy(Cwd, argv[optind++]);
		if(chdir(Cwd)) {
			perror(Cwd);
			exit(3);
		}
	}
	if(optind < argc) {
		Usage(argv[0]);
		exit(5);
	}

	/* I N I T I A L I Z A T I O N */
	InitCurses();
	/* Set initial emphasize and highlighting attributes */
	for(i = 0; ats[i]; i++) bold = i;
	high = 0;
	/* Show GNU GPL banner if no b-option */
	if(!(flags & HIDE)) putscrn(bnr);
	List = NULL;
	CurPtr = NULL;
	flags |= HMBUSY;
	DirStack = NULL;
	Pstack = NULL;
	FreeList = NULL;

	/* Restore stack from $HOME/.hmstack (if any) */
	if((flags & STACK) && getenv("HOME")) {
		sprintf(aux, "%s/.hmstack", getenv("HOME"));
		if((ls = fopen(aux, "r"))) {
			while((ns = (struct Stack *)malloc(sizeof(struct Stack))) &&
				(fscanf(ls, "%s %s %lu", ns->dir, ns->ent, &(ns->flgs)) == 3)) {
				ns->next = DirStack;
				DirStack = ns;
				ns = NULL;
			}
			if(ns) free(ns);
			fclose(ls);
		}
	}
	/* End of initialization */

	while(flags & HMBUSY) {
		if(flags & DONE) {
			flags &= ~DONE;
			goto typed;
		}
/* Here's the simple essence of this whole pogram: the command that is
   executed to get all the entries in a directory. Because the ls-command
   is far from standardized, the only common option we're using is -a. The
   rest of all info is gathered from the stat-subroutine */
		if(CurPtr == NULL) {
			if((getcwd(Cwd, MAXSTR - 2) == NULL) ||
				((ls = popen("ls -a", "r")) == NULL)) {
				Error("Can not get cwd or read from pipe", "");
				if(chdir("..")) chdir("/");
				continue;
			} else {
				working("Reading directory");
                while(List) {
                    newn = List;
                    List = List->next;
                    myfree(newn);
                }
				Files = NULL;

				mxn=mxs=mxu=mxg=mxi=mxl = 0;
				totdir = totdirs = lcount = 0;
				while((newn = mymalloc()) &&
					(fgets(newn->name, NAME_MAX+1, ls))) {
					striplf(newn->name);
					if(lstat(newn->name, &newn->st)) {
						myfree(newn);
						newn = NULL;
						continue;
					}
					totdirs += newn->st.st_size;
					if(((newn->st.st_mode & S_IFMT) == S_IFLNK) &&
						(flags & FOLLOW)) stat(newn->name, &newn->st);
					if((pw = getpwuid(newn->st.st_uid))) {
						strcpy(newn->pw_name, pw->pw_name);
					} else {
						sprintf(newn->pw_name, "%d", newn->st.st_uid);
					}
					if((gr = getgrgid(newn->st.st_gid))) {
						strcpy(newn->gr_name, gr->gr_name);
					} else {
						sprintf(newn->gr_name, "%d", newn->st.st_gid);
					}
					strcpy(newn->qname, qname(newn->name));
					strcpy(newn->pname, pname(newn->name));
							
					Insert(newn);
					totdir++;
					if((flags & POP) &&
						(strcmp(newn->name, DirStack->ent) == 0)) {
						ns = DirStack->next;
						free(DirStack);
						DirStack = ns;
						CurPtr = newn;
						flags &= ~POP;
					}
					mxn = strlen(newn->pname) > mxn ?
						strlen(newn->pname) : mxn;
					mxl = newn->st.st_nlink > mxl ? newn->st.st_nlink : mxl;
					if(((newn->st.st_mode & S_IFMT) == S_IFBLK) ||
						((newn->st.st_mode & S_IFMT) == S_IFCHR)) {
							ltmp = 10 *
								(1 + (unsigned long)major(newn->st.st_rdev)) *
								(1 + (unsigned long)minor(newn->st.st_rdev));
						mxs = ltmp > mxs ? ltmp : mxs;
					} else {
						mxs = newn->st.st_size > mxs ? newn->st.st_size : mxs;
					}
					mxi = newn->st.st_ino > mxi ? newn->st.st_ino : mxi;
					mxu = strlen(newn->pw_name) > mxu
						? strlen(newn->pw_name) : mxu;
					mxg = strlen(newn->gr_name) > mxg
						? strlen(newn->gr_name) : mxg;
				}
				myfree(newn);
				pclose(ls);
			}
			if(List == NULL) {
//				Error("%s is not searchable for you", Cwd);
//				if(chdir("..")) chdir("/");
				continue;
			}
			lcount = 0;
			for(newn = List; newn; newn = newn->next) {
				newn->seq = ++lcount;
			}
			if(CurPtr == NULL) {
				CurPtr = List;
				Fos = List;
				if(flags & POP) {
					Error("Previous file is gone; back to %s", CurPtr->pname);
					flags &= ~POP;
				}
			} else {
				Fos = CurPtr;
				for(c = (LINES - 2) / 2; c && Fos->prev; c--) {
					Fos = Fos->prev;
				}
			}
		}
//printf("A done=%x, c=%x\n",flags & DONE,c);

		maxlen = mxn;
		if(flags & SIZE) maxlen += digs(mxs) + 1;
		if(flags & CHANGE) maxlen += 25;
		if(flags & DATE) maxlen += 25;
		if(flags & ACCESS) maxlen += 25;
		if(flags & INODE) maxlen += digs(mxi) + 1;
		if(flags & LINKS) maxlen += digs(mxl) + 1;
		if(flags & USER) maxlen += mxu + 1;
		if(flags & GROUP) maxlen += mxg + 1;
		if(flags & MODE) maxlen += 11;

		if(!gethostname(aux, MAXSTR - 1)) {
			if(strchr(aux, '.')) {
				*strchr(aux, '.') = '\0';
			}
			strcat(aux, ":");
			mvaddstr(0, 0, aux);
		} else {
			move(0, 0);
		}
		attron(ats[bold] | ats[high]);
		addstr(Cwd);
		attroff(ats[bold] | ats[high]);
		clrtoeol();
		time(&now);
		strcpy(aux, ctime(&now));
		*(strrchr(aux, ':')) = '\0';
		MvRight(0, aux);
        sprintf(aux, "%ld entries (", totdir);
        if(totdirs < 1000) {
            sprintf(aux + strlen(aux), "%ld bytes", totdirs);
        } else {
            if(totdirs < 1000000) {
                sprintf(aux + strlen(aux), "%ld Kb", (totdirs + 512) /
                    1024);
            } else {
                sprintf(aux + strlen(aux), "%ld Mb", (totdirs + 524288) /
                    1048576);
            }
        }
        oumask = umask(0022);
        umask(oumask);
        sprintf(aux + strlen(aux), "), umask=%03o, ", oumask);
		mvaddstr(1, 0, aux);
		if((spwd = getpwuid(getuid()))) {
#ifdef A_BLINK
			if(getuid() == 0) attron(A_BLINK);
#endif
			addstr(spwd->pw_name);
#ifdef A_BLINK
			attroff(A_BLINK);
#endif
			if((sgrp = getgrgid(getgid()))) {
				addstr(":"); addstr(sgrp->gr_name);
			}
		}
		clrtoeol();
		i = 0;
		if(flags & RETURN) aux[i++] = '1';
		if(flags & SPACE) aux[i++] = '2';
		if(flags & ACTUAL) aux[i++] = '3';
		if(flags & ASORT) aux[i++] = 'A';
		if(flags & ACCESS) aux[i++] = 'a';
		if(flags & DATESORT) aux[i++] = 'D';
		if(flags & DATE) aux[i++] = 'd';
		if(flags & FOLLOW) aux[i++] = 'f';
		if(flags & GROUP) aux[i++] = 'g';
		if(flags & ISORT) aux[i++] = 'I';
		if(flags & INODE) aux[i++] = 'i';
		if(flags & LINKS) aux[i++] = 'n';
		if(flags & MODE) aux[i++] = 'p';
		if(flags & STACK) aux[i++] = 'R';
		if(flags & SIZESORT) aux[i++] = 'S';
		if(flags & SIZE) aux[i++] = 's';
		if(flags & USER) aux[i++] = 'u';
//		if(flags & HEX) aux[i++] = 'X';
		if(flags & CSORT) aux[i++] = 'Y';
		if(flags & CHANGE) aux[i++] = 'y';
		if(flags & REV) aux[i++] = '^';
		if(i) {
			aux[i] = '\0';
			sprintf(aux2, "Options: %s", aux);
			MvRight(1, aux2);
		}

again:
		row = 2;
		col = 0;
		move(row, col);
		clrtobot();
		flags &= ~SEEN;
		for(newn = Fos; newn; newn = newn->next) {
			ListEntry[0] = '\0';
			if(flags & INODE) {
				sprintf(ListEntry, "%*lu ", digs(mxi), newn->st.st_ino);
			}
			if(flags & MODE) {
				switch(newn->st.st_mode & S_IFMT) {
				case S_IFDIR:
					tp = 'd';
					break;
				case S_IFCHR:
					tp = 'c';
					break;
				case S_IFBLK:
					tp = 'b';
					break;
				case S_IFLNK:
					tp = 'l';
					break;
				case S_IFSOCK:
					tp = 's';
					break;
				case S_IFIFO:
					tp = 'f';
					break;
				default:
					tp = '-';
					break;
				}
				i = strlen(ListEntry);
				ListEntry[i++] = tp;
				if(newn->st.st_mode & 0400) {
					ListEntry[i++] = 'r';
				} else {
					ListEntry[i++] = '-';
				}
				if(newn->st.st_mode & 0200) {
					ListEntry[i++] = 'w';
				} else {
					ListEntry[i++] = '-';
				}
				if(newn->st.st_mode & 0100) {
					if(newn->st.st_mode & 04000) {
						ListEntry[i++] = 's';
					} else {
						ListEntry[i++] = 'x';
					}
				} else {
					if(newn->st.st_mode & 04000) {
						ListEntry[i++] = 'S';
					} else {
						ListEntry[i++] = '-';
					}
				}
				if(newn->st.st_mode & 0040) {
					ListEntry[i++] = 'r';
				} else {
					ListEntry[i++] = '-';
				}
				if(newn->st.st_mode & 0020) {
					ListEntry[i++] = 'w';
				} else {
					ListEntry[i++] = '-';
				}
				if(newn->st.st_mode & 0010) {
					if(newn->st.st_mode & 02000) {
						ListEntry[i++] = 's';
					} else {
						ListEntry[i++] = 'x';
					}
				} else {
					if(newn->st.st_mode & 02000) {
						ListEntry[i++] = 'S';
					} else {
						ListEntry[i++] = '-';
					}
				}
				if(newn->st.st_mode & 0004) {
					ListEntry[i++] = 'r';
				} else {
					ListEntry[i++] = '-';
				}
				if(newn->st.st_mode & 0002) {
					ListEntry[i++] = 'w';
				} else {
					ListEntry[i++] = '-';
				}
				if(newn->st.st_mode & 0001) {
					if(newn->st.st_mode & 01000) {
						ListEntry[i++] = 't';
					} else {
						ListEntry[i++] = 'x';
					}
				} else {
					if(newn->st.st_mode & 01000) {
						ListEntry[i++] = 'T';
					} else {
						ListEntry[i++] = '-';
					}
				}
				ListEntry[i++] = ' ';
				ListEntry[i] = '\0';
			}
			if(flags & LINKS) {
				sprintf(ListEntry + strlen(ListEntry), "%*d ",
					digs(mxl), newn->st.st_nlink);
			}
			if(flags & USER) {
				sprintf(ListEntry + strlen(ListEntry), "%*s ",
					(int)mxu, newn->pw_name);
			}
			if(flags & GROUP) {
				sprintf(ListEntry + strlen(ListEntry), "%*s ",
					(int)mxg, newn->gr_name);
			}
			if(flags & SIZE) {
				if(((newn->st.st_mode & S_IFMT) == S_IFBLK) ||
					((newn->st.st_mode & S_IFMT) == S_IFCHR)) {
					sprintf(aux, "%u,%u", major(newn->st.st_rdev),
						minor(newn->st.st_rdev));
					sprintf(ListEntry + strlen(ListEntry), "%*s ",
						digs(mxs), aux);
				} else {
					sprintf(ListEntry + strlen(ListEntry), "%*lu ",
						digs(mxs), newn->st.st_size);
				}
			}
			if(flags & DATE) {
				strcpy(aux, ctime(&newn->st.st_mtime));
				striplf(aux);
				sprintf(ListEntry + strlen(ListEntry), "%s ", &(aux[4]));
			}
			if(flags & CHANGE) {
				strcpy(aux, ctime(&newn->st.st_ctime));
				striplf(aux);
				sprintf(ListEntry + strlen(ListEntry), "%s ", &(aux[4]));
			}
			if(flags & ACCESS) {
				strcpy(aux, ctime(&newn->st.st_atime));
				striplf(aux);
				sprintf(ListEntry + strlen(ListEntry), "%s ", &(aux[4]));
			}
			strcat(ListEntry, newn->pname);
			if(row > LINES - 2) {
				if(col + maxlen + 1 < COLS - maxlen) {
					attron(ats[high]);
					for(row = 2; row < LINES - 1; row++) {
						mvaddch(row, col + maxlen, ' ');
					}
					attroff(ats[high]);
					col += maxlen + 1;
					row = 2;
				} else {
					break;
				}
			}
			Los = newn;
			if((newn->st.st_mode & S_IFMT) == S_IFDIR) attron(ats[bold]);
			if(CurPtr == newn) {
				flags |= SEEN;
				attron(ats[high]);
			}
			ListEntry[COLS - col] = '\0';
			mvaddstr(row++, col, ListEntry);
			attroff(ats[high] | ats[bold]);
		}
		if(!(flags & SEEN)) {
			Fos = CurPtr;
			for(i = (LINES - 2) / 2; i && Fos->prev; i--) {
				Fos = Fos->prev;
			}
			goto again;
		}

		mvaddstr(LINES - 1, 0, "Option? (? for help, 'q' for quit)");
		clrtoeol();
		refresh();

		c = getch();
typed:
		switch(c) {
		case 'A':
			flags ^= ASORT;
			if(flags & ASORT) {
				flags &= ~(DATESORT | SIZESORT | CSORT | ISORT);
			}
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case 'a':
			flags ^= ACCESS;
			break;
		case 'B':
#ifdef KEY_PPAGE
		case KEY_PPAGE:
#endif
			i = ((COLS + 1) / (maxlen + 1)) * (3 - LINES);
			browse(i == 0 ? 3 - LINES : i);
			break;
		case 'b':
			putscrn(bnr);
			break;
		case '\010':	/* ^H */
		case '\177':    /* rubout */
#ifdef KEY_DEL
		case KEY_DEL:
#endif
#ifdef KEY_BACKSPACE
		case KEY_BACKSPACE:
#endif
			while(DirStack) {
				if(chdir(DirStack->dir)) {
					Error("Directory %s is not accessible anymore",
						DirStack->dir);
					ns = DirStack->next;
					free(DirStack);
					DirStack = ns;
					continue;
				}
				sprintf(aux, "%s/%s", DirStack->dir, DirStack->ent);
				if(lstat(aux, &st)) {
					Error("Entry %s does not exist anymore", aux);
					ns = DirStack->next;
					free(DirStack);
					DirStack = ns;
					continue;
				}
				strcpy(Cwd, DirStack->dir);
				CurPtr = NULL;
				flags &= ~SAVEFLAGS;
				flags |= DirStack->flgs;
				flags |= POP;
				c = '\0';
				break;
			}
			if(CurPtr) {
				Error("No previous path to go to", "");
			}
			break;
		case 'C':
		case 'w':
			if((CurPtr->st.st_mode & S_IFMT) != S_IFREG) {
				Error("%s is not a regular file", CurPtr->pname);
				break;
			}
			/* Fall thru!!! */
		case 't':
			switch(c) {
			case 'C':
				working("Computing checksum");
				sprintf(aux, "sum %s 2>&1", CurPtr->qname);
				break;
			case 't':
				working("Determining file type");
#ifdef __sgi
				sprintf(aux, "file -h %s 2>&1", CurPtr->qname);
#else
				sprintf(aux, "file %s 2>&1", CurPtr->qname);
#endif
				break;
			case 'w':
				working("Counting lines, words and characters");
				sprintf(aux, "wc %s 2>&1", CurPtr->qname);
				break;
			}
			System(aux, sw_Check);
			break;
		case 'c':
			if(((CurPtr->st.st_mode & S_IFMT) != S_IFDIR) &&
				((CurPtr->st.st_mode & S_IFMT) != S_IFREG)) {
				Error("%s is not a directory or regular file",
					CurPtr->pname);
				break;
			}
			sprintf(aux, "Copy %s %s to ",
				(CurPtr->st.st_mode & S_IFMT) == S_IFDIR ?
				"whole directory" : "file", CurPtr->pname);
			mvaddstr(LINES - 1, 0, aux);
			clrtoeol();
			refresh();
			echo();
			if((getstr(aux2) == OK) && strlen(aux2) && strcmp(aux2, ".")) {
				if((CurPtr->st.st_mode & S_IFMT) == S_IFDIR) {
					if(strchr(aux2, ':') || ((!stat(aux2, &st)) &&
						((st.st_mode & S_IFMT) == S_IFDIR))) {
						sprintf(aux, "rcp -rp %s %s 2>&1",
							CurPtr->qname, qname(aux2));
					} else {
						Error("%s is not an existing directory", pname(aux2));
						noecho();
						break;
					}
				} else {
					sprintf(aux, "rcp -p %s %s 2>&1",
						CurPtr->qname, qname(aux2));
				}
				working("Copying");
				System(aux, sw_Check);
			}
			noecho();
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case 'D':
			flags ^= DATESORT;
			if(flags & DATESORT) {
				flags &= ~(ASORT | SIZESORT | CSORT | ISORT);
			}
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case 'd':
			flags ^= DATE;
			break;
		case '&':
		case 'E':
			if(((CurPtr->st.st_mode & S_IFMT) != S_IFREG) ||
				access(CurPtr->name, X_OK)) {
				Error("%s is not an executable file", CurPtr->pname);
				break;
			}
			mvaddstr(LINES - 1, 0, "Arguments? ");
			/* Fall thru!!! */
		case '*':
			if(c == '*') mvaddstr(LINES - 1, 0, "Command? ({} is replaced) ");
			clrtoeol();
			refresh();
			echo();
			if(getstr(aux) != OK) {
				noecho();
				break;
			}
			if(c == '*') while((tmp = strstr(aux, "{}"))) {
				*(tmp++) = '%'; *tmp = 's';
				sprintf(aux2, aux, CurPtr->qname);
				strcpy(aux, aux2);
			} else sprintf(aux2, "./%s %s", CurPtr->qname, aux);
			if(c == '&') {
				strcat(aux2, " &");
			}
			if(Confirm(aux2)) {
				System(aux2, sw_End | sw_Init | sw_Wait);
			}
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case '\01':	// ^A
		case 'x':
		case 'e':
		case 'v':
			if((CurPtr->st.st_mode & S_IFMT) != S_IFREG) {
				Error("Can not edit/view %s (not a regular file)",
					CurPtr->pname);
				break;
			}
			if(c == '\01') {
				sprintf(aux, "guitar %s &", CurPtr->qname);
			} else if(c == 'x') {
				sprintf(aux, "x %s &", CurPtr->qname);
			} else if(c == 'e') {
				sprintf(aux, "%s %s", getenv("EDITOR") == NULL ?
					"edx" : getenv("EDITOR"), CurPtr->qname);
			} else {
				sprintf(aux, "hexdump %s | edx", CurPtr->qname);
			}
			System(aux, sw_End | sw_Init);
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case 'F':
#ifdef KEY_NPAGE
		case KEY_NPAGE:
#endif
			i = ((COLS + 1) / (maxlen + 1)) * (LINES - 3);
			browse(i == 0 ? LINES - 3 : i);
			break;
		case 'f':
			flags ^= FOLLOW;
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case 'G':
			mvaddstr(LINES - 1, 0, "New guid? ");
			clrtoeol();
			refresh();
			echo();
			if((getstr(aux) != OK) ||
				(strlen(aux) == 0) ||
				((gr = getgrnam(aux)) == NULL) ||
				(chown(CurPtr->name, (uid_t)-1, gr->gr_gid) != 0)) {
				Error("Can not change group to %s", aux);
			}
			c = '.';
			flags |= DONE;
			noecho();
			break;
		case 'g':
			flags ^= GROUP;
			break;
#ifdef KEY_HOME
		case KEY_HOME:
#endif
		case 'H':
			CurPtr = Fos;
			break;
		case 'h':
#ifdef KEY_LEFT
		case KEY_LEFT:
#endif
			browse(3 - LINES);
			break;
		case 'I':
			flags ^= ISORT;
			if(flags & ISORT) {
				flags &= ~(ASORT | DATESORT | CSORT | SIZESORT);
			}
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case 'i':
			flags ^= INODE;
			break;
		case 'J':
		case '#':
			if(!strlen(mark)) {
				Error("Mark not set", "");
				break;
			}
			strcpy(aux, mark);
			ns = (struct Stack *)malloc(sizeof(struct Stack));
			ns->next = DirStack;
			DirStack = ns;
			tmp = strrchr(aux, '/');
			strcpy(ns->ent, ++tmp);
			*(--tmp) = '\0';
			strcpy(ns->dir, aux);
			ns->flgs = flags & SAVEFLAGS;
			if(c == '#') sprintf(mark, "%s/%s", CWD, CurPtr->name);
			c = '\010';
			flags |= DONE;
			break;
		case 'j':
#ifdef KEY_DOWN
		case KEY_DOWN:
#endif
			browse(1);
			break;
		case 'K':
		case 'M':
			sprintf(aux, "man%s %s", (c=='K') ? " -k" : "", CurPtr->qname);
			if(c == 'K') System(aux, sw_End | sw_Init | sw_Clear1 | sw_Pag);
			else System(aux, sw_End | sw_Init | sw_Clear1 | sw_Wait);
			break;
		case 'k':
#ifdef KEY_UP
		case KEY_UP:
#endif
			browse(-1);
			break;
		case 'L':
			CurPtr = Los;
			break;
		case 'l':
#ifdef KEY_RIGHT
		case KEY_RIGHT:
#endif
			browse(LINES - 3);
			break;
		case 'm':
			if(((CurPtr->st.st_mode & S_IFMT) != S_IFDIR) &&
				((CurPtr->st.st_mode & S_IFMT) != S_IFREG)) {
				Error("%s is not a directory or regular file", CurPtr->pname);
				break;
			}
			if(!strcmp(CurPtr->name, ".") || !strcmp(CurPtr->name, "..")) {
				Error("Moving %s is not allowed (for your own safety)",
					CurPtr->pname);
				break;
			}
			sprintf(aux, "Move (copy if needed) %s to ", CurPtr->pname);
			mvaddstr(LINES - 1, 0, aux);
			clrtoeol();
			refresh();
			echo();
			if((getstr(aux2) == OK) && strlen(aux2) && strcmp(aux2, ".")) {
				sprintf(aux, "Move %s to %s?", CurPtr->pname, pname(aux2));
				if(Confirm(aux)) {
					working("Moving");
					sprintf(aux,
"mv -f %s %s > /dev/null 2>&1 || ( cp -pr %s %s 2>&1 && rm -rf %s 2>&1 )",
						CurPtr->qname, qname(aux2), CurPtr->qname,
						qname(aux2), CurPtr->qname);
					System(aux, sw_Check);
				}
			}
			noecho();
			CurPtr = NULL;
			break;
		case 'N':
			strcpy(aux, Version);
			for(tmp = aux; *tmp; tmp++) {
				if(*tmp == '\t') {
					*tmp = ' ';
				}
			}
			mvaddstr(LINES - 1, 0, aux);
			clrtoeol();
			goon(0);
			break;
		case 'n':
			flags ^= LINKS;
			break;
		case 'O':
		case 'T':
			GoFile(c);
			break;
		case 'o':
			mvaddstr(LINES - 1, 0, "Directory to visit or create? ");
			clrtoeol();
			refresh();
			echo();
			if((getstr(aux) == OK) && strlen(aux)) {
				if(stat(aux, &st)) {
					sprintf(aux2, "Create directory %s?", pname(aux));
					if(Confirm(aux2)) {
						if(mkdir(aux, (mode_t)0777)) {
							Error("Can not create directory %s", pname(aux));
						} else {
							noecho();
							saveit();
							c = '\010';
							flags |= DONE;
						}
					}
				} else {
					if((st.st_mode & S_IFMT) != S_IFDIR) {
						Error("%s is not a directory", pname(aux));
					} else {
						if(chdir(aux)) {
							Error("Can not go to %s", pname(aux));
						} else {
							saveit();
							strcpy(Cwd, aux);
							CurPtr = NULL;
						}
					}
				}
			}
			noecho();
			break;
		case 'P':
			mvaddstr(LINES - 1, 0, "New protection (octal)? ");
			clrtoeol();
			refresh();
			echo();
			if((getstr(aux) != OK) ||
				(strlen(aux) == 0) ||
				(sscanf(aux, "%o", &c) != 1) ||
				(chmod(CurPtr->name, (mode_t)c) != 0)) {
				Error("Can not change mode to %s", aux);
			}
			c = '.';
			flags |= DONE;
			noecho();
			break;
		case 'p':
			flags ^= MODE;
			break;
//
		case 'Q':
		case '\03':
			clear();
			i = 1;
			if(c == 'Q') {
				mvaddstr(0, 0, "Places visited:");
				ns = DirStack;
			} else {
				mvaddstr(0, 0, "Push down stack:");
				ns = Pstack;
			}
			for( ; ns; ns = ns->next) {
				sprintf(aux, "%s/%s", ns->dir, ns->ent);
				mvaddstr(i++, 0, aux);
				if(i >= LINES - 2) {
					mvaddstr(i, 0, "[more ...]");
					break;
				}
			}
			goon(0);
			break;
//		case ERR:
		case 'q':
			flags &= ~HMBUSY;
			break;
		case 'R':
			flags ^= STACK;
			break;
		case 'r':
			if(!strcmp(CurPtr->name, ".") || !strcmp(CurPtr->name, "..")) {
				Error("Removing %s is not allowed (for your own safety)",
					CurPtr->pname);
				break;
			}
			sprintf(aux, "Remove %s %s?",
				(CurPtr->st.st_mode & S_IFMT) == S_IFDIR ?
				"whole directory" : "file", CurPtr->pname);
			if(Confirm(aux)) {
				if((CurPtr->st.st_mode & S_IFMT) == S_IFDIR) {
					sprintf(aux, "rm -rf %s 2>&1", CurPtr->qname);
					working("Removing");
					System(aux, sw_Check);
					CurPtr = NULL;
				} else {
					if(unlink(CurPtr->name)) {
						Error("Can not remove %s", CurPtr->pname);
					} else {
						if(CurPtr->prev) {
							CurPtr->prev->next = CurPtr->next;
						}
						if(CurPtr->next) {
							CurPtr->next->prev = CurPtr->prev;
						}
						for(newn = CurPtr->next; newn; newn = newn->next) {
							newn->seq -= 1;
						}
						newn = CurPtr;
						if(newn->next) {
							CurPtr = newn->next;
						} else {
							CurPtr = newn->prev;
						}
						myfree(newn);
						c = '.';
						flags |= DONE;
					}
				}
			}
			break;
		case 'S':
			flags ^= SIZESORT;
			if(flags & SIZESORT) {
				flags &= ~(ASORT | DATESORT | CSORT | ISORT);
			}
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case 's':
			flags ^= SIZE;
			break;
		case 'U':
			mvaddstr(LINES - 1, 0, "New uid? ");
			clrtoeol();
			refresh();
			echo();
			if((getstr(aux) != OK) ||
				(strlen(aux) == 0) ||
				((pw = getpwnam(aux)) == NULL) ||
				(chown(CurPtr->name, pw->pw_uid, (gid_t)-1) != 0)) {
				Error("Can not change owner to %s", aux);
			}
			c = '.';
			flags |= DONE;
			noecho();
			break;
		case 'u':
			flags ^= USER;
			break;
		case 'V':
			mvaddstr(LINES - 1, 0, "New umask? ");
			clrtoeol();
			refresh();
			echo();
			if((getstr(aux) == OK) && (sscanf(aux, "%o", &oumask) == 1) &&
				(oumask <= (mode_t)0777)) umask(oumask);
			c = '.';
			flags |= DONE;
			noecho();
			break;
		case 'W':
			if(!strlen(mark)) Error("Mark not set", "");
			else {
				mvaddstr(LINES - 1, 0, mark);
				clrtoeol();
				goon(0);
			}
			break;
/*		case 'X':
			flags ^= HEX;
			break;
*/
//		case 'x':
		case 'X':
			if(!strlen(mark)) {
				Error("Mark not set", "");
				break;
			}
			sprintf(aux, "diff -r -C 3 %s %s 2>&1",
				qname(mark), CurPtr->qname);
			System(aux, sw_End | sw_Pag | sw_Init);
			break;
		case 'Y':
			flags ^= CSORT;
			if(flags & CSORT) {
				flags &= ~(DATESORT | SIZESORT | ASORT | ISORT);
			}
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case 'y':
			flags ^= CHANGE;
			break;
		case 'Z':
			while(DirStack) {
				ns = DirStack;
				DirStack = DirStack->next;
				free(ns);
			}
			break;
#ifdef KEY_END
		case KEY_END:
#endif
		case 'z':
			while(CurPtr->next) CurPtr = CurPtr->next;
			break;
		case '~':
			if(chdir(getenv("HOME"))) {
				Error("Can not go to $HOME", "");
			} else {
				saveit();
				strcpy(Cwd, getenv("HOME"));
				CurPtr = NULL;
			}
			break;
		case '!':
			EndCurses();
			if(getenv("PS1")) {
				strcpy(aux2, getenv("PS1"));
				sprintf(saux, "PS1=fm:%s", aux2);
				putenv(saux);
			} else {
				aux2[0] = '\0';
			}
			if(getenv("SHELL")) {
				strcpy(aux, getenv("SHELL"));
			} else {
				strcpy(aux, "/bin/sh");
			}
			av[0] = aux;
			av[1] = NULL;
#ifdef vfork
			if(p = vfork())	/* Note: the single equalsign is intentional */
#else
			if((p = fork()))
#endif
				wait(&p);
			else {
				signal(SIGINT, SIG_DFL);
				signal(SIGQUIT, SIG_DFL);
				execv(aux, av);
			}
			if(strlen(aux2)) {
				sprintf(saux, "PS1=%s", aux2);
				putenv(saux);
			}
			InitCurses();
			clear();
			CurPtr = NULL;
			break;
		case '@':
		case '=':
			sprintf(aux, "%s link %s to ",
				(c == '=') ? "Hard" : "Symbolic", CurPtr->pname);
			mvaddstr(LINES - 1, 0, aux);
			clrtoeol();
			refresh();
			echo();
			if((getstr(aux) == OK) && strlen(aux)) {
				if((c == '=') ? link(CurPtr->name, aux) :
					symlink(CurPtr->name, aux))
					Error("Can not create link %s", pname(aux));
					c = '.';
					flags |= DONE;
			}
			noecho();
			break;
		case '$':
			sync();
			break;
		case '%':
			if(utimes(CurPtr->name, NULL))
				Error("Error setting file times","");
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case '^':
			flags ^= REV;
			saveit();
			CurPtr = NULL;
			flags |= POP;
			break;
		case '+':
			while(ats[++bold] == 0 || bold == high) {
				if(ats[bold] == 0) bold = -1;
			}
			clear();
			break;
		case '-':
			while(ats[++high] == 0 || high == bold) {
				if(ats[high] == 0) high = -1;
			}
			clear();
			break;
		case '[':
			CurPtr = List;
			break;
		case ']':
			if(Files) {
				CurPtr = Files->prev;
			} else {
				c = 'z';
				flags |= DONE;
			}
			break;
		case '\\':
			sprintf(mark, "%s/%s", CWD, CurPtr->name);
			break;
		case ':':
			if(chdir("..")) {
				Error("Can not go to parent directory", "");
			} else {
				saveit();
				strcpy(Cwd, "..");
				CurPtr = NULL;
			}
			break;
		case '\022': /* Cntrl-R */
			clear();
			break;
		case '/':
			saveit();
			chdir("/");
			strcpy(Cwd, "/");
			CurPtr = NULL;
			break;
		case '.':
			saveit();
			c = '\010';
			flags |= DONE;
			break;
		case '\t':
		case '\r':
		case '\n':
#ifdef KEY_ENTER
		case KEY_ENTER:
#endif
			switch(CurPtr->st.st_mode & S_IFMT) {
			case S_IFDIR:
				if(chdir(CurPtr->name)) {
					Error("Can not change directory to %s", CurPtr->pname);
				} else {
					saveit();
					strcpy(Cwd, CurPtr->name);
					CurPtr = NULL;
				}
				break;
			case S_IFREG:
				GoFile(c);
				break;
			case S_IFLNK:
				aux[0] = '\0';
				if((c = readlink(CurPtr->name, aux, MAXSTR)) < 1) {
					Error("Can not read link %s", CurPtr->pname);
				} else {
					aux[c] = '\0';
					if(stat(aux, &st)) {
						Error("Can not get status of %s",
							strlen(aux) ? pname(aux) : CurPtr->pname);
					} else {
						if((st.st_mode & S_IFMT) != S_IFDIR) {
							saveit();
							ns = (struct Stack *)malloc(sizeof(struct Stack));
							ns->next = DirStack;
							DirStack = ns;
							if((tmp = strrchr(aux, '/')) == NULL) {
								strcpy(ns->ent, aux);
								strcpy(ns->dir, ".");
							} else {
								strcpy(ns->ent, ++tmp);
								*tmp = '\0';
								strcpy(ns->dir, aux);
							}
							ns->flgs = flags & SAVEFLAGS;
							c = '\010';
							flags |= DONE;
						} else {
							if(chdir(aux)) {
								Error("Can not go to %s", pname(aux));
							} else {
								saveit();
								strcpy(Cwd, aux);
								CurPtr = NULL;
							}
						}
					}
				}
				break;
			default:
				Error("%s is not a file, directory or symbolic link",
					CurPtr->pname);
				break;
			}
			break;
		case '>':
			if((Pstack == NULL) || strcmp(Cwd, Pstack->dir) ||
				strcmp(CurPtr->name, Pstack->ent)) {
				if((ns = (struct Stack *)malloc(sizeof(struct Stack)))) {
					ns->next = Pstack;
					ns->flgs = flags & SAVEFLAGS;
					strcpy(ns->dir, Cwd);
					strcpy(ns->ent, CurPtr->name);
					Pstack = ns;
				} else {
					Error("Can not get memory for Stack", "");
				}
			}
			break;
		case '<':
			if(Pstack == NULL) {
				Error("Stack is empty", "");
			} else {
				saveit();
				ns = Pstack->next;
				Pstack->next = DirStack;
				DirStack = Pstack;
				flags &= ~SAVEFLAGS;
				flags |= Pstack->flgs;
				Pstack = ns;
				c = '\010';
				flags |= DONE;
				break;
			}
			break;
#ifdef KEY_HELP
		case KEY_HELP:
#endif
#ifdef KEY_F
		case KEY_F(1):
#endif
		case '?':
			QuickRef();
			break;
		case '1':
			flags ^= RETURN;
			if(flags & RETURN) flags &= ~(SPACE | ACTUAL);
			break;
		case '2':
			flags ^= SPACE;
			if(flags & SPACE) flags &= ~(RETURN | ACTUAL);
			break;
		case '3':
			flags ^= ACTUAL;
			if(flags & ACTUAL) flags &= ~(RETURN | SPACE);
			break;
		default:
//			Beep();
			break;
		}
	}
	erase();
	EndCurses();
	signal(SIGINT, SIG_DFL);
	signal(SIGQUIT, SIG_DFL);
	saveit();
	if((flags & STACK) && getenv("HOME")) {
		sprintf(aux, "%s/.hmstack", getenv("HOME"));
		if((ls = fopen(aux, "w"))) {
			while(DirStack) {
				fprintf(ls, "%s %s %lu\n", DirStack->dir, DirStack->ent,
					DirStack->flgs);
				DirStack = DirStack->next;
			}
			fclose(ls);
		}
	}
	exit(0);
}
