
/***************************************************************************
 *
 * $Header: view.c
 *
 * View-Kommando-Bearbeitung
 *
 ***************************************************************************/

#include "txplor.h"

static int ViewFile(char *file_path);

int
View(char *file_path)
{
	switch (mode) {
	case DISK_MODE:
	case USER_MODE:
		return (ViewFile(file_path));
	case TAPE_MODE:
	default:
//		beep();
		return (-1);
	}
}

static int
ViewFile(char *file_path)
{
	char *command_line, *aux;
	int result = -1;
	char *file_p_aux;
	BOOL notice_mapped = FALSE;

	command_line = file_p_aux = NULL;

	if ((file_p_aux = (char *) malloc(COMMAND_LINE_LENGTH + 1)) == NULL) {
		ERROR_MSG("Malloc failed*ABORT");
		exit(1);
	}
	StrCp(file_p_aux, file_path);

	if (access(file_path, R_OK)) {
		(void) sprintf(message,
					   "View not possible!*\"%s\"*%s",
					   file_path, strerror(errno));
		MESSAGE(message);
		ESCAPE;
	}

	if ((command_line = malloc(COMMAND_LINE_LENGTH + 1)) == NULL) {
		ERROR_MSG("Malloc failed*ABORT");
		exit(1);
	}

	if ((aux = GetExtViewer(file_path)) != NULL) {
		if (strstr(aux, "%s") != NULL) {
			(void) sprintf(command_line, aux, file_p_aux);
		} else
			(void) sprintf(command_line, "%s %s", aux, file_p_aux);
	} else {
		(void) sprintf(command_line, "%s %s", PAGER, file_p_aux);
	}

	if ((result = SystemCall(command_line))) {
		(void) sprintf(message, "can't execute*%s", command_line);
		MESSAGE(message);
	}

	if (notice_mapped) {
		UnmapNoticeWindow();
	}

  FNC_XIT:

	if (file_p_aux)
		free(file_p_aux);
	if (command_line)
		free(command_line);

	return (result);
}
