
/***************************************************************************
 *
 * $Header: system.c
 *
 * System Call
 *
 ***************************************************************************/

#include "txplor.h"

int SYSTEM (char *cmd);

int
SystemCall(char *command_line)
{
	int result;

#ifndef XCURSES
	endwin();
#endif
	result = SilentSystemCall(command_line);

	(void) GetAvailBytes(&statistic.disk_space);

	return (result);
}

int
QuerySystemCall(char *command_line)
{
	int result;

#ifndef XCURSES
	endwin();
#endif
	result = SilentSystemCall(command_line);
	HitReturnToContinue();
	(void) GetAvailBytes(&statistic.disk_space);

	return (result);
}

extern struct itimerval value, ovalue;

int
SilentSystemCall(char *command_line)
{
	int result;
#ifdef XCURSES
	char *xterm = NULL;
#endif

#ifdef CLOCK_SUPPORT
	struct itimerval value, ovalue;
#endif

	/* Hier ist die einzige Stelle, in der Kommandos aufgerufen werden! */

#if defined( __NeXT__ )
	nl();
#endif							/* linux */

#ifdef CLOCK_SUPPORT
	value.it_interval.tv_sec = 0;
	value.it_value.tv_sec = 0;
	value.it_interval.tv_usec = 0;
	setitimer(ITIMER_REAL, &value, &ovalue);
	signal(SIGALRM, SIG_IGN);
#endif

#ifdef XCURSES
	if ((xterm = malloc(strlen(command_line) + 10)) == NULL) {
		ERROR_MSG("Malloc Failed*ABORT");
		exit(1);
	}
	sprintf(xterm, "xterm -e %s &", command_line);
	result = SYSTEM(xterm);
	free(xterm);
#else
	result = SYSTEM(command_line);
#endif

#ifdef CLOCK_SUPPORT
	setitimer(ITIMER_REAL, &ovalue, &value);
	signal(SIGALRM, ClockHandler);
#endif

#ifndef XCURSES
	leaveok(stdscr, TRUE);
	curs_set(0);
#if defined( __NeXT__ )
	cbreak();
	nonl();
	noecho();
	clearok(stdscr, TRUE);
#endif							/* linux */
#endif							/* XCURSES */

	return (result);
}

/* exec the forking cmd */
int SYSTEM (char *cmd)
{
		#define SHELL	"/bin/sh"
		pid_t pid;
		switch(pid=fork()) {
			case 0:
				execl(SHELL,"sh","-c",cmd,(char *) 0);
				printf("Execl failed!\n");
				_exit(127);
			case -1: printf("fork error\n");
			default: return(0);
		}
}

void sendTo(char *cmd)
{
        char cmdstr[256];
        if(!strncmp(cmd,"file:",5)) cmd += 5;
        if(!strncmp(cmd,"local:",6)) cmd += 6;
        sprintf(cmdstr,"sendto %s", cmd);
        SYSTEM(cmdstr);
}
