#if !defined(WINDOW_H)
#define WINDOW_H

#include <X11/Xlib.h>

#include "list.h"
#include "widget.h"

struct button;
struct menuitem;
struct resizer;
struct title;

struct window { struct widget widget;
	char *name;
	char *iconname;

	struct title *title;

	struct button *deletebtn;
	struct button *lowerbtn;
	struct button *unmapbtn;

	struct resizer *rsz_northwest, *rsz_north, *rsz_northeast,
	    *rsz_west, *rsz_east, *rsz_southwest, *rsz_south, *rsz_southeast;

	struct menuitem *menuitem;

	Window client;

	Colormap colormap;

	/* ICCCM hints */
	XSizeHints *wmnormalhints;
	XWMHints *wmhints;
	Window wmtransientfor;

	int cborder;	/* client's initial border width */

	/* Meta-Button1 moving of window */
	struct {
		int moving;
		int xoff;
		int yoff;
	} altmove;

	int ignoreunmap;
	int maximized;
	unsigned long curbg;

	struct dim odim;	/* remembered dim while maximized */

	LIST stacking;	/* stacking order */
};

struct window *window_manage(Window, int);
int window_isactive(struct window *);
int window_istransactive(struct window *);
int window_isgroupactive(struct window *);
int window_isfamilyactive(struct window *);
int window_related(struct window *, struct window *);
int window_transrelated(struct window *, struct window *);
int window_grouprelated(struct window *, struct window *);
void window_calcsize(struct window *, int, int, int *, int *, int *, int *);
void window_delete(struct window *);
void window_fetchiconname(struct window *);
void window_fetchname(struct window *);
void window_fetchwmhints(struct window *);
void window_fetchwmnormalhints(struct window *);
void window_fetchwmtransientfor(struct window *);
void window_init(void);
void window_lower(struct window *);
void window_map(struct window *);
void window_maximize(struct window *);
void window_move(struct window *, int, int);
void window_movefamily(struct window *, int, int);
void window_moveresize(struct window *, int, int, int, int);
void window_raise(struct window *);
void window_repaint(struct window *);
void window_resize(struct window *, int, int);
void window_setactive(struct window *);
void window_unmanage(struct window *, int);
void window_unmap(struct window *);
void window_userunmap(struct window *);
void window_restackall(void);
void window_unmanageall(void);
void window_getclientstack(Window **, int *);

#endif /* !defined(WINDOW_H) */
