#if !defined(WIDGET_H)
#define WIDGET_H

/*
 * Copyright (c) 2006 Johan Veenhuizen
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <X11/Xlib.h>

typedef enum {
	TYPE_ANY,
	TYPE_WINDOW,
	TYPE_TITLE,
	TYPE_BUTTON,
	TYPE_MENU,
	TYPE_RESIZER,
	TYPE_SIZEWIN
} TYPE;

struct dim {
	int x;
	int y;
	int width;
	int height;
};

struct widget {
	TYPE type;
	Window xwindow;
	int mapped;
	struct dim dim;
	void (*event)(struct widget *, XEvent *);
};

#define XWINDOW(ptr)	(((struct widget *)(ptr))->xwindow)
#define X(ptr)		(((struct widget *)(ptr))->dim.x)
#define Y(ptr)		(((struct widget *)(ptr))->dim.y)
#define WIDTH(ptr)	(((struct widget *)(ptr))->dim.width)
#define HEIGHT(ptr)	(((struct widget *)(ptr))->dim.height)
#define MAPPED(ptr)	(((struct widget *)(ptr))->mapped)

void widget_init(void);
void widget_create(struct widget *, TYPE,
    Window, unsigned, int, int, int, int);
void widget_resize(struct widget *, int, int);
void widget_move(struct widget *, int, int);
void widget_moveresize(struct widget *, int, int, int, int);
void widget_map(struct widget *);
void widget_unmap(struct widget *);
void widget_destroy(struct widget *);
struct widget *widget_find(Window, TYPE);
void widget_deletecontext(Window);
void widget_savecontext(struct widget *, Window);

#endif /* !defined(WIDGET_H) */
