#if !defined(MENU_H)
#define MENU_H

/*
 * Copyright (c) 2006 Johan Veenhuizen
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <X11/Xlib.h>

#include "widget.h"

struct menuitem {
	char *name;
	void *ptr;
	void (*select)(void *);
	struct menuitem *prev, *next;
};

struct menu { struct widget widget;
	GC gc;
	Pixmap pixmap;
	int current;
	int button;
	int nitems;
	struct menuitem items;
};

struct menu *menu_create(void);
struct menuitem *menu_additem(struct menu *, const char *,
    void (*)(void *), void *);
void menu_delitem(struct menu *, struct menuitem *);
void menu_hide(struct menu *);
void menu_movetotop(struct menu *, struct menuitem *);
void menu_popup(struct menu *, int, int, int);
void menu_renameitem(struct menu *, struct menuitem *, const char *);
void menu_repaint(struct menu *);
void menu_select(struct menu *);

#endif /* !defined(MENU_H) */
