#ifndef _XWINDIFF_H
#define _XWINDIFF_H

/* Note: inclusion of "diff.h" is needed before this file */

typedef enum {
    NONEXIST = 0,  
    REGULARFILE,      
    DIRECTORY, 
    OTHER,     
    UNKNOWN   
} FileType;

typedef enum {
    NOTYETDIFFED = 0,     
    DIFFERENT,
    DIFFERENT_BLANKS,
    DIFFERENT_NOTSURE,
    IDENTICAL,
    INCOMPARABLE
} DiffResult;

typedef struct DirEntry {
  char *basename;   /* name of file with no dir prefixes                    */
  char *name;       /* common name for file                                 */
  char *leftname;   /* full name with left dir prefix                       */
  char *descr;      /* ptr to static description of difference string       */
  Boolean visible;  /* whether this entry is currently visible in the list  */
  FileType type;    /* type of left file                                    */
  time_t mtime;     /* modification time of left file                       */
  char *rightname;  /* full name with right dir prefix                      */
  FileType rtype;   /* type of right file                                   */
  time_t rmtime;    /* modification time of right file                      */
  DiffResult diff;  /* results of diffing the two files                     */
  Boolean marked;   /* this file has been marked                            */
  struct file_data files[2];
  struct change *script;   
                    /* saved diff results for this pair of files            */
} DirEntry;

#endif
