/************************************************************************/
/* 									*/
/* 	xe.h :  Definitionen fuer Resourcen von Xe			*/
/*		Roland Krause 1996, 1997				*/
/*									*/
/************************************************************************/

/* Makro fuer die Ausgabe von Statusmeldungen von Xe */

#define XeWarning(String)	XtVaSetValues(Glob.Message,XtNlabel,String,NULL)

/* Format fuer Ausgabe des Dateinamens in der Titelzeile */

#define cTitleWithFile		"xe : %s"
#define cTitleNoFile		"xe"

/* Textkonstante fuer Vorbelegung der Statusmeldungen */

#define cTxtCreateList		"Cannot create file list !"
#define cTxtAlreadyOpen		"Please close the file first !"
#define cTxtOpenFile		"Cannot open file !"
#define cTxtWriteErr		"Cannot write file !"
#define cTxtReadOnly		"File is read only !"
#define cTxtNewFile		"New file"
#define cTxtNotSelect		"No file selected !"


/* Zusaetzliche Ressourcen von Xe fuer Statusmeldungen */

#define XeResClass		"XeMessage"		/* Klasse der Resourcen */
#define XeRCreateListErr	"createListErr"		/* Namen der Resourcen */
#define XeRAlreadyOpenErr	"alreadyOpenErr"
#define XeROpenFileErr		"openFileErr"
#define XeRWriteErr		"writeErr"
#define XeRReadOnlyMsg		"readOnlyMsg"
#define XeRNewFileMsg		"newFileMsg"
#define XeRNotSelectMsg		"notSelectMsg"

/* --- Datenstrukturen ------------------------------------------------- */

typedef struct
{
  Widget  shell,		/* Shell-Widget des Programms */
	  Message,		/* Widget der Textzeile Meldetexte */
	  Text,			/* Widget fuer den Text */

	  fileShell,		/* Widget fuer Shell Dateiauswahldialog */
	  fileList,		/* List Widget fuer Dateiliste */
	  selectFile,		/* Text-Widget fuer gewaehlte Datei */

	  saveShell,		/* Widget fuer Shell 'Speichern unter' Dialog */
	  pathName,		/* Text-Widget fuer Pfadname */
	  fileName,		/* Text-Widget fuer Dateiname */

	  lineShell,		/* Widget fuer Shell 'Goto Line' - Dialog */
	  lineNumber;		/* Text-Widget fuer Zeilennummer */

  Pixmap  icon, iconClip;	/* das Icon von Xe */

  char	  NameOfFile[200];	/* Name geoeffnete Datei */
  int	  NewFile;		/* Flag neue Datei */
}
  Globals;

/* Widgets der Buttons in der Kopfzeile */

typedef struct
{
  Widget  quit,			/* Programmende */
	  close,		/* Datei schliessen */
	  load,			/* Datei laden */
	  new,			/* Neue Datei einrichten */
	  line,			/* Zu bestimmter Zeilennummer springen */
	  save,			/* Datei speichern */
	  saveAs;		/* Datei unter neuem Dateinamen speichern */
}
  Buttons;


