#include "UnixFile.hpp"
#include "StringUtils.hpp"
#include <unistd.h>

void main( int argc, char** args) {
  UnixFile* f= new UnixFile( args[1], UnixFile::AS_IS);
  cout << "fullname: " << f->getFullName() << endl;
  cout << f->getName() << "\n";
  cout << f->getParent() << "\n";
  cout << "internal state: " << f->state << endl;
  cout << f->getSize() << "\n";
  cout << f->getAttributeString() << "\n";

  cout << "exists(): " << f->exists() << endl;
  
  StringTokenizer st( f->getFullName(), "/");
  while( st.hasMoreTokens())
    cout << "|" << st.getNextToken() << "|" << endl;
//  cout << f->linkedFile << endl << endl;
  
  cout << "Checking access for calling user:" << endl
       << "Read:           " << (access( f->getFullName().c_str(), R_OK) == 0 ? "yes" : "no") << endl
       << "Write:          " << (access( f->getFullName().c_str(), W_OK) == 0 ? "yes" : "no") << endl
       << "Execute:        " << (access( f->getFullName().c_str(), X_OK) == 0 ? "yes" : "no") << endl
       << "Check Exitence: " << (access( f->getFullName().c_str(), F_OK) == 0 ? "yes" : "no") << endl;
}
