#ifndef Date_hpp
#define Date_hpp

#include <time.h>
#include <string>

using namespace std;

// The Date module
// Classes: Date, TimeZone
// 
// Last modified: 1999-10-25 

// time_t : Type imported from time.h
// time_type : This type should be always the one used internally here...
typedef time_t time_type;

class TimeZone;

/**
  This class' objects represent either a point in time ("absolute time value")
  or a time period ("relative").
  A time period can be understood as the difference between two points in time.
  At present, no distinction is made internally betwenn these two semantics;
  so care must be taken on usage of some functions.

  Note: Parts of the interface may change.

  Functionality:
   * An istance may be created with the current date/time or a value of type
     time_t, used by many OS functions.
   * Calculations
   * Generation of string representations.

  Shortcomings (at present):
   * String representations not usable for time periods
   * No string-scanning 
   * Dates before the 'epoch' cannot be used safely!

  @author Michael Weers
  @version 0.54 1998-08-28
  */
class Date {
  protected:
                  time_type t;   // Sekunden nach 1970-01-01 00:00:00 UTC 
    static const  int units= 1;  // Dauer von 1 Sek. in Einheiten von t

  public:   
                  /** Constructs an instance with the current system time*/
                  Date();
                  Date( time_t t);
      virtual     ~Date();

                  time_type getTimeValue()  const;  // gibt Attribut t zurck
                  
                  
                  void add( Date& diff);
                  void sub( Date& diff);
      static      Date difference( Date& d2, Date& d1);

                  string toDateString( TimeZone& tz);
                  string toTimeString( TimeZone& tz);

                  /** Generates a generic string representation, in local time */
        virtual   string toString()  const;
                  /** Gererates a string representation in the given time zone */
                  string toString( const TimeZone&)  const;
                  /** Gererate string representation in local time.
                      with format string as in strftime() */
                  string toString( const string&)  const;
                  
                  /** don't use yet. */
                  // We can hardly prevent users from giving %Z in the format string
                  // and also a time zone seperately 
                  string toString( const string&, const TimeZone&)  const;
};

bool operator == ( const Date& d1, const Date& d2);
bool operator < ( const Date& d1, const Date& d2);
bool operator > ( const Date& d1, const Date& d2);
inline bool operator != ( const Date& d1, const Date& d2) { return !(d1==d2); };
inline bool operator >= ( const Date& d1, const Date& d2) { return !(d1<d2); };
inline bool operator <= ( const Date& d1, const Date& d2) { return !(d1>d2); };


/* Represents Time Zones. At the moment, this class is *very* preliminary, only 
   the static member UTC can be used, which represents the Universal Time Coordinated.
   */
class TimeZone : public Date {
            // inherited attribute 't': is a relative time value,
            // giving a time difference between local time and UTC 
            // at present in seconds *east* of UTC.

  public:
            /** The UTC Time Zone */  
    static const   TimeZone UTC;         // declared here; defined in Date.cpp

  private:
                   string name;
   
  private: 
                   /* Initializes to local time zone */
                   TimeZone();  // don't use yet....
  protected:                
                   TimeZone( int offset_minutes, const string& name );
  public:  
         // no public constructor (yet)
//                   TimeZone( String& tz);
                   
       
//                   long int getOffset(); 
                   
                   //string getName()  const;
                   string toString()  const;
};



#endif
