#ifndef ColorSetup_hpp
#define ColorSetup_hpp

#include <string>
#include "UnixFile.hpp"

using namespace std;

/** This class manages color setups for colourized printing 
  (primarily filenames) on terminals
 and provides functionality to create such output.
 
 An object represents a specific setup.
 */
  // A straight-forward solution to generate coloured output based on the
  // LS_COLORS environment variable.
  // support is a bit limited because of some hard-coded things 
class ColorSetup {
  public:
                  /** The built-in setup. */
    static const  ColorSetup BUILT_IN;
    
    static const  string BRIGHTER;
  protected:
                  string code_str;  // complete LS_COLORS variable
                                    // now some specific codes
    static const  char   ESC= (char) 0x1b;
    
    
    static const  string left_code, right_code, end_code;
                  string color_text,  // normal text, no filename;
                         color_file, 
                         color_dir,
                         color_exec,
                         color_symlink,
                         color_blockdev,
                         color_chardev,
                         color_socket,
                         color_pipe;
                  
                  string color_default;   // color used internally if some other color value is empty

                  /** really do colorization? */
  public:         bool do_colorization;
    
  public:
                  /** initializing from LS_COLORS environment variable, 
                  if present, or from built-in setup.*/
                  ColorSetup(); 
                  
                  /** initialize with given setup */
                  ColorSetup( const string& setup); 

                  void enableColorization( bool enabled) { do_colorization= enabled; }

                  string format( string s, const string & color_str, bool colored)  const;
                  string format( const string& s, const string & color_str)  const {
                            return format( s, color_str, this->do_colorization); 
                  }
                  string formatFilename( const UnixFile& f)  const;
};

#endif
