#ifndef __NAV_H__
#define __NAV_H__

#include "browser.h"
#include "dw_widget.h"    /* for DwWidget */


/* useful macros for the navigation stack */
#define NAV_IDX(dd, i)   (dd)->nav_stack[i]
#define NAV_TOP(dd)      (dd)->nav_stack[(dd)->nav_stack_ptr]


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void a_Nav_push(DilloDoc *dd, const DilloUrl *url);
void a_Nav_vpush(void *vdd, const DilloUrl *url);
void a_Nav_back(DilloDoc *dd);
void a_Nav_forw(DilloDoc *dd);
void a_Nav_home(DilloDoc *dd);
void a_Nav_reload(DilloDoc *dd);
void a_Nav_init(DilloDoc *dd);
void a_Nav_free(DilloDoc *dd);
void a_Nav_cancel_expect (DilloDoc *dd);
void a_Nav_expect_done(DilloDoc *dd);
void a_Nav_remove_top_url(DilloDoc *dd);
void a_Nav_jump_callback(GtkWidget *widget, gpointer client_data, gint NewDd);
gint a_Nav_stack_ptr(DilloDoc *dd);
gint a_Nav_stack_size(DilloDoc *dd);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __NAV_H__ */


