
/* selection.c contains a few external functions that know how to delete/rename/etc selections */

#include <gtk/gtk.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <malloc.h>
#include <sys/types.h>
#include <dirent.h>
#include <fcntl.h>

#include "global.h"
#include "tree.h"
#include "std_dialog.h"
#include "flist.h"
#include "filesys/filesys.h"
#include "lowlevel.h"

extern gint direc;

struct _clipboard {
	int action;
	char *source_dir;
	GSList *files;
}clipboard= {NO_FILE, NULL, NULL};

struct rename_callback_info {
	GtkWidget *window;
	GSList *old_names;
	GSList *new_name_widgets;
};

void delete_selection (GtkWidget *w, gpointer *p);
void open_selection (GtkWidget *w, gpointer *p);
void sendto_selection (GtkWidget *w, gpointer *p);
void rename_selection (GtkWidget *w, gpointer *p);
void selection_to_clipboard (GtkWidget *widget, gpointer *action);
void paste_clipboard (GtkWidget *widget, gpointer *data);
void Cmd_prompt_here (GtkWidget *w, gpointer *p);
void Xedit_selection (GtkWidget *w, gpointer *p);

void rename_callback (GtkWidget *widget, gpointer *info);
void free_clipboard_contents ();
GSList *Get_selection (GtkWidget *w, gpointer *p);

int  SYSTEM (char *cmd);

void delete_selection (GtkWidget *w, gpointer *p)
{
	char *bestandsnaam;
	GList *row;
	GSList *names = NULL, *list;

	row = GTK_CLIST(lijst)->selection;
	while (row) {
		bestandsnaam = (char *)gtk_clist_get_row_data(GTK_CLIST(lijst), (int)(row->data));
		names = g_slist_append (names, completename (current_dir, bestandsnaam));
		row = row->next;
	}
	if(names != NULL)
	{
		gint ret=verify_question();
		if(ret == 1){
			delete_multiple_urls (names);
		}
	} else {
		return;
	}
	list = names;
	while (names) {
		free (names->data);
		names = names->next;
	}
	g_slist_free (list);
	refreshlist ();
}

void Cmd_prompt_here (GtkWidget *w, gpointer *p)
{
	char *cmdstr = "Cmd &";
	SYSTEM(cmdstr);
}

void Xedit_selection (GtkWidget *w, gpointer *p)
{
	char    cmdstr[256];
	sprintf(cmdstr,"edx %s &",((char*)Get_selection(w, p) != NULL ? (char*)Get_selection(w, p) : " "));
	SYSTEM(cmdstr);
}

GSList *Get_selection (GtkWidget *w, gpointer *p)
{
	char *bestandsnaam,*naam;
	GList *row;
	GSList *names = NULL;
	struct stat buf;

	chdir (current_dir);
	row = GTK_CLIST(lijst)->selection;
	if (row) {
		bestandsnaam = (char *)gtk_clist_get_row_data(GTK_CLIST(lijst), (int)(row->data));
		naam = completename(current_dir, bestandsnaam);
		lstat (naam, &buf);
			names = g_slist_append (names, naam);
			row = row->next;
	} else return(NULL);
	return(names->data);
}

void open_selection (GtkWidget *w, gpointer *p)
{
	GSList *list, *names = NULL, *datas = NULL;
	char *bestandsnaam,*naam;
	GList *row;
	struct stat buf;
/*
	time_t oldt;
	stat(current_dir, &buf);
	oldt = buf.st_mtime;	// get last mod time for refresh test
*/
	chdir (current_dir);
	row = GTK_CLIST(lijst)->selection;

	while (row) {
		bestandsnaam = (char *)gtk_clist_get_row_data(GTK_CLIST(lijst), (int)(row->data));
		naam = completename(current_dir, bestandsnaam);
		lstat (naam, &buf);

// The following code is commented out in order to deal with DOS and SAMBA
// partitions which have _everything_ marked as executable. Don't usually try
// and execute code from these mounts but do access data files with default
// applications. Data files are processed by the bash shell script 
// 'mime_start' which must be in the default search path. First it looks at
// filenames to detect the file association and then, if it does not find 
// one, and the data file is marked as executable, it will attempt to
// execute. Operation is transparent on 'native' *NIX filesystems.

/*		// 73 decimal equals 111 octal, exec bits
		if(buf.st_mode & 73)
		{
			names = g_slist_append (names, naam);
		}
		else 
*/		{
			datas = g_slist_append (datas, naam);
		}
		row = row->next;
	}
	list = names;
	while (names) {
		SYSTEM((char*)(names->data));
		free (names->data);
		names = names->next;
	}
	list = datas;
	while (datas) {
		char    cmdstr[256];
		sprintf(cmdstr,"mime_start %s &",(char*)(datas->data));
		SYSTEM(cmdstr);
		free (datas->data);
		datas = datas->next;
	}
	g_slist_free (list);
/*
	stat(current_dir, &buf);
	if(old != buf.st_mtime)
	{
		direc++;
		refreshlist ();
		direc--;
	}
*/
}

void sendto_selection (GtkWidget *w, gpointer *p)
{
	GSList *names = NULL, *list;
	char *bestandsnaam,*naam = NULL;
	GList *row;
	struct stat buf;

	chdir (current_dir);
	row = GTK_CLIST(lijst)->selection;
	while (row) {
		bestandsnaam = (char *)gtk_clist_get_row_data(GTK_CLIST(lijst), (int)(row->data));
		naam = completename(current_dir, bestandsnaam);
		lstat (naam, &buf);
		names = g_slist_append (names, naam);
		row = row->next;
	}
	list = names;
	while (names) {
		char cmdstr[256];
		sprintf(cmdstr,"sendto %s &",naam);
		SYSTEM(cmdstr);
		free (names->data);
		names = names->next;
	}
	g_slist_free (list);
//	refreshlist ();
}

int SYSTEM (char *cmd)
{
		#define SHELL   "/bin/sh"
		pid_t pid;
//		printf ("Exec: %s \n",(cmd));
		switch(pid=fork()) {
			case 0: chdir(current_dir);
				execl(SHELL,"sh","-c",cmd,(char *) 0);
				fprintf(stderr,"System Error: Execl failed!");
				_exit(127);
			case -1: perror("fork");
			default: return(0);
		}
}

void rename_selection (GtkWidget *w, gpointer *p)
{
	char *bestandsnaam;
	GtkWidget *window, *textbox, *vbox,*label, *button;
	GList *row;
	struct rename_callback_info *info;

	row = GTK_CLIST(lijst)->selection;
	if (row == NULL) return;

	info = (struct rename_callback_info *) malloc (sizeof(struct rename_callback_info));
	info->old_names = NULL;
	info->new_name_widgets = NULL;

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	info->window = window;
	gtk_container_set_border_width (GTK_CONTAINER(window), 10);
	vbox = gtk_vbox_new (TRUE, 0);
	gtk_widget_show(vbox);
	gtk_container_add (GTK_CONTAINER(window), vbox);
	label = gtk_label_new ("rename the files and click OK");
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX(vbox),label,FALSE, FALSE, 10);

	while (row) {
		bestandsnaam = (char *)gtk_clist_get_row_data(GTK_CLIST(lijst), (int)(row->data));
		textbox = gtk_entry_new_with_max_length(256);
		gtk_entry_set_text (GTK_ENTRY(textbox), bestandsnaam);
		gtk_widget_show (textbox);
		gtk_box_pack_start (GTK_BOX(vbox),textbox, FALSE, FALSE,0);
		info->old_names = g_slist_append((info->old_names),(gpointer)strdup(bestandsnaam));

		info->new_name_widgets = g_slist_append(info->new_name_widgets, textbox);
		row = row->next;
	}
	button = gtk_button_new_with_label ("Ok");
	gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(rename_callback), (gpointer)info);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_widget_show (window);
}

void rename_callback (GtkWidget *widget, gpointer *data)
{
	GSList *oldnames, *newnames;
	struct rename_callback_info *info;
	char *tmp;

	info = (struct rename_callback_info *)data;

	oldnames = info->old_names;
	newnames = info->new_name_widgets;

	while (oldnames) {
		tmp = gtk_entry_get_text(GTK_ENTRY(newnames->data));
		rename_file (oldnames->data, tmp);
		free(oldnames->data);
		oldnames = oldnames->next;
		newnames = newnames->next;
	}
	g_slist_free (info->old_names);
	g_slist_free (info->new_name_widgets);
	gtk_widget_destroy (info->window);
	free (data);
	refreshlist();
}

/*
 * this function removes the current content of the clipboard, while
 * replacing it with the current selection
 */
void selection_to_clipboard (GtkWidget *widget, gpointer *action)
{
	GList *row;
	char *name;

	free_clipboard_contents ();
	clipboard.action = (int)action;
	clipboard.source_dir = strdup (current_dir);
	clipboard.files = NULL;

	row = GTK_CLIST(lijst)->selection;
	while (row) {
		name = gtk_clist_get_row_data (GTK_CLIST(lijst),(int)(row->data));
		clipboard.files = g_slist_append (clipboard.files,strdup(name));
		row = row->next;
	}
}

/*
 * this function decides what should be done with the clipboard
 * (and if anything should be) and does just this;
 */
void paste_clipboard (GtkWidget *widget, gpointer *data)
{
	GSList *names;
	struct multiple_file_ops *files=NULL, *current_file, *previous_file=NULL;

	if (clipboard.action == NO_FILE) return;

	names = clipboard.files;

	while (names) {
		current_file = malloc(sizeof(struct multiple_file_ops));
		current_file->source = completename (clipboard.source_dir, names->data);
		current_file->destination = completename (current_dir, names->data);
		current_file->next = NULL;
		if (files == NULL)
			files = current_file;
		else
			previous_file->next = current_file;
		previous_file = current_file;
		names = names->next;
	}

	switch (clipboard.action) {
		case MOVE_FILE :
			rename_multiple_files (files);
			break;
		case COPY_FILE :
			copy_multiple_files (files);
			break;
		case SOFT_LINK_FILE :
			soft_link_multiple_files (files);
			break;
		case HARD_LINK_FILE :
			hard_link_multiple_files (files);
			break;
	}
	/* free memory here */
	free_clipboard_contents ();
	refreshlist();
}

/*
 * this function frees all memory used by the clipboard
 */
void free_clipboard_contents ()
{

	if (clipboard.action == NO_FILE) return;
	while (clipboard.files) {
		free (clipboard.files->data);
		clipboard.files = clipboard.files->next;
	}
	g_slist_free (clipboard.files);
	free (clipboard.source_dir);
	clipboard.action = NO_FILE;
	return;
}
