
#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gtk/gtkctree.h>
#include <gdk/gdkkeysyms.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include <signal.h>
#include "tree.h"
#include "flist.h"
#include "menu.h"
#include "preferences.h"
#include "global.h"
#include "selection.h"
#include "std_dialog.h"

// extern funcs
extern void prev_dir(GtkWidget *widget, GtkWidget *aentry);
extern void next_dir(GtkWidget *widget, GtkWidget *aentry);
extern void dir_entry_enter(GtkWidget *widget, GtkWidget *entry);
extern void exit_callback (GtkWidget *widget, gpointer *data);
extern void CreatePopup4File();
extern void CreatePopup4Dir();
extern GtkWidget* get_main_toolbar(GtkWidget *parent);
extern void timed_refresh(GtkWidget *widget, GtkWidget *aentry);

// extern data defs
extern GtkWidget *NewDirPopup (GtkWidget *window);
extern GtkWidget *entry[MAX_HISTORY];
extern char *current_dir;
extern int timer_id;
extern time_t old_time;

// local func protos
void build_main_screen ();
GtkWidget *newMainWindow ();
static gint button_press( GtkWidget *widget, GdkEventButton *event );

// local data defs
char *column_headers[7] = {"icon", "type ", "mode  ", "owner ", "groupID", "filesize          ", "last modified"};
GtkWidget *mainwindow;	// main window
GtkWidget *treewin;		// tree window
GtkCTreeNode *RootNode; // tree root node (HOMEnode)
GtkWidget *file_list;	// directory file list
GtkWidget *popup;
GtkWidget *dir_tree;
GtkWidget *menubar;			// main app menus
GtkWidget *toolbar;			// main app icon toolbar
GtkAccelGroup *accel_group;
guint32 xid = 0;

void about()
{
	message("uxplor, 0.26, (C) GPL 2004, 2005\n Terry Loveall http://modest-proposals.com/");
}

void sig_handler(int signal)
{
    if (signal == SIGCHLD) wait(NULL);
}

int main(int argc, char *argv[])
{
    struct sigaction act;
    int i = 1;

  while (i < argc - 1 && !strcmp(argv[i++],"-x")){
    xid = strtol(argv[i], NULL, 10);
    argc -= 2;
    argv += 2;
    if(xid == LONG_MIN || xid == LONG_MAX) xid = 0;
  }
	/* disconnect from the console */
	if(!xid){switch (fork()) { case 0: case -1: break; default: exit(0); }}

	// kill off zombie child processes
	act.sa_handler = sig_handler;
	act.sa_flags = 0;
	sigaction(SIGCHLD, &act, NULL);

	gtk_init (&argc, &argv);
	current_dir = getcwd(NULL,0);
	if(argc > 1) { free(current_dir); current_dir = strdup(argv[1]);}
	read_preferences();
	build_main_screen ();
	refreshlist();
	gtk_main ();
	return 0;
}

/*
 * Handler for key presses that don't belong to the viewport.
 * (Used to customize the interface a bit)
 */
gint Interface_key_press_handler(GtkWidget *widget,
                                        GdkEventKey *event,
                                        gpointer client_data)
{
   GtkWidget *bw = client_data;

   // These keys are handled here because GTK accel group ignores them
   switch (event->keyval) {
   case GDK_BackSpace:
      if (event->state & GDK_SHIFT_MASK)
         next_dir(NULL, bw);
      else
         prev_dir(NULL, bw);
      return TRUE;
   case GDK_Delete:
      if(widget == treewin || widget == entry[0]) break;
      if(widget == file_list) delete_selection(NULL, (gpointer)bw);
      return TRUE;
   default:
      // g_print(">> Key pressed!\n");
      break;
   }
	// Tell calling code that we have not handled this event.
	return FALSE;
}

GtkWidget *scrollwindow;	// h&v tree and file list scrollbars
void build_main_screen ()
{
	GtkWidget *vbox;			// menubar & tree container

	// create main app window
	mainwindow = newMainWindow ();
	gtk_widget_realize (mainwindow);
	gtk_widget_show (mainwindow);

	// vbox for menu, toolbar, entry, dir-tree and dir-list
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show (vbox);
	gtk_container_add (GTK_CONTAINER(mainwindow), vbox);

	// menu
	menubar = NewMenuBar (mainwindow);
	gtk_box_pack_start (GTK_BOX(vbox), menubar, FALSE, FALSE, 0);

	// toolbar
	toolbar = get_main_toolbar (mainwindow);
	gtk_widget_show(toolbar);
	gtk_box_pack_start (GTK_BOX(vbox), toolbar, FALSE, FALSE, 0);

	// create entry widget to display current dir and get user specified dir
	entry[0] = gtk_entry_new();
    gtk_signal_connect(
        GTK_OBJECT(entry[0]),
        "activate",
        (GtkSignalFunc)dir_entry_enter,
        entry[0]);
	gtk_widget_show(entry[0]);
	gtk_box_pack_start (GTK_BOX(vbox), entry[0], FALSE, FALSE, 0);

	// create double horizontal pane widget
	treewin = gtk_hpaned_new ();
	gtk_box_pack_start (GTK_BOX(vbox), treewin, TRUE, TRUE, 0);
	gtk_widget_show(treewin);

	// set initial tree width and border of double horizontal pane
	gtk_paned_set_position (GTK_PANED(treewin), 200);
	gtk_container_set_border_width (GTK_CONTAINER(treewin), 0);

// dir_tree scrolled window
	// make a pane with scrollbars for dir_tree
	scrollwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrollwindow);

	// create left pane ctree widget
	dir_tree = maketree ();

	// add dir_tree widget to first position in double horz pane treewin
	gtk_container_add (GTK_CONTAINER(scrollwindow), dir_tree);
	gtk_paned_pack1 (GTK_PANED(treewin), scrollwindow, TRUE, TRUE);

// newlist scrolled window
	// make a pane with scrollbars for file_list
	scrollwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrollwindow);

	// create right pane clist widget
	file_list = newlist (mainwindow);
	gtk_signal_connect(GTK_OBJECT(GTK_CLIST(file_list)),
						"key_press_event",
						GTK_SIGNAL_FUNC(Interface_key_press_handler), 0);

	// make right button popus
	popup = NewDirPopup (mainwindow);
	gtk_signal_connect (GTK_OBJECT (file_list), "event",
		GTK_SIGNAL_FUNC (button_press), popup);

	// add file_list to second position in double horz pane treewin
	gtk_container_add (GTK_CONTAINER(scrollwindow), file_list);
	gtk_paned_pack2 (GTK_PANED(treewin), scrollwindow, TRUE, TRUE);

	// only thing usable on dir_tree from popup is "Cmd here"
//	gtk_signal_connect (GTK_OBJECT (dir_tree), "event",
//		GTK_SIGNAL_FUNC (button_press), popup);

	timer_id=gtk_timeout_add(100, (GtkFunction)timed_refresh, NULL);

	gtk_widget_show(mainwindow);
}

GtkWidget *newMainWindow ()
{
	GtkWidget *window;

//printf("xid=%d\n",xid);
   if (!xid)
       window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   else
       window = gtk_plug_new(xid);

	gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		GTK_SIGNAL_FUNC(exit_callback), NULL);
	gtk_window_set_title(GTK_WINDOW(window), "uxplor");
//    gtk_window_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	gtk_container_set_border_width(GTK_CONTAINER(window),0);

/* defaults seem to work just fine, uncomment oftherwise
	gtk_window_set_title(GTK_WINDOW(window), "uxplor");
	gtk_window_set_wmclass(GTK_WINDOW(window), "browser", "uxplor");
*/
	gtk_widget_set_uposition(window, 0, 0);

	/* set initial main window size */
  gtk_widget_set_usize (GTK_WIDGET (window),
			(gint) (800-12),
			(gint) (550-31));
	return window;
}

void exit_callback (GtkWidget *widget, gpointer *data)
{
	gtk_main_quit ();
}

static gint button_press( GtkWidget *widget, GdkEventButton *event )
{
	GdkEventKey *kevent = (GdkEventKey*) event;
	static guint ltime,ttime;

	// right button
	if (event->type == GDK_BUTTON_PRESS && event->button ==3) {
		GdkEventButton *bevent = (GdkEventButton *) event;
		gtk_menu_popup (GTK_MENU (popup), NULL, NULL, NULL, NULL,
				bevent->button, bevent->time);
		// Tell calling code that we have handled this event.
		return TRUE;
	}

	// left button
	if (event->type == GDK_BUTTON_PRESS && event->button ==1) {
		GdkEventButton *bevent = (GdkEventButton *) event;
		ltime=ttime;
		ttime=bevent->time;
		if ((ttime-ltime < 500) && (ttime-ltime > 0)) {
			open_selection((GtkWidget *)NULL, (gpointer *)NULL);
			return TRUE;
		}
	}

	// return key
	if (event->type == GDK_KEY_PRESS && kevent->keyval == GDK_Return) {
		open_selection((GtkWidget *)NULL, (gpointer *)NULL);
		return TRUE;
	}

	// Tell calling code that we have not handled this event.
	return FALSE;
}
