
#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "xpm/dirlink.xpm"
#include "xpm/filelink.xpm"
#include "xpm/misclink.xpm"
#include "xpm/dir.xpm"
#include "xpm/file.xpm"
#include "xpm/misc.xpm"

#include "global.h"
#include "preferences.h"
#include "tree.h"
#include "dragdrop.h"
#include "lowlevel.h"

extern gint last_entry, cur_entry, direc;
extern GtkWidget *entry[];
extern GtkWidget *lijst;
char *current_dir;
GtkCTreeNode *current_dir_node = NULL;
time_t old_time = 0;	// last refresh time, used by timed_refresh
int timer_id = 0;		// timer callback ID

extern void change_to_dir(GtkWidget *widget, char *dir);
extern void toolbar_prev_enable(gboolean e);
extern void toolbar_next_enable(gboolean e);
extern void toolbar_cdup_enable(gboolean e);
extern GtkWidget *newlist(GtkWidget *window);
extern void refreshlist();
extern void flist_reconfigure ();
extern void fillist (GtkWidget *widget, gpointer *path);
extern void flist_select_all (GtkWidget *widget, gpointer data);
extern void flist_select_invert (GtkWidget *widget, gpointer data);
extern void message (char *tekst);
extern void dir_entry_enter (GtkWidget *widget, GtkWidget *entry);

GdkPixmap *pixfile = NULL, *pixdir = NULL, *pixmisc = NULL;
GdkPixmap *pixfilelink, *pixdirlink, *pixmisclink;
GdkBitmap *bitfile, *bitdir, *bitmisc;
GdkBitmap *bitfilelink, *bitdirlink, *bitmisclink;
int firstime = 1;

void selecteer_bestand (GtkWidget *widget, gint rij, gint kolom, GdkEventButton *event, gpointer *data);
void deselecteer_bestand (GtkWidget *widget, gint rij, gint kolom, GdkEventButton *event, gpointer *data);
void add_list_entry (char *filename);

void clist_click_column(GtkCList * aclist, gint column, gpointer data)
{
	if (column == aclist->sort_column) {
		if (aclist->sort_type == GTK_SORT_ASCENDING)
			aclist->sort_type = GTK_SORT_DESCENDING;
		else
			aclist->sort_type = GTK_SORT_ASCENDING;
	} else
		gtk_clist_set_sort_column(aclist, column);
	gtk_clist_sort(aclist);
}

/* 
 * newlist creates a new file list window. The first time it is called with its parent window
 * as argument and it initializes some pixmaps. It sets the global variable lijst to the new
 * widget and returns it as well. 
 */
GtkWidget *newlist(GtkWidget *window)
{
	gchar *titels[NUM_SETTINGS_LIST_ITEMS];
	int i,j=1;
	GtkStyle *style;
	GdkGC *gc;

	titels[0] = "Filename";

	for (i=1;i<NUM_SETTINGS_LIST_ITEMS;i++) {
		if (settings->list_items[i] == TRUE) {
			titels[j] = column_headers[i];
			j++;
		}
	}
	
	lijst = gtk_clist_new_with_titles (j,titels);
	gtk_clist_set_selection_mode (GTK_CLIST(lijst), GTK_SELECTION_EXTENDED);
	gtk_clist_set_column_width (GTK_CLIST(lijst), 0,150);
	gtk_clist_set_sort_column (GTK_CLIST(lijst),0);
	gtk_clist_set_auto_sort (GTK_CLIST(lijst), TRUE);
	gtk_signal_connect(GTK_OBJECT(lijst), "click_column",
						(GtkSignalFunc) clist_click_column, NULL);

	gtk_drag_dest_set (lijst, GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP, target_table, 1, GDK_ACTION_COPY|GDK_ACTION_MOVE|GDK_ACTION_LINK);
	gtk_signal_connect (GTK_OBJECT(lijst), "drag_data_received", GTK_SIGNAL_FUNC(target_data_received), NULL);

	gtk_drag_source_set (lijst, GDK_BUTTON1_MASK, target_table, 1, GDK_ACTION_COPY|GDK_ACTION_MOVE|GDK_ACTION_LINK);
	gtk_signal_connect (GTK_OBJECT (lijst), "drag_data_get", GTK_SIGNAL_FUNC (lijst_drag_data_get), NULL);
	gtk_signal_connect(GTK_OBJECT(lijst),"drag_motion", GTK_SIGNAL_FUNC(target_data_motioned), NULL);
	gtk_signal_connect(GTK_OBJECT(lijst),"drag_leave", GTK_SIGNAL_FUNC(target_data_left), NULL);

	gtk_widget_show (lijst);

	// initialize the pixmaps
	if (window != NULL) {
		style = gtk_widget_get_default_style ();
		gc = style->black_gc;
		pixfile= gdk_pixmap_create_from_xpm_d(window->window, &bitfile, &style->bg[GTK_STATE_NORMAL],file_xpm);
		pixdir= gdk_pixmap_create_from_xpm_d(window->window, &bitdir, &style->bg[GTK_STATE_NORMAL],dir_xpm);
		pixmisc= gdk_pixmap_create_from_xpm_d(window->window, &bitmisc, &style->bg[GTK_STATE_NORMAL],misc_xpm);
		pixfilelink = gdk_pixmap_create_from_xpm_d(window->window, &bitfilelink, &style->bg[GTK_STATE_NORMAL],filelink_xpm);
		pixdirlink = gdk_pixmap_create_from_xpm_d(window->window, &bitdirlink, &style->bg[GTK_STATE_NORMAL],dirlink_xpm);
		pixmisclink = gdk_pixmap_create_from_xpm_d(window->window, &bitmisclink, &style->bg[GTK_STATE_NORMAL],misclink_xpm);
	}
	
	return lijst;
}

/* 
 * flist_reconfigure kills the previous file list and creates a new one 
 */
void flist_reconfigure ()
{
	GtkWidget *vader;

	vader = lijst->parent;
	gtk_widget_destroy (lijst);
	lijst = newlist (NULL);
	gtk_container_add (GTK_CONTAINER(vader), lijst);
	gtk_widget_show (lijst);
	refreshlist ();
}

/*
 * fillist fills the list with the path in its argument and sets current_dir if it succeeds
 */

void fillist (GtkWidget *widget, gpointer *path)
{
	DIR *dirdes;
	struct dirent *inhoud;
	int i;
	struct stat buf;

	// update last refresh time
	stat(current_dir, &buf);
	old_time = buf.st_mtime;

	gtk_clist_freeze (GTK_CLIST(lijst));
	for (i=0;i<GTK_CLIST(lijst)->rows;i++) {
		free ((char *)gtk_clist_get_row_data (GTK_CLIST(lijst), i));
	}
	gtk_clist_clear (GTK_CLIST(lijst));
	dirdes = opendir ((char *)path);
	if (dirdes == NULL) {
		char tmp[256];
		// if path doesn't exist, truncate it and children from dir_tree
		if(access((char *)path, F_OK)) {
			strncpy(tmp, (char *)path, 255);
			tree_remove_dir ((char *)tmp);
			// re-select current_dir
			dir_entry_enter((GtkWidget *)GTK_CTREE(dir_tree), entry[0]);
		} else {
			sprintf (tmp,"Access denied to: %s\n",(char *)path);
			message(tmp);
		}
		gtk_clist_thaw (GTK_CLIST(lijst));
		return;
	}
	// History mallocation and management.
	if((!direc) 
		&& (strcmp((char *)path,gtk_entry_get_text(GTK_ENTRY(entry[cur_entry])))) 
		&& !(firstime)) 
	{
		if (current_dir != NULL) free (current_dir);

		current_dir = strdup ((char *) path);
		while(last_entry > cur_entry) g_free(entry[last_entry--]);
		entry[++cur_entry] = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(entry[cur_entry]), (char *)path);
		++last_entry;
	}
	gtk_entry_set_text(GTK_ENTRY(entry[0]), current_dir);
	
	chdir ((char *)path);
	while ((inhoud=readdir(dirdes))!=NULL) {
		add_list_entry (inhoud->d_name);
	}
	if(last_entry == MAX_HISTORY) --last_entry;
	toolbar_prev_enable(cur_entry > 1 ? TRUE : FALSE);
	toolbar_next_enable(cur_entry < last_entry ? TRUE : FALSE);
	toolbar_cdup_enable((gboolean)(strlen(current_dir) > 1));

	gtk_clist_thaw (GTK_CLIST(lijst));
	closedir (dirdes);
}

/*
 * refreshlist fills the current file list again, and updates the scrollbars after that
 */
void refreshlist()
{
	GtkAdjustment *hadj, *vadj;
	gfloat x,y;
	gchar *tempstring;

	if(firstime){
		firstime = 0;
		change_to_dir(NULL, current_dir); 
		return;
	}
	if (current_dir !=NULL)	{
		gtk_clist_freeze (GTK_CLIST(lijst));
		hadj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW(lijst->parent));
		vadj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW(lijst->parent));
		x = hadj->value;
		y = vadj->value;

		tempstring = g_strdup(current_dir);
		fillist (NULL, (gpointer)tempstring);
		free(tempstring);

		gtk_adjustment_set_value (hadj, x);
		gtk_adjustment_set_value (vadj, y);
		gtk_clist_thaw (GTK_CLIST(lijst));
	}	
}

void timed_refresh(GtkWidget *widget, GtkWidget *aentry)
{
	struct stat buf;
	stat(current_dir, &buf);

	// refresh 
	if(old_time != buf.st_mtime)
		refreshlist();
}

/*
 * add_list_entry adds one entry to the current file list.
 */
void add_list_entry (char *filename)
{
	char *naam;
	char *rowdata[NUM_SETTINGS_LIST_ITEMS];
	int i,j=1, counter;
	struct stat buf;

	naam = completename(current_dir, filename);
	lstat (naam, &buf);
	
	rowdata[0] = filename;	/* file name */
	rowdata[1] = NULL;	/* mode */
	rowdata[2] = NULL;	/* owner */
	rowdata[3] = NULL;	/* group ID */
	rowdata[4] = NULL;	/* file size */
	rowdata[5] = NULL;	/* type */
	rowdata[6] = NULL;	/* last modified */

	if (settings->list_items[1] == TRUE) {
		rowdata[j] = (char *)malloc (10);
		sprintf (rowdata[j],"%3i",((int)buf.st_mode  & 0xf000) >> 13);
		j++;
	}
	if (settings->list_items[2] == TRUE) {
		rowdata[j] = (char *)malloc (10);
		sprintf (rowdata[j],"%5o",buf.st_mode & 0xfff0fff);
		j++;
	}
	if (settings->list_items[3] == TRUE) {
		rowdata[j] = (char *)malloc (10);
		sprintf (rowdata[j],"%5i",buf.st_uid);
		j++;
	}
	if (settings->list_items[4] == TRUE) {
		rowdata[j] = (char *)malloc (10);
		sprintf (rowdata[j],"%5i",buf.st_gid);
		j++;
	}
	if (settings->list_items[5] == TRUE) {
		rowdata[j] = (char *)malloc (10);
		sprintf (rowdata[j],"%11i",(int)buf.st_size);
		j++;
	}
	if (settings->list_items[6] == TRUE) {
		char ret[22];
		struct tm *tmb = (localtime(&buf.st_mtime));
		sprintf (ret," 1%03i/%02i/%02i %02i:%02i:%02i",
					tmb->tm_year, tmb->tm_mon+1, tmb->tm_mday, 
					tmb->tm_hour, tmb->tm_min, tmb->tm_sec);
		// sprintf returns 103 for year 2003, 95 for 1995
		if(ret[2]=='1')
			{ret[1] = '2';ret[2]='0';}
		else
			{ret[2]='9';}
		rowdata[j] = (char *)malloc (22);
		memccpy(rowdata[j], ret, '\0', 21);
	}
	i = gtk_clist_append (GTK_CLIST(lijst), rowdata);
	for (counter = 1; counter<j;counter ++) {
		free(rowdata[counter]);
	}
	
	gtk_clist_set_row_data (GTK_CLIST(lijst), i, strdup(filename));

	if (settings->list_items[0] == TRUE)	{
		if (S_ISDIR(buf.st_mode))
			gtk_clist_set_pixtext (GTK_CLIST(lijst), i,0,filename,3,pixdir,bitdir);
		else if (S_ISREG(buf.st_mode))
			gtk_clist_set_pixtext (GTK_CLIST(lijst), i,0,filename,3,pixfile,bitfile);
		else if (S_ISLNK(buf.st_mode)) {
			stat (naam, &buf);
			if (S_ISDIR(buf.st_mode))
				gtk_clist_set_pixtext (GTK_CLIST(lijst), i,0,filename,3,pixdirlink,bitdirlink);
			else if (S_ISREG(buf.st_mode))
				gtk_clist_set_pixtext (GTK_CLIST(lijst), i,0,filename,3,pixfilelink,bitfilelink);
			else 
				gtk_clist_set_pixtext (GTK_CLIST(lijst), i,0,filename,3,pixmisclink,bitmisclink);
		} else 
			gtk_clist_set_pixtext (GTK_CLIST(lijst), i,0,filename,3,pixmisc,bitmisc);
	}
	return;
}

/*
 * this function selects all current list items
 */
void flist_select_all (GtkWidget *widget, gpointer data)
{
	gtk_clist_select_all (GTK_CLIST(lijst));
}

/* 
 * this function inverts the current selection.
 */
void flist_select_invert (GtkWidget *widget, gpointer data)
{
	GList *old_selection, *iterator;
	old_selection = g_list_copy (GTK_CLIST(lijst)->selection);
	iterator = old_selection;

	gtk_clist_select_all (GTK_CLIST(lijst));
	while(iterator) {
		gtk_clist_unselect_row (GTK_CLIST(lijst),(int)(iterator->data),0);
		iterator = iterator->next;
	}
	g_list_free (old_selection);
}
