#include <gtk/gtk.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

#include "filesys.h"
#include "../std_dialog.h"
#include "../lowlevel.h"
#include "../tree.h"

extern int soft_link_file (gchar *source, gchar *destination);
extern int hard_link_file (gchar *source, gchar *destination);

extern int soft_link_multiple_files (struct multiple_file_ops *files);
extern int hard_link_multiple_files (struct multiple_file_ops *files);


int soft_link_file (gchar *source, gchar *destination)
{
	int return_value;
	return_value =  symlink (source, destination);
	if (return_value == FALSE)
		message ("Sorry, couldn't make the symlink");
	return return_value;
}

int hard_link_file (gchar *source, gchar *destination)
{
	int return_value;
	return_value =  link (source, destination);
	if (return_value == FALSE)
		message ("Sorry, couldn't make the hard link");
	return return_value;
}

int soft_link_multiple_files (struct multiple_file_ops *files)
{
	int return_value = TRUE;
	struct multiple_file_ops *tmp;

	tmp = files;
	while (tmp) {
		if (symlink (tmp->source, tmp->destination) != 0)
			return_value = FALSE;
		tmp = tmp->next;
	}
	if (return_value == FALSE)
		message ("Some error occured while I was creating symlinks");
	return return_value;
}

int hard_link_multiple_files (struct multiple_file_ops *files)
{
	int return_value = TRUE;
	struct multiple_file_ops *tmp;

	tmp = files;
	while (tmp) {
		if (link (tmp->source, tmp->destination) != 0)
			return_value = FALSE;
		tmp = tmp->next;
	}
	if (return_value == FALSE)
		message ("Some error occured while I was creating HARD links");
	return return_value;
}
