#include <string.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>

#include "global.h"
#include "lowlevel.h"
#include "filesys/filesys.h"
#include "flist.h"

int motion_previous_row=0;

extern void target_data_received (GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *data, guint info, guint time);
struct multiple_file_ops *file_names_from_drop (char *dest_dir, char *data);
extern void lijst_drag_data_get (GtkWidget *widget, GdkDragContext *context, GtkSelectionData *selection_data, guint info, guint time, gpointer data);
extern void target_data_motioned (GtkWidget *widget, GdkDragContext *context, gint x, gint y, guint time);
extern void target_data_left (GtkWidget *widget, GdkDragContext *context, guint time);

/*
 * this function is called whenever a drop event occures. it moves around with files
 * as ordered by the user
 */
void target_data_received (GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *data, guint info, guint time)
{
	char *dest_dir;
	char *row_file;
	int row, column;
	DirNode *node;
	struct multiple_file_ops *filenames;

	/* if the widget in which it is dropped is a clist widget, it is OK and we should check its name */
	/* hard linking files by dnd will not be included because hard links are creepy (this has been confirmed by both my roommate
		Jeroen and my personal guru Roel) */

	/* first we determine where the item was dropped */

	 if (GTK_IS_CTREE(widget)) {
		gtk_clist_get_selection_info (GTK_CLIST(widget), x, y, &row, &column);
		node = gtk_clist_get_row_data (GTK_CLIST(widget), row);
		if (node !=NULL) dest_dir = node->path;
		else return;
	} else {
		y -= 26;
		dest_dir = current_dir;
		gtk_clist_get_selection_info (GTK_CLIST (lijst), x, y, &row, &column);
		if (column == 0) {
			row_file = completename(current_dir, (char *)gtk_clist_get_row_data (GTK_CLIST(lijst), row));
			if (is_a_dir(row_file))
				dest_dir = row_file;
		}
	}
	/* so we've got the right location, now on to the data */
	filenames = file_names_from_drop (dest_dir, data->data);
	

	if (filenames != NULL) {
		if (context->actions == 14) {
			rename_multiple_files (filenames);	// move
		} else if (context->actions == 4) {
			soft_link_multiple_files (filenames);	// soft link
		} else if (context->actions == 2) {
			copy_multiple_files (filenames);	// copy
		}
	}
	refreshlist ();
}

/*
 * this function accepts a string from the mime-type text/uri-list and returns a multiple_file_ops linked list with the
 * file names in the string. It validates the string, and returns the legible part. 
 */
struct multiple_file_ops *file_names_from_drop (char *dest_dir, char *data)
{
	struct multiple_file_ops *return_list = NULL, *next_file, *previous_file = NULL;
	char *tmppath, *end_of_string;

	if (data == NULL) return NULL;
	while (data[0] != 0) {
		if (strncmp (data, "file:", 5)) return return_list;
		end_of_string = strstr (data, "\r\n");

		next_file = malloc (sizeof (struct multiple_file_ops));
	
		tmppath = g_strndup (data+5,end_of_string - data-5);
		next_file->source = tmppath;
		next_file->destination = completename (dest_dir, ((rindex (tmppath, '/'))+1));
		next_file->next = NULL;

		if (return_list == NULL) 
			return_list = next_file;
		else
			previous_file->next = next_file;
		previous_file = next_file;

		data = end_of_string + 2;
	}
	return return_list;
}

/* 
 * when a drag is initiated this function packs all selected files in an uri-list
 * mime type. 
 */
void lijst_drag_data_get (GtkWidget *widget, GdkDragContext *context, GtkSelectionData *selection_data, guint info, guint time, gpointer data)
{
	char *files=NULL, *bestandsnaam, *realurl;
	GList *row;

	row = (GTK_CLIST(lijst)->selection);
	while (row) {
		bestandsnaam = (char *)gtk_clist_get_row_data(GTK_CLIST(lijst), (int)(row->data));
		realurl = completename (current_dir, bestandsnaam); 
		if (files == NULL) {
			files = malloc (sizeof (char) *(strlen(realurl) + 8)); 
			strcpy (files, "file:");
		} else {
			files = realloc (files, (sizeof (char)) *(strlen (files) + strlen(realurl) + 8)); 
			strcat (files, "file:");
		}
		strcat (files, realurl);
		strcat (files, "\r\n");
		row = row->next;
		free (realurl);
	}
	if (files == NULL) { /* no drag should occure anyway, but it does. */
		files = malloc (sizeof (char));
		files[0] = 0;
	}
	gtk_selection_data_set (selection_data, selection_data->target, 8, files, strlen(files));
}

/*
 * this function colors backgrounds as nescessary in a drag-n-drop 
 */
void target_data_motioned (GtkWidget *widget, GdkDragContext *context, gint x, gint y, guint time)
{
	int row, column;
	static GtkWidget *previous_widget=NULL;
	GdkColor white;
	GdkColor blue;

	/* just in case something changed */
	if ((previous_widget != dir_tree) && (previous_widget !=lijst))
		previous_widget = NULL;

	if (!GTK_IS_CTREE(widget)) y -= 26;
	
	gtk_clist_get_selection_info (GTK_CLIST(widget), x, y, &row, &column);

	if (motion_previous_row == row) return;

	white.red = 65535;
	white.green = 65535;
	white.blue = 65535;
	blue.red = 53000;
	blue.green = 65535;
	blue.blue = 53000;

	if (previous_widget != NULL)
		gtk_clist_set_background (GTK_CLIST(previous_widget), motion_previous_row, &white);
	gtk_clist_set_background (GTK_CLIST(widget), row, &blue);
	motion_previous_row = row;
	previous_widget = widget;
}

/*
 * resets the background color if a drag leaves the area
 */
void target_data_left (GtkWidget *widget, GdkDragContext *context, guint time)
{
	GdkColor white;

	white.red = 65535;
	white.green = 65535;
	white.blue = 65535;

	gtk_clist_set_background (GTK_CLIST(widget), motion_previous_row, &white);
}
