
/* dir.c contains routines used to interactively create a new subdirectory */
/* (c) 2000 by Wiebe Zoon */

#include <gtk/gtk.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "flist.h"
#include "tree.h"
#include "global.h"
#include "lowlevel.h"
#include "std_dialog.h"

extern void make_new_dir (GtkWidget *widget, gpointer *data);
void new_dir_callback (GtkWidget *widget, gpointer *data);
void new_dir_cancel (GtkWidget *widget, gpointer *data);

struct make_dir_callback {
	gchar *base_dir;
	GtkWidget *window;
	GtkWidget *entry;
};

/*
 * Create "New Directory" dialog. Check for a base dir. Display error 
 * dialog with a message if none found.
 */

void make_new_dir (GtkWidget *widget, gpointer *data)
{
	GtkWidget *window, *entry, *button, *vbox, *label, *buttonbox;
	struct make_dir_callback *info = NULL;

	info =(struct make_dir_callback *) malloc (sizeof (struct make_dir_callback));
	if (info == NULL) {g_print ("ERROR no mem allocated \n"); abort();}
	info->base_dir = strdup (current_dir);

	window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position (GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
	gtk_container_border_width (GTK_CONTAINER(window), 10);
	gtk_widget_set_usize (window, 200,110);
	info->window = window;
	gtk_window_set_title (GTK_WINDOW(window), "New directory");

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox);
	gtk_container_add (GTK_CONTAINER(window), vbox);

	label = gtk_label_new ("New name:");
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX(vbox), label, FALSE,TRUE, 0);

	entry = gtk_entry_new ();
	info->entry = entry;
	gtk_box_pack_start (GTK_BOX(vbox), entry, FALSE,TRUE, 10);
	gtk_widget_show (entry);

	buttonbox = gtk_hbox_new (TRUE, 10);
	gtk_widget_show (buttonbox);
	gtk_box_pack_start (GTK_BOX(vbox), buttonbox, FALSE, TRUE, 10);

	button = gtk_button_new_with_label ("Ok");
	gtk_widget_show (button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(new_dir_callback), info);
	gtk_box_pack_start (GTK_BOX(buttonbox), button, FALSE,TRUE, 10);
	
	button = gtk_button_new_with_label ("Cancel");
	gtk_widget_show (button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(new_dir_cancel), info);
	gtk_box_pack_start (GTK_BOX(buttonbox), button, FALSE,TRUE, 10);

	gtk_signal_connect (GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(new_dir_cancel), info);
	gtk_widget_show (window);
}

/*
 * this function is being called if the OK button on a makedir window is clicked
 * It checks if anything is entered and creates the new directory. 
 * a generic error message appears if no directory was created
 */
void new_dir_callback (GtkWidget *widget, gpointer *data)
{
	struct make_dir_callback *info;
	char *dirname;
	char *message_text;
	int return_status;

	info = (struct make_dir_callback *)data;

	dirname = completename (info->base_dir, gtk_entry_get_text (GTK_ENTRY(info->entry)));
	return_status = mkdir (dirname,493); /* 493 is a decimal &o755. there might be a better way */
	if (return_status == 0) {
		refreshlist();
		tree_add_dir (dirname, TRUE);
	} else {
		message_text = malloc (sizeof (char) * (strlen(dirname)+20));
		sprintf (message_text,  "Cant create: \"%s\"", dirname);
		message (message_text);
		free (message_text);
	}
	free (dirname);
	gtk_widget_destroy (info->window);
	return;
}

/*
 * this function frees memory and destroys the window
 * in which you can enter a new dir name.
 */
void new_dir_cancel (GtkWidget *widget, gpointer *data)
{
	struct make_dir_callback *info;
	info = (struct make_dir_callback *)data;
	gtk_widget_destroy (info->window);
	free (info);
}
