
/*
  A small vertical, xlib only, single parameter, general purpose pop-up menu.
  version 3.00, Copyright (C) 2005, 2006 Terry Loveall, <loveall@iinet.com>
  THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY OR BINARIES. COMPILE AND USE 
  AT YOUR OWN RISK.
*/

// #include	"menu.h"
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>

#include <X11/X.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>

#define NullEvent -1

char version[] = "Menu 3.02a\n";
Display * dpy;			/* The connection to the X server. */
int screen;				/* the display screen */
int display_width;		/* The width of the screen we're managing. */
int display_height;		/* The height of the screen we're managing. */

Window window;			/* Main window. */
Window root;			/* Root window. */
GC gc;					/* The default GC. */

unsigned long black;	/* Black pixel. */
unsigned long white;	/* White pixel. */
unsigned long gray;		/* Background pixel. */
unsigned long dgray;	/* Darker Border pixel. */
XColor bg, tmp;			/* Background color */

XFontStruct * font;		/* Font. */
Cursor mouse_cursor;	/* Mouse cursor. */

/* typedefs for MenuItem and Menu */
typedef struct MenuItem MenuItem;
typedef struct Menu Menu;

/* linked list struct def for individual menu items */
struct MenuItem {
    Menu *parent;
	MenuItem * next;
	
	char * name;
	char * command;
};

MenuItem * menuitem = 0;
MenuItem * selected = 0;

struct Menu {
    Menu *prev, *next;
	MenuItem *menuitems;
    Window win;
    Window parent;
    int width, height;
};

Menu *top_menu = NULL;

FILE * shell;
char * param = NULL;
char * argv0;
int numlines = 0;
int cury = -1;
int max_chars = 0;
int WinHeight;
int WinWidth;
int not_done = -1;
int itemHeight;

// func protos
void Panic(char *s);
void keyItem(int inc);
void getEvent(XEvent * ev);
MenuItem *whichItem(int mouseY);
void dispatch(XEvent * ev);
void expose(XEvent * ev);
void nullEvent(XEvent * ev);
void mouseMoved(XEvent * ev);
void buttonPress(XEvent * ev);
void buttonRelease(XEvent * ev);
void mappingnotify(XEvent * ev);
void execute(MenuItem * item);
void addMenuItem(char * name, char * command);
void readMenu(int argc, char *argv[]);
int main(int argc, char *argv[]);

/* Dispatcher struct for main event loop. */
typedef struct Disp Disp;
struct Disp {
	int	type;
	void	(*handler)(XEvent *);
};

Disp disps[] = {
	{NullEvent, nullEvent},
	{ButtonPress, buttonPress},
	{ButtonRelease, buttonRelease},
	{MotionNotify, mouseMoved},
	{Expose, expose},
	{EnterNotify, nullEvent},
	{LeaveNotify, nullEvent},
	{MappingNotify, mappingnotify},
	{VisibilityNotify, nullEvent},
};

// func definitions

// print error string and message
void Panic(char *s)
{
	fprintf(stderr, "%s: %s\n", argv0, s);
	exit(EXIT_FAILURE);
}

// convert key-up/key-down into selected hilite
void keyItem(int inc)
{
	if((inc < 0) && (cury <= itemHeight)) cury = (numlines +1) * itemHeight;
	if((inc > 0) && (cury >= (numlines * itemHeight)-1)) cury = -1;
	cury += inc;
	selected = whichItem(cury);
	expose(0);
}

// get next X event to ev
void getEvent(XEvent * ev)
{
	int fd;
	fd_set readfds;
	struct timeval tv;
	
	/* Is there a message waiting? */
	if (QLength(dpy) > 0) {
		XNextEvent(dpy, ev);
		return;
	}
	
	/* Beg... */
	XFlush(dpy);
	
	/* Wait 1 second to see if a message arrives. */
	fd = ConnectionNumber(dpy);
	FD_ZERO(&readfds);
	FD_SET(fd, &readfds);
	tv.tv_sec = 1;
	tv.tv_usec = 0;
	if (select(fd + 1, &readfds, 0, 0, &tv) == 1) {
		XKeyEvent *keve = (XKeyEvent *)ev;
		XNextEvent(dpy, ev);
		if(keve->type == KeyRelease)
		{
			int count;
			KeySym skey;
			char astr[10] = "";

			// convert key event to X-ascii in skey and interpret
			count = XLookupString(keve, astr, sizeof (astr), &skey, NULL);
			if(skey == 0xff1b) not_done = 0;			// <Esc> just exits
			if(skey == 0xff52) keyItem(-itemHeight);	// Up - prev menu item
			if(skey == 0xff54) keyItem(itemHeight);		// Down - next menu item
			if(skey == 0xff0d) buttonRelease(NULL);		// <Enter> execute selected
		}
		return;
	}
	
	/* No message, so we have a null event. */
	ev->type = NullEvent;
}

// return MenuItem pointer to y selected menu item
MenuItem *whichItem(int mouseY)
{
	int y = 0;
	MenuItem * item;
	
	for (item = menuitem; item != 0; item = item->next) {
		if (mouseY >= y && mouseY <= (y + itemHeight)) {
			cury = mouseY;
			return item;
		}
		y += itemHeight;
	}
	
	return 0;
}

// execute ev specified event handler
void dispatch(XEvent * ev)
{
	Disp * p;
	
	for (p = disps; p < disps + sizeof disps / sizeof disps[0]; p++) {
		if (p->type == ev->type) {
			if (p->handler != 0)
				p->handler(ev);
			return;
		}
	}
}

// (re)display current menu
void expose(XEvent * ev)
{
	int x, y;
	MenuItem * item;
	
	/* Only handle the last in a group of Expose events. */
	if (ev && ev->xexpose.count != 0) return;
	
	/* Clear the window. */
	XClearWindow(dpy, window);
	XSetForeground(dpy, gc, black);
	
	/* Draw the menu. */
	x = 10;
	y = 0;

	for (item = menuitem; item != 0; item = item->next) {
		y += itemHeight;
		if (item == selected) {
			XSetFunction(dpy, gc, GXinvert);
			XFillRectangle(dpy, window, gc, 
				0, y - itemHeight + 3, 
				WinWidth, itemHeight);
			XSetFunction(dpy, gc, GXcopy);
			XSetForeground(dpy, gc, gray);
		} else {
			XSetForeground(dpy, gc, black);
		}
		XDrawString(dpy, window, gc, x, y,item->name, strlen(item->name));
	}

	/* Draw '3D' outline */
	XSetForeground(dpy, gc, white);
	XDrawRectangle(dpy, window, gc, 0, 0, WinWidth - 1, WinHeight + 4);
	XSetForeground(dpy, gc, dgray);
	XDrawLine(dpy, window, gc, 0, WinHeight + 4, WinWidth - 1, WinHeight + 4);
	XDrawLine(dpy, window, gc, WinWidth - 1, WinHeight + 4, WinWidth - 1, 0);
}

// respond to a null event with expose()
void nullEvent(XEvent * ev)
{
	expose(0);
}

// set selected per mouse motion y position
void mouseMoved(XEvent * ev)
{
	while(XCheckTypedEvent(dpy, MotionNotify, ev));
	
	selected = whichItem(ev->xmotion.y);
	expose(0);
}

// interpret button press event and set selected
void buttonPress(XEvent * ev)
{
	selected = whichItem(ev->xbutton.y);
	expose(0);
}

// button release event handler: execute selected on button release
void buttonRelease(XEvent * ev)
{
	if (selected != 0) {
		execute(selected);
		selected = 0;
	}
	expose(0);
}

// mapping notify event handler
void mappingnotify(XEvent * ev)
{
	XRefreshKeyboardMapping((XMappingEvent *) ev);
}

// execute selected menu item
void execute(MenuItem * item)
{
	not_done = 0;	// exit after one execution

	if (item->command != 0) fputs(item->command,shell);
	fflush(shell);
}

// add new label/command MenuItem
void addMenuItem(char * name, char * command)
{
    int tmp = 0;
	MenuItem * newItem = (MenuItem *) malloc(sizeof(MenuItem));
	if (newItem == 0)
		return;
	
	newItem->next = 0;
	newItem->name = strdup(name);
	newItem->command = strdup(command);
	tmp = XTextWidth(font, newItem->name, strlen(newItem->name));
	
	if (menuitem == 0) {
		menuitem = newItem;
	} else {
		MenuItem * last = menuitem;
		while (last->next != 0)
			last = last->next;
		last->next = newItem;
	}
	numlines++; // count lines in menu
	if(tmp > max_chars) max_chars = tmp;
}

// Create MenuItem list from specified file, or set minimum default on none
void readMenu(int argc, char *argv[])
{
	FILE * fp;
	char* f;
	char line[BUFSIZ];

	switch (argc)
	{
		case 1:
			f=".menu";		/* default menu file to open in current dir */
			break;
		case 2:
			f=argv[1];		/* named menu file to open */
			break;
		case 3:
			f=argv[1];		/* named  menu file to open */
			param = argv[2];	/* passed param always requires named menu file */
			break;
		default:
			fprintf(stderr,"usage: menu [menu-file] [parameter]\n");
			exit(1);
	}

	if (param) {  /* 'param' set to argv[2] */
		char sb[BUFSIZ];
		sprintf(sb,"F=%s\n",param);
		fputs(sb,shell);	/* pass argv[2] as string variable '$F' */
		fflush(shell);
	}

	fp = fopen(f, "r");
	if (fp == 0) {
		addMenuItem("localhost", "exec xterm");
		return;
	}
	
	while (fgets(line, BUFSIZ, fp) != 0) {
		char * tab = strchr(line, '\t');
		if(tab == 0) continue;
		if (*line == '#') {
			continue;
		}
		if(tab == line) {
			fputs(++tab,shell);	/* execute inline tab prefixed shell code */
			fflush(shell);
			continue;
		}
		*tab = 0;
		addMenuItem(line, tab+1);
	}
	
	fclose(fp);
}

// init X stuff, create menu, create menu window and process X events
int main(int argc, char *argv[])
{
	argv0 = argv[0];
	
	/* Open a connection to the X server. */
	dpy = XOpenDisplay("");
	screen = DefaultScreen(dpy);
	if (dpy == 0) Panic("can't open display.");
	
	/* Find the screen's dimensions. */
	display_width = DisplayWidth(dpy, screen);
	display_height = DisplayHeight(dpy, screen);
	
	/* Get the pixel values of the colours we use. */
	black = BlackPixel(dpy, screen);
	white = WhitePixel(dpy, screen);
	XAllocNamedColor(dpy, DefaultColormap(dpy, screen), "Gray", &bg, &tmp);
	gray = bg.pixel;
	XAllocNamedColor(dpy, DefaultColormap(dpy, screen), "SlateGray", &bg, &tmp);
	dgray = bg.pixel;
	
	/* Get font. */
	if(!(font = XLoadQueryFont(dpy, "-*-helvetica-bold-r-*-*-12-*-*-*-*-*-iso8859-1")))
		font = XLoadQueryFont(dpy, "fixed");
	if (font == 0) Panic("can't find a font.");
	
	// set itemHeight to font full height
	itemHeight = font->ascent + font->descent;

	/* open shell for command execution */
	shell=popen("/bin/sh","w");

	/* Create the menu items. */
	readMenu(argc, argv);
	
	root = DefaultRootWindow(dpy);

	{
		int x, y;
		int root_x, root_y, dudi;
		Window dud;
		XGCValues gv;
		XSetWindowAttributes attr;
	
		/* set menu window x/y dimensions in pixels */
		WinHeight = numlines * itemHeight;
		WinWidth = max_chars + 20;

		XQueryPointer(dpy, root, &dud, &dud, &root_x, &root_y, &dudi, &dudi, &dudi);

		/* limit window placement to on screen */
		x = root_x - (WinWidth / 2) >= 0 ? root_x - (WinWidth / 2) : 0;
		x = root_x + (WinWidth / 2) >= display_width ? display_width - WinWidth : x;
		y = root_y - (WinHeight / 2) >= 0 ? root_y - (WinHeight / 2) : 0;
		y = root_y + (WinHeight / 2) >= display_height ? display_height - WinHeight - 5 : y;

		/* Set window attributes */
		attr.override_redirect = True;
		attr.background_pixel = gray;
		attr.border_pixel = black;
		attr.cursor = mouse_cursor;
		attr.event_mask = ExposureMask | VisibilityChangeMask |
			ButtonMotionMask | PointerMotionMask |
			ButtonPressMask | ButtonReleaseMask | StructureNotifyMask |
			EnterWindowMask | LeaveWindowMask | KeyPressMask;

		/* create this menu window */
		window = XCreateWindow(dpy, root,
			x,
			y,
			WinWidth, WinHeight + 5,
			1, CopyFromParent, InputOutput, CopyFromParent,
			CWOverrideRedirect | CWBackPixel | CWBorderPixel |
			CWCursor | CWEventMask,
			&attr);

		/* setup GC. */
		gv.foreground = black;
		gv.background = gray;
		gv.font = font->fid;

		/* Create GC. */
		gc = XCreateGC(dpy, window, GCForeground | GCBackground | GCFont, &gv);
	
		/* Bring up the window. */
		XMapRaised(dpy, window);
	
		XGrabKeyboard(dpy, window, True, GrabModeAsync, GrabModeAsync, CurrentTime);

		/* Make sure all our communication to the server got through. */
		XSync(dpy, False);
	}

	/* The main event loop. */
	while (not_done) {
		XEvent ev;
		getEvent(&ev);
		dispatch(&ev);
	}
	XUngrabKeyboard(dpy, CurrentTime);
	pclose(shell);
	exit(0);
}
