/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_window.c,v 1.1 2000/09/20 20:55:09 cosine Exp $
 */

#include <stdlib.h>

#include "defs.h"
#include "msg.h"
#include "print.h"
#include "window.h"

/*
c_window()
  List/manipulate curses windows
*/

void
c_window(int ac, char **av)

{
#ifdef USE_CURSES

  struct FrameInfo *fptr;
  char *endptr;
  long num;

  if (ac < 2)
  {
    /*
     * List all windows and their descriptions
     */
    Print(P_COMMAND, "Listing window numbers");
    Print(P_COMMAND,
      "Type \"window <num>\" or \"CTRL-W <num>\" to switch windows");
    Print(P_COMMAND, "");

    for (fptr = Frames; fptr->frame; ++fptr)
    {
      Print(P_COMMAND, "%-10d %-20s",
        (*(fptr->frame))->number,
        fptr->desc);
    }
  }
  else
  {
    num = strtol(av[1], &endptr, 0);
    if ((endptr == av[1]) || (*endptr != '\0'))
    {
      Print(P_COMMAND, MSG_INVNUM, av[1]);
      return;
    }

    SwitchCurrentFrame((int) num);
  }

#endif /* USE_CURSES */
} /* c_window() */
