/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_tbreak.c,v 1.2 2000/09/19 21:32:25 cosine Exp $
 */

#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "msg.h"
#include "print.h"
#include "symbols.h"

/*
 * libDebug includes
 */
#include "break.h"
#include "debug.h"

/*
c_tbreak()
  Set a temporary breakpoint at given address
*/

void
c_tbreak(int ac, char **av)

{
  unsigned long address;
  int num;
  char *endptr;

  if (ac < 2)
  {
    Print(P_COMMAND, "Syntax: tbreak <address>");
    return;
  }

  address = strtoul(av[1], &endptr, 0);
  if ((endptr == av[1]) || (*endptr != '\0'))
  {
    int err = 0;

    /*
     * They gave an invalid number, but it may be the name
     * of a register or a debugging symbol
     */
    address = FindSymbolAddress(av[1], &err);
    if (err) address = RegisterGet(av[1], &err);
    if (err)
    {
      Print(P_ERROR, MSG_INVSYM, av[1]);
      return;
    }
  }

  num = SetBreakpoint(address, BK_TEMPORARY);

  if (num == (-1))
  {
    /*
     * Most likely a ptrace error
     */
    Print(P_COMMAND, "Error occurred while setting breakpoint: %s",
      strerror(errno));
  }
  else
  {
    Print(P_COMMAND, "Breakpoint %u set for 0x%08lX (temporary)",
      num,
      address);
  }
} /* c_tbreak() */
