/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_ignore.c,v 1.2 2000/09/19 21:32:24 cosine Exp $
 */

#include <stdlib.h>

#include "msg.h"
#include "print.h"

/*
 * libDebug includes
 */
#include "break.h"

/*
c_ignore()
  Set the ignore count for a breakpoint
*/

void
c_ignore(int ac, char **av)

{
  long num,
       count;
  char *endptr;
  struct Breakpoint *ptr;

  if (ac < 3)
  {
    Print(P_COMMAND, "Syntax: ignore <number> <count>");
    return;
  }

  num = strtol(av[1], &endptr, 0);
  if ((endptr == av[1]) || (*endptr != '\0'))
  {
    Print(P_ERROR, MSG_INVNUM, av[1]);
    return;
  }

  ptr = FindBreakpointByNumber(num);
  if (!ptr)
  {
    Print(P_ERROR, "No such breakpoint number: %ld", num);
    return;
  }

  count = strtol(av[2], &endptr, 0);
  if ((endptr == av[2]) || (*endptr != '\0'))
  {
    Print(P_ERROR, MSG_INVNUM, av[2]);
    return;
  }

  SetIgnoreCount(ptr, count);
} /* c_ignore() */
