/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_file.c,v 1.10 2002/01/05 21:36:25 cosine Exp $
 */

#include "command.h"
#include "file.h"
#include "load.h"
#include "main.h"
#include "print.h"

static void c_file_header(int ac, char **av);
static void c_file_secinfo(int ac, char **av);
static void c_file_symbols(int ac, char **av);

static struct Command filecmds[] = {
  { "header", c_file_header, 0 },
  { "secinfo", c_file_secinfo, 0 },
  { "symbols", c_file_symbols, 0 },
  { 0, 0, 0 }
};

/*
c_file()
  Configure various settings
*/

void
c_file(int ac, char **av)

{
  struct Command *cptr;
  unsigned int flags;

  if (ac < 2)
  {
    Print(P_COMMAND, "Syntax: file <header | secinfo | symbols>");
    return;
  }

  flags = 0;
  cptr = FindCommand(filecmds, av[1], &flags);
  if (cptr)
  {
    /*
     * Call cptr->func to execute command
     */
    (*cptr->funcptr)(ac, av);
  }
  else
  {
    /*
     * They gave us an invalid command
     */
    Print(P_COMMAND,
      "%s command: file %s",
      (flags & C_AMBIGUOUS) ? "Ambiguous" : "Unknown",
      av[1]);
  }
} /* c_file() */

/*
c_file_header()
  Display information about the current file's header
*/

static void
c_file_header(int ac, char **av)

{
  PrintHeader(mainWorkspace_p->loadWorkspace_p);
} /* c_file_header() */

/*
c_file_secinfo()
  Display information about the current file's sections
*/

static void
c_file_secinfo(int ac, char **av)

{
  char *secname;

  secname = 0;

  if (ac > 2)
    secname = av[2];

  PrintSectionInfo(mainWorkspace_p->loadWorkspace_p, secname);
} /* c_file_secinfo() */

/*
c_file_symbols()
  Display information about the current file's symbols, if any
*/

static void
c_file_symbols(int ac, char **av)

{
  PrintSymbols(getLoadedFileFormat(mainWorkspace_p->loadWorkspace_p),
               getLoadedFileName(mainWorkspace_p->loadWorkspace_p));
} /* c_file_symbols() */
