/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_enter.c,v 1.4 2000/10/12 00:44:21 cosine Exp $
 */

#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "msg.h"
#include "output.h"
#include "print.h"
#include "symbols.h"

/*
 * libDebug includes
 */
#include "debug.h"

/*
c_enter()
  Enter value(s) into memory

Format for this command:
  enter <address> [value]
*/

void
c_enter(int ac, char **av)

{
  unsigned long address;
  unsigned long value;
  int gotvalue;
  char *endptr;

  if (ac < 2)
  {
    Print(P_COMMAND, "Syntax: enter <address> [value]");
    return;
  }

  address = strtoul(av[1], &endptr, 0);
  if ((endptr == av[1]) || (*endptr != '\0'))
  {
    int err = 0;

    /*
     * They gave an invalid number, but it may be the name
     * of a register or a debugging symbol
     */
    address = FindSymbolAddress(av[1], &err);
    if (err) address = RegisterGet(av[1], &err);
    if (err)
    {
      Print(P_ERROR, MSG_INVADDR, av[1]);
      return;
    }
  }
/*
  address = strtoul(av[1], &endptr, 0);
  if ((endptr == av[1]) || (*endptr != 0))
  {
    Print(P_COMMAND, MSG_INVADDR, av[1]);
    return;
  }
*/
  gotvalue = 0;
  value = 0;
  if (ac > 2)
  {
    value = strtoul(av[2], &endptr, 0);
    if ((endptr == av[2]) || (*endptr != '\0'))
    {
      Print(P_COMMAND, MSG_INVADDR, av[2]);
      return;
    }
    gotvalue = 1;
  }

  if (gotvalue)
  {
    if (!SetMemory(address, value))
    {
      Print(P_COMMAND, MSG_NOACCESS,
        address,
        strerror(errno));
      return;
    }
  }
  else
  {
    int done;
    int ret = 1;
    char str[MAXLINE];

    /*
     * No value given - prompt them to enter values
     */
    Print(P_COMMAND,
      "Enter new memory contents starting at location 0x%08lX (leave blank to stop)",
      address);

    done = 0;
    while (!done)
    {
      sprintf(str, "0x%08lX: ", address);
      value = NumPrompt(str, &done);
      if (!done)
      {
        ret = SetMemory(address, value);
        if (ret == 0)
        {
          Print(P_COMMAND, MSG_NOACCESS,
            address,
            strerror(errno));
          return;
        }
      }

      address += ret;
    } /* while (!done) */
  }
} /* c_enter() */
