/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_delete.c,v 1.2 2000/09/19 21:32:23 cosine Exp $
 */

#include <stdlib.h>

#include "msg.h"
#include "print.h"

/*
 * libDebug includes
 */
#include "break.h"

/*
 * libString includes
 */
#include "Strn.h"

/*
c_delete()
  Delete a breakpoint
*/

void
c_delete(int ac, char **av)

{
  long num;
  char *endptr;
  struct Breakpoint *ptr;

  if (ac < 2)
  {
    Print(P_COMMAND, "Syntax: delete <number | all>");
    return;
  }

  if (!Strcasecmp(av[1], "all"))
    num = 0;
  else
  {
    num = strtol(av[1], &endptr, 0);
    if ((endptr == av[1]) || (*endptr != '\0'))
    {
      Print(P_ERROR, MSG_INVADDR, av[1]);
      return;
    }
  }

  if (num)
  {
    ptr = FindBreakpointByNumber(num);
    if (!ptr)
      Print(P_ERROR, "No such breakpoint number: %ld", num);
    else
      DeleteBreakpoint(ptr);
  }
  else
    ClearBreakpoints();
} /* c_delete() */
