/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_clear.c,v 1.4 2000/09/21 19:31:23 cosine Exp $
 */

#include <stdlib.h>

#include "msg.h"
#include "scroll.h"
#include "print.h"
#include "window.h"

/*
c_clear()
  Clear the current active window
*/

void
c_clear(int ac, char **av)

{
#ifdef USE_CURSES

  struct Frame *frame;
  long winnum;
  char *endptr;

  if (ac < 2)
    frame = CurrentFrame;
  else
  {
    winnum = strtol(av[1], &endptr, 0);
    if ((endptr == av[1]) || (*endptr != '\0'))
    {
      Print(P_COMMAND, MSG_INVNUM, av[1]);
      return;
    }

    if (!(frame = FindFrameByNumber(winnum)))
    {
      Print(P_COMMAND,
        "Invalid window number: %d",
        winnum);
      return;
    }
  }

  ClearScrollWindow(frame);

#endif /* USE_CURSES */
} /* c_clear() */
