#!/usr/bin/perl
#
# $Id: mkdep.pl,v 1.1.1.1 2000/09/11 17:26:55 cosine Exp $
#
# This script will take an ordinary .depend file, modify
# the object file name to include a directory path and add
# a rule to compile

# Directories in which to look for .depend files
push @$DependDirs, "../libOp/arch/ix86/source";
push @$DependDirs, "../libOp/source";
push @$DependDirs, "../libDebug/arch/ix86/source";
push @$DependDirs, "../libDebug/source";

# Name of depend file to open
$DependFile = ".depend";

# Name of file containing dependency info
$DepInfoFile = ".depinfo";

foreach $dir (@$DependDirs)
{
  print STDOUT "Making dependencies in $dir\n";

  # The .depinfo file contains 2 lines: The first is the
  # include directives to gcc, the second is the location to
  # place the object files.
  open (DEPINFO, "$dir/$DepInfoFile") || 
    die "Unable to open $dir/$DepInfoFile";
  $includes = <DEPINFO>;
  $objdir = <DEPINFO>;
  close DEPINFO;

  $includes =~ s/\n//;
  $objdir =~ s/\n//;

  # Now create $DependFile
  system("cd $dir ; gcc -MM $includes `ls *.c` > $DependFile");

  open (INFILE, "$dir/$DependFile") ||
    die "Unable to open $dir/$DependFile";

  @filebuf = ();
  $source = "";

  while (<INFILE>)
  {
    # skip blank lines
    next if /^$/;

    # If the line has a ".o:" on it, insert the object directory
    # in the front
    if (m/\.o:/)
    {
      $line = $objdir . "/" . $_;
      $source = substr($_, 0, index($_, "\.o:") + 1);
      $source .= "c";
    }
    else
    {
      $line = $_;
    }

    $filebuf[++$#filebuf] = $line;

    if (! m/\\/)
    {
      $filebuf[++$#filebuf] = "	\$(CC) \$(CFLAGS) \$(INCLUDE) -o \$*.o -c $source\n";
      $filebuf[++$#filebuf] = "\n";
    }
  }

  close INFILE;

  open (OUTFILE, ">$dir/$DependFile") ||
    die "Unable to open $dir/$DependFile for writing";

  for $element (@filebuf) { print OUTFILE "$element"; }

  close OUTFILE;
}
