/*
 * libDebug
 *
 * Copyright (C) 2000 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: break.h,v 1.6 2001/10/23 19:58:16 cosine Exp $
 */

#ifndef INCLUDED_break_h
#define INCLUDED_break_h

struct Breakpoint
{
  struct Breakpoint *next, *prev;

  unsigned int number;   /* breakpoint number */
  unsigned long address; /* instruction address */
  unsigned int flags;    /* BK_xxx bitmasks */

  /*
   * This is the instruction we overwrite with our break point
   * instruction
   */
  int svdinsn;

  /*
   * Number of times we should ignore the breakpoint when we
   * hit it. When this number reaches 0, the breakpoint is no
   * longer ignored.
   */
  int ignorecnt;
};

#define BK_ENABLED      (1 << 0) /* breakpoint is activated */
#define BK_TEMPORARY    (1 << 1) /* temporary breakpoint */
#define BK_STEPOVER     (1 << 2) /* stepping over subroutine */

/*
 * Prototypes
 */
void DeleteBreakpoint(struct Breakpoint *ptr);
void ClearBreakpoints();
void ClearTemporaryBreakpoints();
int SetBreakpoint(unsigned long address, unsigned int flags);
int EnableBreakpoints();
int DisableBreakpoints();
struct Breakpoint *FindBreakpoint(unsigned long address);
struct Breakpoint *FindBreakpointByNumber(long number);
int CheckBreakpoint(struct Breakpoint *bptr);
void DeactivateBreakpoint(struct Breakpoint *ptr);
void ActivateBreakpoint(struct Breakpoint *ptr);
void SetIgnoreCount(struct Breakpoint *ptr, long count);

/*
 * External declarations
 */
extern struct Breakpoint          *Breakpoints;

#endif /* INCLUDED_break_h */
