/*
 * libDebug
 *
 * Copyright (C) 2000 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: trace-x86.h,v 1.6 2001/05/27 00:31:55 cosine Exp $
 */

#ifndef INCLUDED_trace_x86_h
#define INCLUDED_trace_x86_h

#ifndef INCLUDED_break_h
#include "break.h"        /* struct Breakpoint */
#define INCLUDED_break_h
#endif

#ifndef INCLUDED_config_h
#include "config.h"         /* OpenBSD, FreeBSD, Linux */
#define INCLUDED_config_h
#endif

/*
 * Opcode for INT 3 (breakpoint trap) instruction
 */
#define BRKPT_INSN    0xCC

#if defined(FreeBSD) || defined(OpenBSD)

/*
 * Continuation address
 */
#define CONTADDR   ((caddr_t) 1)

#define PtraceRead(pid, addr, data) \
  ptrace(PT_READ_D, (pid), (caddr_t) (addr), (data))

#define PtraceWrite(pid, addr, data) \
  ptrace(PT_WRITE_D, (pid), (caddr_t) (addr), (data))

#elif defined(Linux)

#define CONTADDR   (0)

#define PtraceRead(pid, addr, data) \
  ptrace(PT_READ_D, (pid), (addr), (data))

#define PtraceWrite(pid, addr, data) \
  ptrace(PT_WRITE_D, (pid), (addr), (data))

#endif

/*
 * Prototypes
 */
int x86StartDebugProcess();
int x86SingleStepInto(int num, int *data);
int x86SingleStepOver(int num, int *data);
int x86Continue(int *data);
int x86KillDebugProcess();
int x86SetBreakpoint(struct Breakpoint *bptr);
int x86EnableBreakpoint(struct Breakpoint *bptr);
int x86DisableBreakpoint(struct Breakpoint *bptr);
long x86DumpMemory(char **buf, unsigned long start, long bytes);
int x86SetMemory(unsigned long address, unsigned long value);

#endif /* INCLUDED_trace_x86_h */
