/*
 * libDebug
 *
 * Copyright (C) 2000 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: linux-x86.h,v 1.8 2001/04/26 23:11:45 cosine Exp $
 */

#ifndef INCLUDED_linux_x86_h
#define INCLUDED_linux_x86_h

#ifndef INCLUDED_sys_ptrace_h
#include <sys/ptrace.h>
#define INCLUDED_sys_ptrace_h
#endif

#if !defined(PT_TRACE_ME) && defined(PTRACE_TRACEME)
#  define PT_TRACE_ME PTRACE_TRACEME
#endif

#if !defined(PT_READ_I) && defined(PTRACE_PEEKTEXT)
#  define PT_READ_I PTRACE_PEEKTEXT
#endif

#if !defined(PT_READ_D) && defined(PTRACE_PEEKDATA)
#  define PT_READ_D PTRACE_PEEKDATA
#endif

#if !defined(PT_READ_U) && defined(PTRACE_PEEKUSER)
#  define PT_READ_U PTRACE_PEEKUSER
#endif

#if !defined(PT_WRITE_I) && defined(PTRACE_POKETEXT)
#  define PT_WRITE_I PTRACE_POKETEXT
#endif

#if !defined(PT_WRITE_D) && defined(PTRACE_POKEDATA)
#  define PT_WRITE_D PTRACE_POKEDATA
#endif

#if !defined(PT_WRITE_U) && defined(PTRACE_POKEUSER)
#  define PT_WRITE_U PTRACE_POKEUSER
#endif

#if !defined(PT_CONTINUE) && defined(PTRACE_CONT)
#  define PT_CONTINUE PTRACE_CONT
#endif

#if !defined(PT_KILL) && defined(PTRACE_KILL)
#  define PT_KILL PTRACE_KILL
#endif

#if !defined(PT_STEP) && defined(PTRACE_SINGLESTEP)
#  define PT_STEP PTRACE_SINGLESTEP
#endif

#if !defined(PT_GETREGS) && defined(PTRACE_GETREGS)
#  define PT_GETREGS PTRACE_GETREGS
#endif

#if !defined(PT_SETREGS) && defined(PTRACE_SETREGS)
#  define PT_SETREGS PTRACE_SETREGS
#endif

#if !defined(PT_GETFPREGS) && defined(PTRACE_GETFPREGS)
#  define PT_GETFPREGS PTRACE_GETFPREGS
#endif

#if !defined(PT_SETFPREGS) && defined(PTRACE_SETFPREGS)
#  define PT_SETFPREGS PTRACE_SETFPREGS
#endif

#if !defined(PT_ATTACH) && defined(PTRACE_ATTACH)
#  define PT_ATTACH PTRACE_ATTACH
#endif

#if !defined(PT_DETACH) && defined(PTRACE_DETACH)
#  define PT_DETACH PTRACE_DETACH
#endif

#if !defined(PT_SYSCALL) && defined(PTRACE_SYSCALL)
#  define PT_SYSCALL PTRACE_SYSCALL
#endif

/*
 * Prototypes
 */

char **x86GetAllRegisters(int *count, int regindex);
int x86FindRegister(char *name);
int x86SetRegister(int regindex, long value);
unsigned long x86GetCurrentInstruction(int *err);
int x86SetCurrentInstruction(unsigned long address);

#endif /* INCLUDED_linux_x86_h */
