/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: symbols.h,v 1.3 2001/05/28 01:48:06 cosine Exp $
 */

#ifndef INCLUDED_symbols_h
#define INCLUDED_symbols_h

struct aSymbol
{
  struct aSymbol *next;
  void *data;           /* pointer to data for this node */
};

/*
 * TraverseSymbols() will check the return value of the function
 * passed to it to determine whether to stop traversing the
 * symbol data structure
 */
#define ST_STOP       0  /* stop traversing symbols */
#define ST_CONTINUE   1  /* continue traversing symbols */

/*
 * Prototypes
 */

void LoadSymbol(void *data);
void *TraverseSymbols(int (*func)(void *data, void *arg), void *param);
unsigned int FindSymbolAddress(char *name, int *err);
char *FindSymbolByAddress(unsigned int address, int *err);

/*
 * External declarations
 */

extern char               *SymbolStringTable;
extern unsigned int       TotalSymbols;

#endif /* INCLUDED_symbols_h */
