/* 	$Id: SmeCascadP.h,v 1.3 1998/02/05 21:28:10 pirx Exp $	 */

/*
 * Author: Achim Bangert (abangert@ix.urz.uni-heidelberg.de)
 */

/*
Copyright (c) 1987  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/


#ifndef _SmeCascadeP_h
#define _SmeCascadeP_h


#ifdef XAW3D
#include <X11/Xaw3d/SmeBSBP.h>
#else
#include <X11/Xaw/SmeBSBP.h>
#endif
#include "SmeCascade.h"

typedef struct {
  int empty;
} SmeCascadeClassPart;

typedef struct _SmeCascadeClassRec {
  RectObjClassPart rect_class;
  SmeClassPart sme_class;
#ifdef XAW3D
  SmeThreeDClassPart sme_threeD_class;
#endif
  SmeBSBClassPart sme_bsb_class;
  SmeCascadeClassPart sme_cascade_class;
} SmeCascadeClassRec;

extern SmeCascadeClassRec smeCascadeClassRec;

typedef struct {
  /* resources */
  Widget submenu_shell;
} SmeCascadePart;

typedef struct _SmeCascadeRec {
  ObjectPart object;
  RectObjPart rectangle;
  SmePart sme;
#ifdef XAW3D
  SmeThreeDPart sme_threeD;
#endif
  SmeBSBPart sme_bsb;
  SmeCascadePart sme_cascade;
} SmeCascadeRec;

#endif /* _SmeCascadeP_h */
