/* 	$Id: ListselP.h,v 1.27 1997/12/07 19:18:06 pirx Exp $	 */

/*
 * Author: Achim Bangert (abangert@ix.urz.uni-heidelberg.de)
 */

/***********************************************************

Copyright (c) 1987, 1988  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.


Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* Private definitions for Dialog widget */

#ifndef _ListselP_h
#define _ListselP_h

#include <X11/CompositeP.h>
#include "Listsel.h"


typedef struct {int empty;} ListselClassPart;

typedef struct _ListselClassRec {
  CoreClassPart	core_class;
  CompositeClassPart composite_class;
  ConstraintClassPart constraint_class;
  ListselClassPart listsel_class;
} ListselClassRec;

extern ListselClassRec listselClassRec;

/*
 * list denotes a list of strings; index, pos stand for lists of integers
 * index is related to choices_list; pos counts relative to sorted_index
 */

typedef struct _XlswSubListStruct {
  int *pos;
  String *list;
  int num;
} XlswSubListStruct;

typedef struct _ListselPart {
  /* resources */
  String *choices_list;
  int num_choices;
  int *selected_index;
  int num_selected;
  String headline_label;
  String available_label;
  String selected_label;
  String reset_cmd_label;
  String exchange_cmd_label;
  String accept_cmd_label;
  String reject_cmd_label;
  Dimension spacing;
  int config_flags;
  XtCallbackList select_callbacks;
  XtCallbackList deselect_callbacks;
  XtCallbackList reset_callbacks;
  XtCallbackList exchange_callbacks;
  XtCallbackList accept_callbacks;
  XtCallbackList reject_callbacks;
  XlswComparisonFunction comparison_function;
  /* internal data */
  GC cpy_gc;
  GC inv_gc; 
  double viewp_width_ratio;
  Position grip_last_x;
  Dimension old_width;
  Dimension old_height;
  Dimension preferred_width;
  Dimension preferred_height;
  int *sorted_pos;
  int *sorted_index;
  int *return_index;
  int return_allocated;
  XlswSubListStruct available; 
  XlswSubListStruct selected;
  int num_allocated;
  /* widgets */
  Widget headline_label_w;
  Widget available_label_w;
  Widget selected_label_w;
  Widget available_viewp_w;
  Widget selected_viewp_w;
  Widget available_list_w;
  Widget selected_list_w;
  Widget set_box_w;
  Widget reset_cmd_w;
  Widget exchange_cmd_w;
  Widget closure_box_w;
  Widget accept_cmd_w;
  Widget reject_cmd_w;
  Widget grip_w;
} ListselPart;

typedef struct _ListselRec {
  CorePart core;
  CompositePart	composite;
  ConstraintPart constraint;
  ListselPart listsel;
} ListselRec;

typedef struct _ListselConstraintsPart {
  Position x;
  Position y;
  Dimension width;
  Dimension height;
  Dimension border_width;
} ListselConstraintsPart;

typedef struct _ListselConstraintsRec {
  ListselConstraintsPart listsel;
} ListselConstraintsRec, *ListselConstraints;

#endif






