/***************************************************************************
                          swmswitch.c  -  description
                          ---------------------------
    begin                : Sam Jul 22 11:40:05 CEST 2000
    copyright            : (C) 2000 by Robert Sperling
    email                : sperling@small-window-manager.de
    version              : v1.3.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <string.h>

Window                          switchWin;
Window				windowList[200];
Display                        *display;
int                             screenNo;
unsigned long                   background;
unsigned long                   foreground;
GC                              gc;
unsigned long                   windowCount=0;
unsigned long                   maxWidth;
unsigned long                   used;
XContext			taskContext;
XFontStruct			*swmswitchFont;
Atom				xa_wm_state;
int				charHeight = 12;
#define true            	1
#define false           	0

/****************************************************************************/

int getWmState(Window givenWin)
{ Atom 		realType;
  int 		realFormat;
  int		state = WithdrawnState;
  unsigned long d, extra;
  unsigned char *data;
 
    if ((XGetWindowProperty(display, givenWin, xa_wm_state, 0, 2, False,
                            AnyPropertyType, &realType, &realFormat, &d,
                            &extra, &data) == Success) && d) 
    { state = *(int *)data;
      if (data) XFree(data);
    }/* endif */ 
    return state;
}/* end getWmState */ 

/****************************************************************************/

void getWmName(Window givenWin, char *buffer, size_t bufferLength)
{ char *windowName;

  XFetchName(display, givenWin, &windowName);
  if (!windowName) { strcpy(buffer, "unknown"); return; }
  
  if (getWmState(givenWin) == NormalState) 
  { if (strlen(windowName) >= bufferLength) 
      strcpy(windowName+bufferLength-4, "...");
     strcpy(buffer, windowName);
  } 
  else 
  { if (strlen(windowName) >= bufferLength-2) 
      strcpy(windowName+bufferLength-6, "...");
    sprintf(buffer, "(%s)", windowName);
  }  
  XFree(windowName);
}/* end getWmName */ 

/****************************************************************************/

void makeClientButton(Window clientWin)
{ char buffer[80];
  int bufferLength;
  getWmName(clientWin, buffer, sizeof buffer);
  bufferLength = strlen(buffer);
  if (strcmp(buffer,"swmSwitch"))
  { windowCount++;
    windowList[windowCount]=clientWin;  
    XDrawString(display,switchWin,gc,1,charHeight*windowCount,
                buffer,bufferLength);
    if (bufferLength>maxWidth) maxWidth=bufferLength;
  }/* endif not swmSwitch */
} 

/****************************************************************************/

void scanForClients (Window rootWindow) 
{ Window dummy, *wins;     
 unsigned int i, nwins;     
 XPointer foo;  
    
 if (XFindContext(display, rootWindow, taskContext, &foo) == Success) 
 { //No use to implement this
   //updateClientButton(rootWindow); 
 } 
 else 
   if (getWmState(rootWindow) != WithdrawnState) 
   { makeClientButton(rootWindow);
   } 
   else 
     if (XQueryTree(display, rootWindow, &dummy, &dummy, &wins, &nwins)) 
     { for (i = 0; i < nwins; i++) scanForClients(wins[i]);
         XFree(wins);
     }
}/* end scanForClients */                                                                                                  

/****************************************************************************/

void redrawSwitch()
{ 
 Window rootWin;
 
 windowCount=0;
 maxWidth=10;
 rootWin=DefaultRootWindow(display);
 scanForClients(rootWin);
 
 XResizeWindow(display,switchWin,10+maxWidth*5,windowCount*charHeight+5);
}/* end redrawSwitch */

/****************************************************************************/

void raisewin()
{ int x,y,dx,dy;
unsigned int mr;
  Window dw1,dw2;
  XQueryPointer(display, switchWin, &dw1, &dw2, &dx, &dy, &x, &y, &mr);      
  y = 1+ (y-5) / charHeight;
  fprintf(stderr,"raising %d",y);
  XMapRaised(display, windowList[y]);
//  XSync(display, False);
}

/****************************************************************************/

int main()
{
 // Variableninitialisierung
 XEvent ev;        // Fuer die Events in main
 int done = 0;     // Haupt-Event-Loop
 XGCValues gv;
 static char windowName[] = "swmSwitch";
 int x,y,dx,dy;
 unsigned int mr;
 Window dw1,dw2,rootWindow;
 
 //Display oeffnen
 display = XOpenDisplay(NULL); 

 if (!display) 
 {  fprintf(stdout,"swm: cannot open display, make sure DISPLAY is set.\n");
 }/* endif */
 else
 { screenNo = DefaultScreen(display);
   background = WhitePixel (display, screenNo);
   foreground = BlackPixel (display, screenNo);
   swmswitchFont = XLoadQueryFont(display, "fixed");
   if (swmswitchFont==(XFontStruct *) NULL)
   { /* fixed not available */
#ifdef DEBUG
     err(0,"> sorry, can't even load font fixed, giving up");
#endif    
   }/* end if no fixed */
   else
   { rootWindow=DefaultRootWindow(display);
     XQueryPointer(display, rootWindow, &dw1, &dw2, &x, &y, &dx, &dy, &mr);

     switchWin = XCreateSimpleWindow(display, rootWindow, 
                                     x, y, 50, 20, 1,foreground, background);

     gv.foreground=foreground;
     gv.font = swmswitchFont->fid;
     gc=XCreateGC(display,switchWin,GCForeground | GCFont,&gv);

     XStoreName(display,switchWin,windowName);
 
     XSelectInput(display, switchWin, ButtonPressMask | ExposureMask);

     XMapRaised (display,switchWin);
     XMoveWindow(display,switchWin,x,y);
 
     xa_wm_state = XInternAtom(display, "WM_STATE", False);

     while(!done) 
     { XNextEvent(display, &ev);
       switch (ev.type) 
       { 
         case Expose:      redrawSwitch();
              break;
         case ButtonPress: raisewin();
                           done=1;  
       }/* end switch */
     }/* end Event-loop */ 
   }/* end if no font */
   XDestroyWindow(display,switchWin);
   XCloseDisplay(display);
 }/* end if no display */
 return 0;
}/* end main */

/****************************************************************************/
