/***************************************************************************
                            swmbg.c  -  description
                            -----------------------
    begin                : Sun Jan 21 13:41:02 CEST 2001
    copyright            : (C) 2001 by Robert Sperling
    email                : sperling@small-window-manager.de
    version              : v1.3.1
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <X11/xpm.h>
#include <stdio.h>

Window                          rootWindow;
Display                        *display;
int                             screenNo;
unsigned long                   black,white;
GC                              gc;
Pixmap				pixmap;

/**************************************************************************/

int main(int argc, char *argv[])
{
  // Variableninitialisierung
  XWindowAttributes rootAttribs;                                                  
  XpmAttributes xpmAttribs;                                                 
  Pixmap shapeMask;                                                             
  int val;
  
  /* Display oeffnen */
  display = XOpenDisplay(""); 

  if (display) 
  { rootWindow = RootWindow (display, screenNo);
 
    //Vorder & Hintergrund festlegen
    XGetWindowAttributes(display,rootWindow,&rootAttribs);                                    
    xpmAttribs.colormap = rootAttribs.colormap;                                 
    xpmAttribs.valuemask = XpmSize | XpmReturnPixels | XpmColormap;             
    if ((val = XpmReadFileToPixmap (display,rootWindow, argv[1], &pixmap, &shapeMask,                                  
                                    &xpmAttribs))!= XpmSuccess)                        
    { if(val == XpmOpenFailed)                                                  
        fprintf(stderr, "Couldn't open pixmap file\n");                         
      else if(val == XpmColorFailed)                                            
        fprintf(stderr, "Couldn't allocated required colors\n");                
      else if(val == XpmFileInvalid)                                            
        fprintf(stderr, "Invalid Format for an Xpm File\n");                    
      else if(val == XpmColorError)                                             
        fprintf(stderr, "Invalid Color specified in Xpm FIle\n");               
      else if(val == XpmNoMemory)                                               
        fprintf(stderr, "Insufficient Memory\n");                               
    }
    else
    { XSetWindowBackgroundPixmap(display, rootWindow, pixmap);
      XClearWindow(display,rootWindow);
      XSetCloseDownMode(display, RetainPermanent); 
    }  
    XCloseDisplay(display);
    return 0;
  }
  return 1;
}
