/***************************************************************************
                           tools.c  -  description
                           -----------------------
    begin                : Wed May 22 10:12:15 CEST 2001
    copyright            : (C) 2000-2002 by Robert Sperling
    email                : sperling@small-window-manager.de
    version              : v1.3.4
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 * description: this file contains all essential things for handling       *
 *              internal data structures                                   *
 ***************************************************************************/

/***************************************************************************/
/* getClient 
   finds to a given window the client managing it
   
   v1.3.0-pre1: initial release
   v1.3.0-pre2: changed checking order, added anyWindow
   v1.3.0-pre3: added pixmap support
   v1.3.0-pre4: bugs are always where you can't find them. getClient has
                been too good in DEBUGPARANOID, some clients should not
		be found! (unmapping of buttons in toggleFrameHidden)
   v1.3.2:      made it less verbose in ordinary debug mode
*/
Client *getClient(Window givenWin, int whichWindow)
{ Client *client;

#ifdef TRACE
  trace (0,"getClient(*)"); 
#endif

#ifndef MINIMAL
  if (givenWin)
  { 
#endif  
    if (givenWin != rootWindow)
    { if (whichWindow==parentWindow)
      { for (client = headClient; client; client = client->next)
        { if (givenWin == client->parent) return client;
#ifdef PIXMAPS
          if (givenWin == client->closebox) return client;
#ifdef MAXIMIZE
	  if (givenWin == client->maxbox) return client;
#endif	  

#ifdef GNOME
	  if (givenWin == client->stickybox) return client;
#endif // GNOME
	  
#endif // PIXMAPS
	}// end for 
      }	  
      else if (whichWindow==childWindow)
      { for (client = headClient; client; client = client->next)
          if (givenWin == client->window) return client;
      }
      else if (whichWindow==anyWindow)
      { for (client = headClient; client; client = client->next)
        { if (givenWin == client->window) return client;
          if (givenWin == client->parent) return client;
#ifdef PIXMAPS
          if (givenWin == client->closebox) return client;
#ifdef MAXIMIZE
	  if (givenWin == client->maxbox) return client;
#endif	  

#ifdef GNOME
	  if (givenWin == client->stickybox) return client;
#endif // GNOME

#endif // PIXMAPS 	  
        }// end for 
      }// end if anywindow 
    }// end if not root window 
#ifndef MINIMAL
  }// end if no window is given   
#endif
#ifdef DEBUGPARANOID
  err ("have not found client");   
#endif  
  return NULL;
}// end getClient

/***************************************************************************/

/* getFocusedClient
   gets the currently focused client
 
   v1.3.0-pre1: initial release 
   v1.3.0-pre2: no change
   v1.3.0-pre3: changed to anyWindow
   v1.3.0-pre4: added test for correct focusedClient
   v1.3.3:	client was not pre-initialized  
   
*/ 
#ifdef KEYS
Client *getFocusedClient() 
{ 
  Client *client = NULL; 
  Window  focusedWindow = 0; 
  int     dummyInt; 
 
#ifdef TRACE 
  trace (0,"getFocusedClient(*)"); 
#endif 
 
  XGetInputFocus(display, &focusedWindow, &dummyInt); 
  
  if (focusedWindow)
  { client = getClient (focusedWindow, anyWindow); 

    // It seems a client is really focused
    if (client)
    {
#ifdef DRAWTITLE    
#ifdef DEBUG
      if (client->name) err("focusedClient: %s",client->name);
#endif    
#endif
     
      if (focusedWindow!=client->window)
      {
#ifdef DEBUG  
        err("error: client window is not correctly focused");
#endif    
        // sometimes it happens that a wrong part of the client is focused
	// it will now be corrected
        XSetInputFocus(display, client->window, RevertToPointerRoot,
	               CurrentTime);
      }// end if client not correctly focused 
    }// end if client
    else
    {
#ifdef DEBUGPARANOID  
      err("error: no client focused");
#endif    
    }
  }// end if window is not valid
  else
  {
#ifdef DEBUGPARANOID  
    err("error: got no focused window");
#endif    
  }      
  return client;   
}// end getFocusedClient  
#endif // KEYS 

/***************************************************************************/

/* getNextFocusClient
   gets the next client out of the list of clients, if it does not want the
   focus the next will be choosen - until a client is found or the current
   is selected again

   v1.3.0-pre1: initial release
   v1.3.0-pre2: changed to avoid deadlocks
   v1.3.0-pre3: no change
   v1.3.0-pre4: eliminated focusedClient
   v1.3.1:	eliminated old ->destroyed
   v1.3.3:      oops, counter was uninitialized
*/ 
#ifdef KEYS
Client *getNextFocusClient()
{ Client *client;
  Client *oldFocused;
  int     counter = 0;

#ifdef GNOME
  int     finished=false;
#endif // GNOME 
  
#ifdef TRACE 
  trace (1,"getNextFocusedClient"); 
#endif 

  client     = getFocusedClient();  
  if (!client) client = headClient;
  oldFocused = client;

#ifdef GNOME 
  while (counter < !finished)
  { 
#endif // GNOME 

    if   (client->next) client=client->next;
    else                client=headClient;

#ifdef GNOME    
    if(!getValuedHint(client->window, xa_windowHints)&WIN_HINTS_SKIP_FOCUS) 
    { if (client->desktop==currentDesktop) finished=true; 
    }
    if (client==oldFocused) finished=true;
  }// end while not finished 
#endif // GNOME  

  XSetInputFocus(display, client->window,RevertToPointerRoot, CurrentTime); 
  
#ifdef TRACE 
  trace (-1,"getNextFocusedClient"); 
#endif 

  return client;
}// end getNextFocusedClient 
#endif // KEYS 

/***************************************************************************/

/* getClickedItem
   finds out, which button was clicked

   v1.3.0-pre1: initial release
   v1.3.0-pre2: added WINDOWBODY
                this function is still very poor but it may work for a while
   v1.3.0-pre3: redesigned, should work now as expected, two versions for
                pixmaps/nopixmaps		
   v1.3.0-pre4: no change
   v1.3.0-pre5: changed to return windowbody if frame is hidden
   v1.3.1:      removed in MINIMAL mode

   #define TITLEBAR  = 0
   #define CLOSEBOX  = 1
   #define MAXBOX    = 2
   #define STICKYBOX = 3
   #define WINDOWBODY= 4
*/

#ifndef MINIMAL
#ifndef PIXMAPS   
int getClickedItem(Client *client, int x, int y)
{ int buttonNumber;

#ifdef MWM  
  if (client->frameState==FRAMESHOWN)
  { 
#endif // MWM
    if (y<=TITLEBARHEIGHT)
    { // titlebar was clicked

      buttonNumber=((client->width-x)/TITLEBARHEIGHT)+1;

      if (buttonNumber==CLOSEBOX) 
        return CLOSEBOX;

      if (buttonNumber==MAXBOX) 
#ifdef MAXIMIZE
        return MAXBOX;
#else
#ifdef GNOME
        return STICKYBOX;
#endif // GNOME 	
#endif // ELSE MAXIMIZE 

#ifdef GNOME    
#ifdef MAXIMIZE
      if (buttonNumber==STICKYBOX) 
        return STICKYBOX;
#endif // MAXIMIZE  
#endif // GNOME 
      return TITLEBAR;
    }
    else    
    { return WINDOWBODY;
    }
#ifdef MWM    
  } 
#endif // MWM  
  return TITLEBAR;
}// end getClickedItem - no PIXMAP 

#else // ------- PIXMAPS --------- 

int getClickedItem(Client *client, Window window, int y)
{
  if (window==client->closebox) return CLOSEBOX;

#ifdef MAXIMIZE
  if (window==client->maxbox)    return MAXBOX;
#endif // MAXIMIZE 
  
#ifdef GNOME
  if (window==client->stickybox) return STICKYBOX;
#endif // GNOME 

#ifdef MWM  
  if (window==client->parent) 
  {
    if (client->frameState==FRAMESHOWN)
    { if (y<=TITLEBARHEIGHT) return TITLEBAR;
      else return WINDOWBODY;
    }
    else
    { return WINDOWBODY;
    }  
  } else 
  { return WINDOWBODY;
  }
#endif // MWM 
  return TITLEBAR;
}// end getClickedItem - PIXMAPS 
#endif // PIXMAPS 
#endif
	
/***************************************************************************/

/* changeGravity
   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: no change
*/
void changeGravity(Client *client, int multiplier)
{ int dy = 0;
  int gravity;

#ifdef TRACE
  trace (1,"changeGravity"); 
#endif

  gravity = (client->size->flags & PWinGravity) ?
             client->size->win_gravity : NorthWestGravity;

  switch (gravity) 
  { case NorthWestGravity:
    case NorthEastGravity: 
    case NorthGravity:  
         dy = TITLEBARHEIGHT; 
         break;
#ifndef MINIMAL
    case CenterGravity: dy = TITLEBARHEIGHT/2; break;
#endif    
  }// end switch
  client->y += multiplier * dy;

#ifdef TRACE
  trace (-1,"changeGravity"); 
#endif
}// end changeGravity 

/***************************************************************************/

/* getWindowUnderPointer 
   returns the window under the pointer
   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: added extra check
*/ 
#ifndef MINIMAL
Window getWindowUnderPointer(Window givenWin) 
{ 
  Window dummywin, returnWin; 
  int x, y, wx, wy, mask; 
 
#ifdef TRACE 
  trace (0,"getWindowUnderPointer(*)"); 
#endif 
 
  if (givenWin) 
  { XQueryPointer(display, givenWin, &dummywin, &returnWin, 
                  &x, &y, &wx, &wy, &mask); 
   return returnWin; 
  }
  
#ifdef DEBUGPARANOID
  err ("no window under cursor");
#endif
  return 0; 
}// getWindowUnderPointer 
#endif // NOT MINIMAL 
/***************************************************************************/

/* sendXMessage 
   sends a xwindow event to the window "givenWin" 
   
   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: no change
*/

int sendXMessage(Window givenWin, Atom xatom, long value)
{ XEvent event;

#ifdef TRACE
  trace (0,"sendXMessage(*)");
#endif

  event.type 			= ClientMessage;
  event.xclient.window 		= givenWin;
  event.xclient.message_type 	= xatom;
  event.xclient.format 		= 32;
  event.xclient.data.l[0] 	= value;
  event.xclient.data.l[1] 	= CurrentTime;

  return XSendEvent(display, givenWin, False, NoEventMask, &event);
}// end sendXmessage 

/***************************************************************************/
