/***************************************************************************
                            swm.h  -  description
                            ---------------------
    begin                : Wed May 22 10:12:15 CEST 2001
    copyright            : (C) 2000-2002 by Robert Sperling
    email                : sperling@small-window-manager.de
    version              : v1.3.4
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         * 
 ***************************************************************************/

/*
Definitionen: client->y,height geben die Umrisse des childWindow an

*/

/***************************************************************************
 * Internal dependencies - NEWER CHANGE THIS YOURSELF!                     *
 ***************************************************************************/

#define SWMVERSION	"1.3.4"

#include "swm.depend"
#include "keybindings.conf"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#ifndef MINIMAL
#include <stdlib.h>
#include <string.h>
#endif

// Constants to make the code more readable 
#define true        	  1
#define false       	  0
#define TITLEBAR  	  0
#define CLOSEBOX  	  1
#define MAXBOX    	  2
#ifdef GNOME
#define STICKYBOX 	  3
#endif
#ifndef MINIMAL
#define WINDOWBODY        4
#endif
#define POINTERNORMALMODE 0
#define POINTERMOVEMODE   1
#define POINTERRESIZEMODE 2
#ifdef NORESIZEWARP
#define POINTERBOXRESIZEMODE 3
int handledClient_old_y;
#endif // NORESIZEWARP

#define STARTACTION	  0
#define ACTION		  1
#define ENDACTION	  2

#define FRAMESHOWN	  0
#ifdef MWM
#define FRAMEHIDDEN       1
#define FRAMELESS         2
#endif // MWM

#define ChildMask        (SubstructureRedirectMask|SubstructureNotifyMask)
#define ButtonMask       (ButtonPressMask|ButtonReleaseMask)
#define MouseMask        (ButtonMask|PointerMotionMask)


// X11 needed things 
static Display *	  display;
static char		 *displayOption = "";

// size of the screen 
#ifndef MINIMAL
int			  xmax;
int			  ymax;
#endif /* MINIMAL */
int			  motionStartingX;
int			  motionStartingY;

static int		  screen;

static Window		  rootWindow;

/* used atoms */
Atom                      xa_wm_state;
Atom                      xa_wm_change_state;

Atom                      xa_wm_protos;
Atom                      xa_wm_delete;

#ifdef LOWCOLOR
Atom                      xa_wm_cmapwins;
#endif
#ifdef MWM
Atom			  xa_mwm_wm_hints;
#endif

#ifdef LAYERS
Atom			   xa_windowLayer;
#endif

#ifndef MINIMAL
GC                        invertGC;
#endif

#ifdef FONTS
GC                        stringGC;
#endif
GC                        borderGC;

XColor			  backgroundColor,borderColor;
#ifndef MINIMAL
XColor                    foregroundColor;
char                     *givenFG = FOREGROUND;
#endif
char                     *givenBG = BACKGROUND;
char                     *givenBC = BORDERCOLOR;

#ifdef CURSORS
Cursor                    moveCursor;
Cursor                    resizeCursor;
Cursor			  bodyCursor;
Cursor			  windowCursor;
#endif

#ifdef CENTERNEW
int			  scanWindows;
#endif
/* if no font at all is available this is set to false*/
#ifdef FONTS
int			  fontAvailable;
XFontStruct		 *swmFont;
char			 *fallbackFont = "-monotype-arial-medium-r-normal-*-*-120-*-*-p-*-iso8859-15";
char			 *givenFont    = TITLEBARFONT;
#endif /* FONTS */

/* internal management stuff */
#ifdef GNOME
int			  currentDesktop;
#endif

int			  clientCounter;
int			  exitSWM = false;
int			  pointerMode = POINTERNORMALMODE;

#ifdef PIXMAPS
typedef struct 
{ 
  Pixmap                  pixmap, mask; 
  int                     width, height; 
} pixmapStruct; 

pixmapStruct		  closeBoxPix;
pixmapStruct		  maxBoxPix;
pixmapStruct		  stickyBoxPix;
pixmapStruct		  unStickyBoxPix;
pixmapStruct		  backgroundPix;
#endif /* PIXMAPS */

//******************** CLIENT - STRUCTURE ********************************
typedef struct Client     Client;

struct Client {
	Client		 *next;
	Window		  window;
	Window		  parent;
#ifdef PIXMAPS
	Window		  closebox;
#ifdef MAXIMIZE
	Window		  maxbox;
#endif
#ifdef GNOME
	Window		  stickybox;
#endif
#endif

#ifdef DRAWTITLE
	char		 *name;
#endif
	
#ifdef GNOME
        int 		  desktop;
        int 		  sticky;
#endif

#ifdef MWM
	int		  frameState;
#endif

#ifdef LOWCOLOR
	Colormap	  cmap;
#endif
#ifdef SHADE
	int		  shaded;	
#endif

	XSizeHints	 *size;
	int		  ignoreUnmap;

	int		  x;
	int		  y;
#ifdef MAXIMIZE	
	int               normalX;
	int		  normalY;
	int               normalWidth;
	int               normalHeight;
#endif
	
	int		  width;
	int		  height;

#ifdef MAXIMIZE	
	int		  maximized;	
#endif	
        int 		  destroyed;

#ifdef LAYERS
	int		  layer;
#endif // LAYERS
	long		  hints;
};

Client *headClient = NULL;

// Needed to keep track of the manipulated window
Client *handledClient = NULL;

#ifdef GNOME
#ifndef NORAISE
Client *raisedClient;
#endif
#define WIN_STATE_STICKY          (1<<0) /*everyone knows sticky*/
#define WIN_STATE_MINIMIZED       (1<<1) /*Reserved - definition is unclear*/
#define WIN_STATE_MAXIMIZED_VERT  (1<<2) /*window in maximized V state*/
#define WIN_STATE_MAXIMIZED_HORIZ (1<<3) /*window in maximized H state*/
#define WIN_STATE_MAXIMIZED       (WIN_STATE_MAXIMIZED_VERT|WIN_STATE_MAXIMIZED_HORIZ)
#define WIN_STATE_HIDDEN          (1<<4) /*not on taskbar but window visible*/
#define WIN_STATE_SHADED          (1<<5) /*shaded (MacOS / Afterstep style)*/
#define WIN_STATE_HID_WORKSPACE   (1<<6) /*not on current desktop*/
#define WIN_STATE_HID_TRANSIENT   (1<<7) /*owner of transient is hidden*/
#define WIN_STATE_FIXED_POSITION  (1<<8) /*window is fixed in position even*/
#define WIN_STATE_ARRANGE_IGNORE  (1<<9) /*ignore for auto arranging*/
#define WIN_HINTS_SKIP_FOCUS      (1<<0) /*"alt-tab" skips this win*/
#define WIN_HINTS_SKIP_WINLIST    (1<<1) /*do not show in window list*/
#define WIN_HINTS_SKIP_TASKBAR    (1<<2) /*do not show on taskbar*/
#define WIN_HINTS_GROUP_TRANSIENT (1<<3) /*Reserved - definition is unclear*/
#define WIN_HINTS_FOCUS_ON_CLICK  (1<<4) /*app only accepts focus if clicked*/
#endif

#ifdef LAYERS
#define WIN_LAYER_DESKTOP          0
#define WIN_LAYER_BELOW            2
#define WIN_LAYER_NORMAL           4
#define WIN_LAYER_ONTOP            6
#define WIN_LAYER_DOCK             8
#define WIN_LAYER_ABOVE_DOCK      10
#define WIN_LAYER_MENU            12
#endif

#ifdef MWM
#define MWM_HINTS_DECORATIONS     (1L<<1) 
#define MWM_DECOR_ALL             (1L<<0) 
#define MWM_DECOR_BORDER          (1L<<1) 
#define MWM_DECOR_TITLE           (1L<<3) 
#define MWM_DECOR_MAXIMIZE        (1L<<6) 
#endif /* MWM */

#ifdef LAYERS
int			   windowLayerNormal = WIN_LAYER_NORMAL;
#endif										
	
#ifdef MWM
typedef struct 
{ 
  CARD32 flags; 
  CARD32 functions; 
  CARD32 decorations; 
  INT32 inputMode; 
  CARD32 status; 
} PropMwmHints; 
#endif /* MWM */

#define parentWindow 1
#define childWindow  0
#define anyWindow    2

Client *getClient(Window givenWin, int whichWindow);

/* swm.c */
void swmQuitNicely();

/* tools.c */
Client *getClient(Window givenWin, int whichWindow);
#ifdef GNOME
Client *getNextClient(int keepOnDesktop, int skipFocus, int skipWinList);
#endif

#ifndef MINIMAL
Client *getFocusedClient(); 
#endif

#ifdef GNOME
Client *getNextFocusClient(); 
#endif

#ifdef PIXMAPS
int getClickedItem(Client *client, Window window, int y);
#else
int getClickedItem(Client *client, int x, int y);
#endif
void changeGravity(Client *client, int multiplier);

#ifdef GNOME
Window getWindowUnderPointer(Window w); 
#endif

int sendXMessage(Window givenWin, Atom xatom, long x);

/* client.c */
#define UPDATESIZE 1	
void sendConfig		(Client *client);	  
//#ifdef FAST
void drawOutline	(Client *client);
//#endif

void updateClient	(Client *client, int whatToUpdate);


#ifdef SHADE
void toggleClientShaded	(Client *client); 
#endif
#ifndef MINIMAL
void toggleFrameHidden	(Client *client); 
#endif
void hideClient		(Client *client);
void unhideClient	(Client *client);

#ifdef LAYERS
void setClientLayer	(Client *client, int newLayer); 
int  getClientLayer	(Client *client); 
#endif

void raiseClient	(Client *client);
#ifndef NORAISE
void raiseNextClient    ();
#endif
#ifndef MINIMAL
void lowerClient	(Client *client);
void focusClient	(Client *client); 
#endif
void createNewClient	(Window givenWin);

/* old one, to be removed */
void removeClient       (Client *client, int from_cleanup);
/* new version */
void removeParent	(Client *client, int mapAgain);

void redrawParent	(Client *client);
void sendExitClient	(Client *client);

void moveClient		(Client *client);
void resizeClient	(Client *client);

/* errorHandler.c */
#ifdef DEBUG
void err(char *fmt, ...);
void showEvents(XEvent e);
void dumpClients();
#endif

#ifdef TRACE
void trace(int level, char *fmt, ...);
#endif

int debug_getWmState(Client *client);
int xErrorHandler(Display *display, XErrorEvent *event);
int cleanUpErrorHandler(Display *display, XErrorEvent *event);
int expectedXErrorHandler(Display *display, XErrorEvent *event);

/* gnome.c */
#ifdef GNOME
void initGnomeCompliance();
void toggleClientSticky	(Client *client); 
void moveClientToDesktop(Client *client, int newDesktop); 
Client *getBoundingClient (int layer, int top);
#endif

#ifdef LAYERS
void setLayer(Client *client, int newLayer); 
Client *getLayerClient(int givenLayer, int topClient);
void adjustLayer (Client *client,int stackMode);
#endif

long getValuedHint(Window givenWin, Atom givenAtom); 
void setValuedHint(Window givenWin, Atom givenAtom, long value); 
#ifdef GNOME
void setHint(Window givenWin, Atom givenAtom, long value); 
void toggleHint(Window givenWin, Atom givenAtom, long value); 
void deleteHint(Window givenWin, Atom givenAtom, long value);
#endif

/* eventHandler.c */
void swmQuit(int signalNr);
void mapRequestHandler(XMapRequestEvent *event);
void unmapEventHandler(XUnmapEvent *event);
void clientMessageHandler(XClientMessageEvent *event);
#ifdef LOWCOLOR
void colormapChangeHandler(XColormapEvent *event);
#endif
void propertyChangeHandler(XPropertyEvent *event);
void enterEventHandler(XCrossingEvent *event);
void exposeEventHandler(XExposeEvent *event);

#ifndef MINIMAL
void reparentEventHandler(XReparentEvent *event);
#endif

#ifdef KEYS
void keyEventHandler (XKeyEvent *event);
#endif
void buttonPressedEventHandler(XButtonEvent *event);
void buttonReleaseEventHandler(XButtonEvent *event);
void mouseMotionEventHandler(XMotionEvent *event);
void swmEventLoop();

/* init.c */
void scanCurrentWindows();
void initSWM();

#ifdef KEYS
void grabKeys(); 
#endif

#ifdef PIXMAPS
void readPixmap(char *fileName, pixmapStruct *pm);
void initPixmaps();
void releasePixmaps();
#endif


#ifdef MAXIMIZE
void maximizeClient	(Client *client);
void unmaximizeClient	(Client *client);
#endif

