/***************************************************************************
                         swm.c  -  description
                         ---------------------
    begin                : Wed May 22 10:12:15 CEST 2001
    copyright            : (C) 2000-2002 by Robert Sperling
    email                : sperling@small-window-manager.de
    version              : v1.3.4
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *   description: this file includes the main part of swm                  *
 ***************************************************************************/

#include "swm.h"
#include "errorHandler.c"

#include "gnome.c"
#include "tools.c"
#include "eventHandler.c"
#include "client.c"
#include "init.c"

/***************************************************************************
 *   Main - Methode                                                        *
 ***************************************************************************/

int main(int argc, char *argv[])
{ 
#ifndef MINIMAL
  int counter;
  
  for (counter = 1; counter < argc; counter++) 
  { if (strcmp(argv[counter], "-display")==0 && counter+1<argc)
    { displayOption = argv[++counter]; 
    }
    else if (strcmp(argv[counter], "-version")==0)
    {
#ifdef STD_IO    
      fprintf(stdout,"sWM version: %s, (c) 2000-2002 by Robert Sperling\n",SWMVERSION); 
      fprintf(stdout,"Distributed under the terms of the GPL.\n");
#endif
      exit(0);
    }
    else 
    {     
#ifdef STD_IO    
      fprintf(stderr,"usage: swm [-display display]\n"); 
#endif
      exit(2);
    }// end else 
  }// end for
#endif // NOT MINIMAL
 
  initSWM();

#ifdef GNOME  
  initGnomeCompliance();
#endif  

  scanCurrentWindows();
  //XSynchronize(display,false);
  swmEventLoop();   

  swmQuitNicely();
  exit(0); 
}// end main

/***************************************************************************/

void swmQuitNicely()
{ Client *client;
  unsigned int count, maxCount;
  Window w1,w2, *windowList=NULL;

#ifdef TRACE
  trace (1,"swmQuitNicely");
#endif
#ifdef PIXMAPS
  releasePixmaps();
#endif

  XQueryTree (display, rootWindow, &w1, &w2, &windowList, &maxCount);

  for (count = 0; count < maxCount; count++)
  { client = getClient(windowList[count], anyWindow);
    if (client) 
    { removeParent(client, true); // map windows again
    }
  }
  if (windowList) XFree (windowList);
  
#ifdef FONTS  
  XFreeFont(display,swmFont);
#endif  
#ifdef DEBUG
  err("cleanup succesful, terminating swm");
#endif  
  exit(0);
}// end swmQuitNicely 

/***************************************************************************/
/***************************************************************************/
