/***************************************************************************
                           init.c  -  description
                           ----------------------
    begin                : Wed May 22 10:12:15 CEST 2001
    copyright            : (C) 2000-2002 by Robert Sperling
    email                : sperling@small-window-manager.de
    version              : v1.3.4
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


/***************************************************************************
 * description: this file contains everything to initialize swm            *
 ***************************************************************************/

#ifndef PIXMAPDIR
#define PIXMAPDIR "/usr/share/swm"
#endif

/***************************************************************************/

/* scanCurrentWindows
   puts all pre swm windows into its database

   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: got invalid windows?!?! ignoring them
   v1.3.0-pre4: no change
   v1.3.0-pre5: added grabServer
*/

void scanCurrentWindows()
{
  unsigned int counter, numberOfWindows;
  Window dw1, dw2, *windowList;
  XWindowAttributes attr;
#ifdef TRACE
  trace(1,"scanCurrentWindows");
#endif
#ifdef CENTERNEW
  scanWindows=true;
#endif
  
#ifdef DEBUGPARANOID
  err("querying x-window tree");
#endif

  // Needed to ensure that no window dies before we are ready
  XGrabServer (display);
  clientCounter=0;
  XQueryTree(display, rootWindow, &dw1, &dw2, &windowList, &numberOfWindows);
  
  for (counter = 0; counter < numberOfWindows; counter++) 
  { XGetWindowAttributes(display, windowList[counter], &attr);
    if (windowList[counter])
     if (!attr.override_redirect && attr.map_state == IsViewable)
     { createNewClient(windowList[counter]);
     }
  }// end for
  
#ifdef DEBUGPARANOID
  err("Xfreeing memory in scanCurrentWindows");
#endif
  if (windowList) XFree(windowList);
  
#ifdef DEBUG
 dumpClients();
#endif

  XUngrabServer (display);

#ifdef CENTERNEW
  scanWindows=false;
#endif

#ifdef TRACE
  trace(-1,"scanCurrentWindows");
#endif
}// end scanCurrentWindows 

/***************************************************************************/

/* initSWM
   does exactly what it is called like

   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: changed font errors to fprintf
   v1.3.0-pre4: removes font stuff from where it is not needed
*/
   
void initSWM()
{ XGCValues 		gv;
  XSetWindowAttributes 	attr;
  XColor 		dummy;

#ifdef TRACE
  trace(1,"initSWM");
#endif

#ifdef DEBUG
  err("defines:");
#ifdef LAYERS
  err ("LAYERS"); 
#endif
#ifdef GNOME
  err ("GNOME"); 
#endif
#ifdef NOICON
  err ("NOICON"); 
#endif
#ifdef KEYS
  err ("KEYS"); 
#endif
#ifdef SHADE
  err ("SHADE"); 
#endif
#ifdef MAXIMIZE
  err ("MAXIMIZE"); 
#endif
#ifdef FONTS
  err ("FONTS"); 
#endif
#ifdef MWM
  err ("MWM"); 
#endif
#ifdef DRAWTITLE
  err ("DRAWTITLE"); 
#endif
#ifdef SHADEICONS
  err ("SHADEICONS"); 
#endif
#ifdef CENTERNEW
  err ("CENTERNEW"); 
#endif
#ifdef FOCUSNEW
  err ("FOCUSNEW"); 
#endif
#ifdef PIXMAPS
  err ("PIXMAPS"); 
#endif
#ifdef NORESIZEWARP
  err ("NORESIZEWARP"); 
#endif
#ifdef FAST
  err ("FAST"); 
#endif
#ifdef CURSORS
  err ("CURSORS"); 
#endif
#ifdef SIGNALS
  err ("SIGNALS"); 
#endif
#ifdef LOWCOLOR
  err ("LOWCOLOR"); 
#endif
#ifdef PDA
  err ("PDA"); 
#endif
#ifdef MAXRESTRICT
  err ("MAXRESTRICT"); 
#endif
#ifdef RESTRICTAUTORESIZE
  err ("RESTRICTAUTORESIZE"); 
#endif
#ifdef STD_IO
  err ("STD_IO"); 
#endif
#ifdef SHOWLAYER
  err ("SHOWLAYER"); 
#endif
#endif

#ifdef DEBUGPARANOID
  err("setting signals & error handler");
#endif

  XSetErrorHandler(xErrorHandler);

#ifdef SIGNALS
  signal(SIGTERM, signalHandler);
  signal(SIGINT,  signalHandler);
  signal(SIGHUP,  signalHandler);
#endif

#ifdef DEBUGPARANOID
  err("opening display");
#endif

  // opens display given in args 
  display = XOpenDisplay(displayOption); 

  if (!display) 
  { 
#ifdef STD_IO  
    fprintf(stdout,"swm: cannot open display %s, giving up\n", displayOption);
#endif
    exit(1);
  }// end if no display 

#ifdef DEBUGPARANOID
  err("getting screen");
#endif

  screen = DefaultScreen(display);

#ifdef DEBUGPARANOID
  err("getting rootwin");
#endif

  rootWindow = RootWindow(display, screen);

#ifdef MAXIMIZE  
  xmax = DisplayWidth (display, screen);
  ymax = DisplayHeight(display, screen);
#else
#ifdef CENTERNEW
  xmax = DisplayWidth (display, screen);
  ymax = DisplayHeight(display, screen);
#endif
#endif

  
#ifdef DEBUGPARANOID
  err("allocating colors");
#endif

  // colors used by SWM itself 
#ifndef MINIMAL
  XAllocNamedColor(display, DefaultColormap(display, screen), 
                   givenFG, &foregroundColor, &dummy);
#endif		   
  XAllocNamedColor(display, DefaultColormap(display, screen), 
                   givenBG, &backgroundColor, &dummy);
  XAllocNamedColor(display, DefaultColormap(display, screen), 
                   givenBC, &borderColor, &dummy);

#ifdef FONTS
#ifdef DEBUGPARANOID
  err("getting font");
#endif
  fontAvailable = true;
  swmFont = XLoadQueryFont(display, givenFont);

  if (swmFont==(XFontStruct *) NULL)
  { /* the given Font */
#ifdef STD_IO
    fprintf(stderr,"sorry, can't load font %s\n", givenFont);
#endif

    swmFont = XLoadQueryFont(display, fallbackFont);
    if (swmFont==(XFontStruct *) NULL)
    { /* fallback font not available */
#ifdef STD_IO
      fprintf(stderr,"sorry, can't even load font %s\n",fallbackFont);
#endif    
      swmFont = XLoadQueryFont(display, "fixed");
      if (swmFont==(XFontStruct *) NULL)
      { /* even fixed font not available */
#ifdef STD_IO
        fprintf(stderr,"sorry, can't even load font fixed, disabling fonts\n");
#endif    
        fontAvailable = false;
      }// end if no fixed
    }// end loading fixed
  }// end loading fallback font
#endif // FONTS

#ifdef CURSORS
#ifdef DEBUGPARANOID
  err("creating cursors");
#endif

  moveCursor  	= XCreateFontCursor(display, XC_fleur);
  resizeCursor 	= XCreateFontCursor(display, XC_plus);
  bodyCursor    = XCreateFontCursor(display, BODYCURSOR);
  windowCursor  = XCreateFontCursor(display, WINDOWCURSOR);
  // XC_X_cursor
#endif

  gv.function  	= GXcopy;
#ifndef MINIMAL
  gv.foreground	= foregroundColor.pixel;
#else
  gv.foreground	= borderColor.pixel;
#endif  
#ifdef FONTS
  gv.font 	= swmFont->fid;

  stringGC 	= XCreateGC (display, rootWindow, 
                             GCFunction | GCForeground | GCFont, &gv);
#endif

  gv.foreground = borderColor.pixel;
  gv.line_width = 2;
  
  borderGC 	= XCreateGC (display, rootWindow, 
                             GCFunction | GCForeground | GCLineWidth, &gv);

  gv.function 	= GXinvert;
  gv.foreground = borderColor.pixel;

  gv.subwindow_mode = IncludeInferiors;

#ifdef FONTS
  invertGC 	= XCreateGC (display, rootWindow, 
  		             GCFunction | GCSubwindowMode | 
			     GCLineWidth | GCFont | GCForeground, &gv);
#else

//#ifdef FAST
  invertGC 	= XCreateGC (display, rootWindow, 
  		             GCFunction | GCSubwindowMode | 
			     GCLineWidth | GCForeground, &gv);
//#endif // FAST 

#endif // else FONTS

#ifdef LOWCOLOR
  attr.event_mask = ExposureMask | ChildMask | ColormapChangeMask | 
                    ButtonMask | PropertyChangeMask;
#else
  attr.event_mask = ExposureMask | ChildMask | ButtonMask | 
                    PropertyChangeMask;
#endif

#ifdef DEBUGPARANOID
  err("changing windowsAttributes");
#endif

  XChangeWindowAttributes(display, rootWindow, CWEventMask, &attr);

  xa_wm_state        = XInternAtom(display, "WM_STATE", False);
#ifdef MWM
  xa_mwm_wm_hints    = XInternAtom(display, "_MOTIF_WM_HINTS", False);
#endif
  xa_wm_change_state = XInternAtom(display, "WM_CHANGE_STATE", False);
  xa_wm_protos       = XInternAtom(display, "WM_PROTOCOLS", False);
  xa_wm_delete       = XInternAtom(display, "WM_DELETE_WINDOW", False);

#ifdef LOWCOLOR
  xa_wm_cmapwins     = XInternAtom(display, "WM_COLORMAP_WINDOWS", False);
#endif

#ifdef LAYERS
  xa_windowLayer     = XInternAtom(display, "_WIN_LAYER", False);
#endif

#ifdef KEYS
 grabKeys();
#endif

#ifdef PIXMAPS
 initPixmaps();
#endif
 
#ifdef TRACE
  trace(-1,"initSWM");
#endif

}// end initSWM 

/**************************************************************************/

/* grabKeys
   grabs keys only to root window
 
   v1.2.0:      initial release
   v1.3.0-pre1: no changes
   v1.3.0-pre2: no changes
   v1.3.0-pre3: no changes
*/

#ifdef KEYS
void grabKeys() 
{
#ifdef TRACE 
  trace(1,"grabKeys");
#endif

  XGrabKey(display,XKeysymToKeycode(display,XStringToKeysym(CYCLEKEY)),
           Mod1Mask,rootWindow,True,GrabModeAsync,GrabModeAsync);

#ifdef VDESKTOPS
#ifdef DEBUGPARANOID
  err("grabbing vDesktop keys");
#endif  
  XGrabKey(display,XKeysymToKeycode(display,XStringToKeysym(CYCLEKEY)),
           ControlMask,rootWindow,True,GrabModeAsync,GrabModeAsync);
#endif

  XGrabKey(display,XKeysymToKeycode(display,XStringToKeysym(CLOSEKEY)),
           Mod1Mask,rootWindow,True,GrabModeAsync,GrabModeAsync);

#ifdef KEYRAISE
  XGrabKey(display,XKeysymToKeycode(display,XStringToKeysym(RAISEKEY)),
           Mod1Mask,rootWindow,True,GrabModeAsync,GrabModeAsync);
#endif

#ifdef LAYERS
  XGrabKey(display,XKeysymToKeycode(display,XStringToKeysym(LAYERUP)),
           Mod1Mask,rootWindow,True,GrabModeAsync,GrabModeAsync);
  XGrabKey(display,XKeysymToKeycode(display,XStringToKeysym(LAYERDOWN)),
           Mod1Mask,rootWindow,True,GrabModeAsync,GrabModeAsync);
#endif

#ifdef MWM  
  XGrabKey(display,XKeysymToKeycode(display,XStringToKeysym(FRAMEKEY)),
           Mod1Mask,rootWindow,True,GrabModeAsync,GrabModeAsync);
#endif // MWM

#ifdef DEBUG    
  XGrabKey(display,XKeysymToKeycode(display,XStringToKeysym(DEBUGKEY)),
           Mod1Mask,rootWindow,True,GrabModeAsync,GrabModeAsync);
#endif // DEBUG

#ifdef TRACE 
  trace(-1,"grabKeys");
#endif

}// end grabKeys
#endif

/**************************************************************************/

/* readPixmap
   loads a pixmap from a file

   v1.3.0-pre2: initial release
   v1.3.0-pre3: no change
 */ 
#ifdef PIXMAPS
void readPixmap(char *fileName, pixmapStruct *pm) 
{ XpmAttributes attr; 
  int		val;
 
#ifdef TRACE
  trace(1,"readPixmap"); 
#endif 
 
  attr.valuemask=XpmSize|XpmColorSymbols; 
  attr.colorsymbols=NULL; 
  attr.numsymbols=0; 
 
  // Read pixmap and get size 
  if((val=XpmReadFileToPixmap(display,rootWindow,fileName, 
                              &(pm->pixmap),&(pm->mask), &attr))==XpmSuccess) 
  { pm->width=attr.width; 
    pm->height=attr.height; 
#ifdef DEBUGPARANOID
    err("pixmap read");
#endif    
  }
  else
  { if(val == XpmOpenFailed)                                                  
    {
#ifdef STD_IO
     fprintf(stderr, "XPM: Couldn't open pixmap at: %s\n",fileName);
#endif
    }     
    else if(val == XpmFileInvalid)                                            
#ifdef STD_IO
     fprintf(stderr, "XPM: Invalid pixmap format\n");
#endif     
    else if(val == XpmColorError)                              
#ifdef STD_IO
     fprintf(stderr, "XPM: Invalid color information in file\n");               
#endif
    else if(val == XpmNoMemory)                                               
#ifdef STD_IO
     fprintf(stderr, "XPM: Could not allocate memory\n");
#endif     
    else if(val == XpmColorFailed)                                            
#ifdef STD_IO
     fprintf(stderr, "XPM: could not allocate colors\n");
#endif     
    exit(1);                                                                  
  }// end else if XpmSuccess 
#ifdef TRACE
  trace(-1,"readPixmap");
#endif
}// readPixmap 

/**************************************************************************/

/* initPixmaps
   loads all required pixmap files

   v1.3.0-pre2: initial release
   v1.3.0-pre3: no change
   v1.3.1:      now pixmapdir and theme can be customized
*/
 
void initPixmaps()
{ 
#ifdef TRACE 
  trace(1,"initPixmaps");
#endif

 readPixmap(PIXMAPDIR"/pixmaps/background.xpm", &backgroundPix); 
 readPixmap(PIXMAPDIR"/pixmaps/closebox.xpm", &closeBoxPix); 
 readPixmap(PIXMAPDIR"/pixmaps/maxbox.xpm", &maxBoxPix); 
 readPixmap(PIXMAPDIR"/pixmaps/stickybox.xpm", &stickyBoxPix); 
 readPixmap(PIXMAPDIR"/pixmaps/unstickybox.xpm", &unStickyBoxPix); 

#ifdef TRACE 
  trace(-1,"initPixmaps");
#endif
}// end initPixmap 

/**************************************************************************/

/* releasePixmaps
   frees all allocated pixmap files

   v1.3.0-pre4: initial release
*/ 
void releasePixmaps()
{ 
#ifdef TRACE 
  trace(1,"releasePixmaps");
#endif

 if (backgroundPix.pixmap)  XFreePixmap (display, backgroundPix.pixmap); 
 if (maxBoxPix.pixmap)      XFreePixmap (display, maxBoxPix.pixmap); 
 if (stickyBoxPix.pixmap)   XFreePixmap (display, stickyBoxPix.pixmap); 
 if (unStickyBoxPix.pixmap) XFreePixmap (display, unStickyBoxPix.pixmap); 
 if (closeBoxPix.pixmap)    XFreePixmap (display, closeBoxPix.pixmap); 

#ifdef TRACE 
  trace(-1,"releasePixmaps");
#endif
}// end releasePixmaps 
#endif // PIXMAP 
/**************************************************************************/
