/***************************************************************************
                           gnome.c  -  description
                           -----------------------
    begin                : Wed May 22 10:12:15 CEST 2001
    copyright            : (C) 2000-2002 by Robert Sperling
    email                : sperling@small-window-manager.de
    version              : v1.3.4
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         * 
 ***************************************************************************/

#ifdef GNOME
// Window used to make swm gnome compliant
Window			   swmWindow;

Atom			   xa_windowHints;
Atom			   xa_windowState;
Atom 			   xa_windowClientList;
Atom 			   xa_windowProtocols;
Atom			   xa_windowDeskButtonProxy;
Atom 			   xa_wm_desktop;
Atom			   xa_wm_maxDesktops;
Atom			   xa_AtomList[20];
Atom			   xa_windowSupportingWmCheck;
Atom			   xa_windowProtocols;

/****************************************************************************/

/* initGnomeCompliance
   initializes all nessesary atoms and the gnome required window

   v1.3.0-pre1: initial release
   v1.3.0-pre2: fixed trace at the end
   v1.3.0-pre3: no change
*/
void initGnomeCompliance()
{ int count=0;
  int maxDesktops = NUMBEROFDESKTOPS;

#ifdef TRACE
  trace (1,"initGnomeCompliance");
#endif
  
  currentDesktop=0;
  xa_windowState	    = XInternAtom(display, "_WIN_STATE", False);
  xa_AtomList[count++]	    = xa_windowState;
  xa_windowHints	    = XInternAtom(display, "_WIN_HINTS", False);
  xa_AtomList[count++]	    = xa_windowHints;
  xa_windowClientList	    = XInternAtom(display, "_WIN_CLIENT_LIST", False);
  xa_AtomList[count++]	    = xa_windowClientList;
  xa_windowDeskButtonProxy  = XInternAtom(display, "_WIN_DESKTOP_BUTTON_PROXY", False);
  xa_AtomList[count++]	    = xa_windowDeskButtonProxy;
  xa_wm_desktop		    = XInternAtom(display, "_WIN_WORKSPACE", False);
  xa_AtomList[count++]	    = xa_wm_desktop;
  xa_wm_maxDesktops	    = XInternAtom(display, "_WIN_WORKSPACE_COUNT", False);
  xa_AtomList[count++]	    = xa_wm_maxDesktops;

#ifdef LAYERS
  // Tell all clients that we support layers
  xa_AtomList[count++]	    = xa_windowLayer;
#endif

  // Create GNOME required window 
  swmWindow		    = XCreateSimpleWindow(display, rootWindow,
                                                  -200, -200, 5, 5, 0, 0, 0);
  
  // Set up GNOME properties 
  xa_windowSupportingWmCheck = XInternAtom(display, "_WIN_SUPPORTING_WM_CHECK", 
                                           False);

  XChangeProperty(display, swmWindow, xa_windowSupportingWmCheck, XA_CARDINAL, 
                  32, PropModeReplace, (unsigned char*) &swmWindow, 1);
  XChangeProperty(display, rootWindow, xa_windowSupportingWmCheck, XA_CARDINAL,
                  32, PropModeReplace, (unsigned char*) &swmWindow, 1);

  XChangeProperty(display, swmWindow, xa_windowDeskButtonProxy, XA_CARDINAL, 
                  32, PropModeReplace, (unsigned char*) &swmWindow, 1);
  XChangeProperty(display, rootWindow, xa_windowDeskButtonProxy, XA_CARDINAL, 
                  32, PropModeReplace, (unsigned char*) &swmWindow, 1);
  xa_windowProtocols	    = XInternAtom(display, "_WIN_PROTOCOLS", False);
  XChangeProperty(display, rootWindow, xa_windowProtocols, XA_ATOM, 32, 
                  PropModeReplace, (unsigned char*) xa_AtomList, count);
  XChangeProperty(display, rootWindow, xa_wm_maxDesktops, XA_CARDINAL, 32, 
                  PropModeReplace, (unsigned char *)&maxDesktops, 1);
  XChangeProperty(display, rootWindow, xa_wm_desktop, XA_CARDINAL, 32, 
                  PropModeReplace, (unsigned char *)&currentDesktop, 1);

  XSelectInput(display,rootWindow, SubstructureNotifyMask | 
                                   SubstructureRedirectMask |
				   ButtonPressMask |
				   ButtonReleaseMask |
				   FocusChangeMask |
				   PropertyChangeMask);
#ifdef TRACE
  trace (-1,"initGnomeCompliance");
#endif

}// end initGnomeCompliance


/****************************************************************************/

/* changeDesktop
   switches to another Desktop keeping all sticky windows

   v1.3.0-pre1: initial release   
*/

void changeDesktop (int newDesktop)
{ Client *client;

#ifdef TRACE
  trace(1,"changeDesktop");
#endif

  if (newDesktop==currentDesktop || 
      newDesktop>=NUMBEROFDESKTOPS || 
      newDesktop<0) return;

#ifdef DEBUGPARANOID
  err("changing from desktop %d to %d\n", currentDesktop+1, newDesktop+1);
#endif

  // Tell GNOME the new desktop
  setValuedHint(rootWindow, xa_wm_desktop, newDesktop);

  client=headClient;
  while(client)
  { if (client->sticky)
    { setValuedHint(client->window, xa_wm_desktop, newDesktop); 
    }
    else
    { if(getValuedHint(client->window,xa_windowState)!=IconicState)
      { if (client->desktop==newDesktop)
        { unhideClient(client);
        }//endif client on NEW desktop
        else
        { hideClient(client);
        }// end if client not on NEW desktop
      }// end if client is shown 
    }// end if client is not sticky 
    client=client->next;
  }// while client 
  currentDesktop=newDesktop;
#ifdef TRACE
  trace(-1,"changeDesktop");
#endif

}// end changeDesktop 

/****************************************************************************/

/* updateClientList 
   updates client list of gnome
   v1.3.0-pre1: initial release
   v1.3.0-pre2: changed error message to fprintf, err will now be used for 
                debuging only
   v1.3.0-pre3: no change
   v1.3.0-pre4: no change
   
*/ 
void updateClientList() 
{ 
  Client *client; 
  CARD32 *windowList; 
  long counter; 
 
#ifdef TRACE 
  trace(1,"updateClientList"); 
#endif 

#ifdef DEBUG
  err("got clients: %d",clientCounter);
  dumpClients(); 
  XSync(display,false);
#endif  

  if ((windowList=malloc(sizeof(CARD32)*clientCounter))==NULL) 
  {
#ifdef STD_IO
    fprintf(stderr,"could not allocate memory");
#endif
  }     
  else
  {
#ifdef DEBUG  
    if (!headClient) err ("headClient not valid");
    else err ("headClient is valid");
#endif    
    client=headClient;
    counter=0; 

    while (client)
    { if (client->window) 
      { windowList[counter]=client->window; 
        counter++;
      }
      client=client->next;
    } 
    if (clientCounter!=counter)
    { clientCounter=counter;
#ifdef DEBUG
      err("client counter differs from known client windows");
#endif
      updateClientList();
    }
    else
    { XChangeProperty(display, rootWindow, xa_windowClientList, XA_CARDINAL, 32, 
                      PropModeReplace, (unsigned char *)windowList, clientCounter); 
    }
    if(windowList) free(windowList); 
  }// end else if no memory could be allocated

#ifdef TRACE 
  trace(-1,"updateClientList"); 
#endif 

}// end updateClientList 

/***************************************************************************/

/* moveClientToDesktop
   moves a client to another desktop and switches to it

   v1.3.0-pre1: initial release
*/ 
void moveClientToDesktop(Client *client, int newDesktop) 
{ 
#ifdef TRACE 
  trace (1,"moveClientToDesktop");
#endif 
 
  if(newDesktop!=currentDesktop)
  { 
    setValuedHint(client->window, xa_wm_desktop, newDesktop);
    
    client->desktop=newDesktop;
    changeDesktop(newDesktop);
  }// end if newDesktop <> currentDesktop 

#ifdef TRACE 
  trace (-1,"moveClientToDesktop");
#endif 
}// end moveClientToDesktop 

/***************************************************************************/

/* toggleClientSticky 
   make client follow desktop switch or not

   v1.3.0-pre1: initial release
   v1.3.0-pre2: fixed unsticky, client is now left on current desktop
   v1.3.0-pre3: updated pixmap support
*/ 
void toggleClientSticky(Client *client) 
{ 
#ifdef TRACE
  trace (1,"toggleClientSticky"); 
#endif 

  toggleHint(client->window, xa_windowState, WIN_STATE_STICKY); 
  
  if (client->sticky) 
  { client->sticky=false;
    client->desktop=currentDesktop;

#ifdef PIXMAPS      
        // change sticky-button to unsticky
        XSetWindowBackgroundPixmap (display, client->stickybox,
	                            unStickyBoxPix.pixmap);
#endif	
  }    
  else
  {
     client->sticky=true;

#ifdef PIXMAPS      
        // change sticky-button to sticky again
        XSetWindowBackgroundPixmap (display, client->stickybox,
	                            stickyBoxPix.pixmap);
#endif	
  }/* end else */
  redrawParent(client);
  
#ifdef TRACE
  trace (-1,"toggleClientSticky"); 
#endif 
}/* end toggleClientSticky */ 

/***************************************************************************/

/* raiseNextClient
   raises the next client on local desktop

   v1.3.0-pre3: initial release
   v1.3.0-pre4: fixed a bug loosing raised clients, gnome workaround for
                non-layer support
		current desktop		
*/

#ifndef NORAISE
void raiseNextClient() 
{ 
  Client *client;

#ifdef TRACE 
  trace(0,"raiseNextClient(*)"); 
#endif 

// Client *getNextClient(int keepOnDesktop, int skipFocus, int skipWinList);
 client=getNextClient(true,false,true);

//#ifdef LAYERS
//  if (!client) client=getBoundingClient(0,true);
//#else  /* LAYERS */
//  if (!client) client=headClient;
//#endif /* LAYERS */

 if (client) raiseClient (client);
}// end raiseNextClient 
#endif // NORAISE 

/***************************************************************************/

/* getNextClient
   gets the next client with some restrictions
 
   v1.3.0-pre1: no implementation
   v1.3.0-pre2: no implementation
   v1.3.0-pre3: no implementation
   v1.3.0-pre4: initial release
   v1.3.1:      fixed crash when item is last in list
   v1.3.3:	fixed little bug cycling up windows that were not on the
	        current desktop
*/ 
Client *getNextClient(int keepOnDesktop, int skipFocus, int skipWinList)
{ Client *client;
  int     finished=false;
#ifdef TRACE
  trace(1,"getNextClient");
#endif

  client = raisedClient;
  if (client && client->next) client = client->next; 
  else client=headClient;

#ifdef DEBUGPARANOID
  err("starting with %s",client->name);
#endif

  while (!finished)
  { finished=true; 

    if (client)
    {
#ifdef DEBUGPARANOID
      err("now before keepOnDesktop");
#endif
      if (keepOnDesktop && (client->desktop!=currentDesktop)) finished=false;

#ifdef DEBUGPARANOID
      err("now before skipFocus");
#endif
      if (skipFocus   && (getValuedHint(client->window,xa_windowHints)
                          & WIN_HINTS_SKIP_FOCUS)) finished=false;

#ifdef DEBUGPARANOID
      err("now before skipWinList");
#endif
      if (skipWinList && (getValuedHint(client->window,xa_windowHints)
                          &WIN_HINTS_SKIP_WINLIST)) finished=false;

//      if  case 3: if (!getValuedHint(client->window,xa_windowHints)
//                                   &WIN_HINTS_SKIP_TASKBAR) finished=true;
      if (!finished) 
      { 
        if (client->next) client=client->next;
	else client=headClient;
#ifdef DEBUGPARANOID
        err("next was %s",client->name);
#endif      
        if (client==raisedClient) 
	{ finished=true;
#ifdef DEBUG
          err("raising %s",client->name);
#endif	
	  return NULL; // not dangerous to raise a client again
	}
      }
    }// end if client  
    else 
    { client=headClient;
#ifdef DEBUGPARANOID
      err("now changing to headclient %s",client->name);
#endif	      
    }
  }// end while !finished

#ifdef TRACE
  trace(-1,"getNextClient");
#endif
  return client;
}// end getNextClient 

#endif // GNOME

/***************************************************************************
 * Layer-Support                                                           *
 ***************************************************************************/

#ifdef LAYERS
/* setLayer
   set the new layer for the client. Gnome compliance also includes layer
   support 

   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: no change
   v1.3.0-pre4: no change
   v1.3.0-pre5: for testing, now uses adjustlayer
   v1.3.1:      new Layer management via raise/lower, eliminated oldlayer
   v1.3.2:      out of range message
*/ 
void setLayer(Client *client, int newLayer) 
{
#ifdef TRACE 
  trace (1,"setLayer"); 
#endif 

#ifdef DEBUG
  if (client->name) err("setting client: %s to layer %d",client->name,newLayer);
  if (client->layer == newLayer) err("no change, not setting layer");
#endif

  if (newLayer == client->layer) return; 
  if ((newLayer<0) || (newLayer>13))  
  {
#ifdef DEBUG
    err("error: layer %d is out of range",newLayer);
#endif  
    return;
  }
  setValuedHint(client->window, xa_windowLayer, newLayer); 
  
//  if(getValuedHint(client->window,xa_wm_state)==NormalState) 
//  { wc.stack_mode=Above; 
//    XConfigureWindow(display, client->parent, CWStackMode, &wc); 
//  }  
//  if (newLayer > client->layer) adjustLayer(client,());
//  else			        lowerClient(client);
  adjustLayer(client,(newLayer>client->layer)); 


#ifdef TRACE 
  trace (-1,"setLayer"); 
#endif 

}// end setLayer 

/***************************************************************************/

/* getBoundingClient 
   returns the top most client in this layer (topClient = 1)
   or the bottom most (topClient = 0)
   
   v1.3.0-pre2: initial release
   v1.3.0-pre3: no change
   v1.3.0-pre4: eliminated getLayer (too simple)
   v1.3.0-pre5: swm is now VERY much more carefull with (maybe) destroyed
                windows and syncs before querying window list 
   v1.3.1:      a bit of fine tuning now checking getClient only if it is
                visible, now grabbing server, using client->layer instead of
		asking X, fixed very stupid bug: break has to be IN if clause
		in bottonLayer
   v1.3.2:	fixed a debug level problem
*/

Client *getBoundingClient(int givenLayer, int topClient)
{ Window *windowList, w1, w2; 
  int max, counter; 
  Client *client,*outer=NULL; 
  XWindowAttributes attr; 

#ifdef TRACE
  trace (1,"getBoundingClient");
#endif

  XGrabServer(display);
  XQueryTree(display, rootWindow, &w1, &w2, &windowList, &max); 

  for(counter=0; counter<max; counter++) 
  { 
    XGetWindowAttributes(display, windowList[counter], &attr);
    if (attr.map_state == IsViewable)
    { 
#ifdef DEBUG  
#ifndef DEBUGPARANOID  
      nodebug++;
#endif    
#endif
      client=getClient(windowList[counter],parentWindow); 
#ifdef DEBUG  
#ifndef DEBUGPARANOID  
      nodebug--;
#endif
#endif    
      if(client) 
      { if (topClient) 
        { if(client->layer<=givenLayer) outer=client; 
          else break; 
        }
        else
        { if(client->layer>=givenLayer) 
	  { outer=client; 
	    break;
	  } 
        }// end else if top
      }// end if client  
    }// end if isviewable 
  }// end for 
  if(windowList) XFree(windowList); 

  XUngrabServer(display);

#ifdef DEBUG
  if (!outer) err("returning NULL");
#endif
 
#ifdef TRACE
  trace (-1,"getBoundingClient");
#endif

 return outer; 

}// end getBoundingClient 

/***************************************************************************/

/* adjustLayer
   updated window stacking mode

   v1.3.0-pre2: initial release
   v1.3.0-pre3: no change
   v1.3.0-pre4: eliminated getLayer (too simple)
   v1.3.1:      now own sibling management
*/
void adjustLayer (Client *client, int stackMode)
{ Client *sibling=NULL; 
  XWindowChanges wc;
  int clientLayer = WIN_LAYER_NORMAL;

#ifdef TRACE
  trace (1,"adjustLayer");
#endif

#ifdef DEBUGPARANOID
  if (client)
  {
#endif
    clientLayer=getValuedHint(client->window, xa_windowLayer);
#ifdef DEBUG
    err("adjusting in Layer: %d",clientLayer);
#endif
    switch(stackMode) 
    { case Above: 
      // Window wants to be raised to top of its layer 
        sibling=getBoundingClient(clientLayer,true); 
	
        // If there are no other windows in this layer, say it is the 
	// bottom most, so every new window will appear above this one 
        if(!sibling) 
        { wc.stack_mode=Below; 
#ifdef DEBUG
          err("got no sibling windows, lowering this one");
#endif
        }
        else 
        { wc.stack_mode=Above;
#ifdef DEBUG
          err("got sibling: %s for client: %s",sibling->name,client->name);
#endif	 
	}
        break; 
      case Below: 
      // Window wants to be lowered to bottom of its layer 
        sibling=getBoundingClient(clientLayer,false); 
        wc.stack_mode=Below;
        break; 
    } 

    if (sibling) 
    { if (sibling==client)
      {
#ifdef DEBUG
        err("sibling is client itself, doing nothing");
#endif      
      }
      else 
      { 
#ifdef DEBUG
        err("restacking using sibling");
#endif            
        wc.sibling=sibling->parent;
        // It is not enough to simply configure the parent. Otherwise
	// after a gnome-panel switch the next window clicked will no be rised
        XConfigureWindow(display,client->parent,CWSibling|CWStackMode,&wc);
//	wc.stack_mode=Above;
//        XConfigureWindow(display,client->window,CWStackMode,&wc);
      }
    } else
    { 
#ifdef DEBUG
        err("restacking without sibling");
#endif          
      XConfigureWindow(display,client->parent,CWStackMode,&wc);
//      wc.stack_mode=Above;
//      XConfigureWindow(display,client->window,CWStackMode,&wc);
    }
//      XConfigureWindow(display,client->window,0,&wc);

#ifdef DEBUGPARANOID
  }// end else client 
#endif

 client->layer=clientLayer;
#ifdef TRACE
  trace (-1,"adjustLayer");
#endif
}// end adjustLayer 
#endif // LAYERS 

/****************************************************************************
 * Hint-Management                                                          *
 ****************************************************************************/

/* getValuedHint
   reads a specific hint out of the list and returns its value

   v1.3.0-pre1: initial release
   v1.3.0-pre2: added layer support
   v1.3.0-pre3: added check for valid window
   v1.3.3:	more verbose now

   * even nessessary in minimal mode
*/
long getValuedHint(Window givenWin, Atom givenAtom) 
{ Atom realType; 
  int realFormat; 
  unsigned long readItems, itemsLeft; 
  long *data, value=0; 
		 
#ifdef TRACE 
  trace (0,"getValuedHint(*)"); 
#endif 

#ifdef LAYERS
  // If the Application does not set its window layers, return our normal
  if (givenAtom==xa_windowLayer) value=windowLayerNormal;
#endif

#ifdef DEBUG
  fprintf(stderr,"ATOM: %ld, Name:%s\n",givenAtom,XGetAtomName(display, givenAtom));
  if (givenWin)
  { 
#endif  

//    XSetErrorHandler(expectedXErrorHandler);
    if (XGetWindowProperty(display, givenWin, givenAtom, 0L, 1L, False, 
                           XA_CARDINAL,&realType, &realFormat, &readItems, 
  	  		   &itemsLeft,(unsigned char **)&data)==Success 
			   && readItems) 
    { value=*data; 
      XFree(data); 
    }
//    XSetErrorHandler(xErrorHandler);

#ifdef DEBUG    
  }
  else
  {
    err("window is not valid");
  }    
#endif

  return value; 
}// end getValuedHint

/****************************************************************************/

/* setValuedHint
   sets a specific hint

   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: added check for valid window

   * even in minimal mode neccesary
*/
void setValuedHint(Window givenWin, Atom givenAtom, long value) 
{ 
#ifdef TRACE
  trace(1,"setValuedHint"); 
#endif 

#ifdef DEBUG
  if (givenWin)
  { 
#endif  
    XChangeProperty(display, givenWin, givenAtom, XA_CARDINAL, 32, 
                    PropModeReplace, (unsigned char *)&value, 1); 
#ifdef DEBUG
  }
  else
  {
    err("window is not valid");
  }		    
#endif  

#ifdef TRACE
  trace(-1,"setValuedHint"); 
#endif 

}// end setValuedHint

/****************************************************************************/

#ifdef GNOME
/* setHint
   allows to set a bit in a hint value

   v1.3.0-pre1: initial release   
   v1.3.0-pre2: no change
   v1.3.0-pre3: added window check
   v1.3.3:	now being more verbose
*/

void setHint(Window givenWin, Atom givenAtom, long value) 
{ long newValue;

#ifdef TRACE
  trace(1,"setHint"); 
#endif 

#ifdef DEBUG
  if (givenWin)
  { 
#endif  
    newValue = getValuedHint (givenWin, givenAtom)|value;
  	   
#ifdef VERBOSE
    ignoreXErrors(XChangeProperty(display, givenWin, givenAtom, XA_CARDINAL, 32, 
                  PropModeReplace, (unsigned char *)&newValue, 1)); 
#else    
    XChangeProperty(display, givenWin, givenAtom, XA_CARDINAL, 32, 
                    PropModeReplace, (unsigned char *)&newValue, 1); 
#endif

#ifdef DEBUG
  }
  else
  {
    err("window is not valid");
  }		    
#endif  

#ifdef TRACE
  trace(-1,"setHint"); 
#endif 

}// end setHint

/****************************************************************************/

/* toggleHint
   allows to invert a bit in a hint

   v1.3.0-pre1: initial release   
   v1.3.0-pre2: no change
   v1.3.0-pre3: added window check
   v1.3.3:      now being more verbose
*/

void toggleHint(Window givenWin, Atom givenAtom, long value) 
{ long newValue;

#ifdef TRACE
  trace(1,"toggleHint"); 
#endif 

  if (givenWin)
  { newValue = getValuedHint (givenWin, givenAtom)^value;

#ifdef VERBOSE
    ignoreXErrors(XChangeProperty(display, givenWin, givenAtom, XA_CARDINAL, 32, 
                  PropModeReplace, (unsigned char *)&newValue, 1)); 
#else  	   
    XChangeProperty(display, givenWin, givenAtom, XA_CARDINAL, 32, 
                    PropModeReplace, (unsigned char *)&newValue, 1); 
#endif
  }
  else
  {
#ifdef DEBUG
    err("window is not valid");
#endif  
  }		    

#ifdef TRACE
  trace(-1,"toggleHint"); 
#endif 

}// end toggleHint  

/****************************************************************************/

/* deleteHint
   allows to unset a bit in a hint

   v1.3.0-pre1: initial release   
   v1.3.0-pre2: no change
   v1.3.0-pre3: updated window check
   v1.3.3:      now being more verbose
*/

void deleteHint(Window givenWin, Atom givenAtom, long value) 
{ long newValue;

#ifdef TRACE
  trace(1,"deleteHint"); 
#endif 

  if (givenWin)
  { newValue = getValuedHint (givenWin, givenAtom)&~value;
 
#ifdef VERBOSE  	   
    ignoreXErrors(XChangeProperty(display, givenWin, givenAtom, XA_CARDINAL, 32, 
                  PropModeReplace, (unsigned char *)&newValue, 1));

#else
    XChangeProperty(display, givenWin, givenAtom, XA_CARDINAL, 32, 
                    PropModeReplace, (unsigned char *)&newValue, 1);
#endif    
    
  }
  else
  {
#ifdef DEBUG
    err("window is not valid");
#endif  
  }	    

#ifdef TRACE
  trace(-1,"deleteHint"); 
#endif 

}// end deleteHint  
#endif // GNOME
/***************************************************************************/
