/***************************************************************************
                         eventHandler.c  -  description
                         ------------------------------
    begin                : Wed May 22 10:12:15 CEST 2001
    copyright            : (C) 2000-2002 by Robert Sperling
    email                : sperling@small-window-manager.de
    version              : v1.3.4
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


/***************************************************************************
 * description: this file contains functions react on events               *
 ***************************************************************************/

/* signalHandler
   reacts on signals
  
   v1.3.0-pre4: initial release
   v1.3.0-pre5: no change
*/  
#ifdef SIGNALS
void signalHandler(int signalNr)
{ swmQuitNicely(0);  
}// end signalHandler
#endif

/***************************************************************************/

/* mapRequestHandler
   reacts, when a client wants to be mapped again or if a new window was
   created
  
   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: updated for pixmaps
   v1.3.0-pre4: now showing name of affected client
   v1.3.1:      no change
*/  
void mapRequestHandler(XMapRequestEvent *event)
{ Client *client;

#ifdef TRACE
  trace (1,"mapRequestHandler"); 
#endif

// ****  DEBUG PART  **** 
#ifdef DEGUGPARANOID
  client = getClient(event->window, anyWindow);
  if (client) 
  { if (client->name) err("window: %s",client->name);
  }
#endif // DEBUGPARANOID

// **** FUNCTION PART ****
  client = getClient(event->window, childWindow);

  if (client) unhideClient(client);
  else        createNewClient(event->window);

#ifdef TRACE
  trace (-1,"mapRequestHandler"); 
#endif
}// end mapRequestHandler

/***************************************************************************/

/* unmapEventHandler
   unmaps a client or destroys it if it has been unmapped to often.
   If the client was unmapped by swm, decrement ignoreUnmap,
   if it unmapped/destroyed itself, remove the frame & clear from list
 
   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: no change
   v1.3.0-pre4: showning name of window
   v1.3.0-pre5: now handles unmap events of clients only 
*/

void unmapEventHandler(XUnmapEvent *event)
{ Client *client;

#ifdef TRACE
  trace (1,"unmapEventHandler"); 
#endif // TRACE

  XGrabServer(display);
// ****  DEBUG - PART  **** 
#ifdef DEBUGPARANOID
  client = getClient(event->window, anyWindow);
  if (client) 
  { if (client->name) err("window: %s",client->name);
    if (event->window!=client->window) 
      err("error: swm should not get this event");
  }
  else
  { err ("destroyed window belongs to no client");
  }
#endif // DEBUGPARANOID
// **** FUNCTION - PART *****
  client = getClient(event->window, childWindow);

  if (client) 
  { if (client->ignoreUnmap) client->ignoreUnmap--;
    else                     removeParent(client, false);
  }// end if client 
  
  XUngrabServer(display);
#ifdef TRACE
  trace (-1,"unmapEventHandler"); 
#endif // TRACE 
}// end unmapEventHandler 

/***************************************************************************/

/* clientMessageHandler
   handles client messages

   v1.3.0-pre1: initial release
   v1.3.0-pre2: fixed hint management
   v1.3.0-pre3: no change
   v1.3.0-pre4: updated desktop change request
   v1.3.1:      now inconify requests can be customized: NOICONS,SHADEICONS,
                and old hide behaviour
   v1.3.2:      MINIMAL mode now implies NOICONS so clientMessageHandler
                will not be called since it is of no use
*/
#ifndef MINIMAL
void clientMessageHandler(XClientMessageEvent *event)
{ Client *client;

#ifdef TRACE
  trace (1,"clientMessageHandler"); 
#endif

// ****   DEBUG - PART   ****
#ifdef DEBUGPARANOID
  client = getClient(event->window, anyWindow);
  if (client &&  client->name) err("window: %s",client->name);
#endif // DEBUGPARANOID

// **** FUNCTION - PART **** 
  client = getClient(event->window, childWindow);

  if (client)
  { 
#ifndef NOICONS  
    // I don't allow any client to iconify, it will be hidden instead
    // NEW version: toggle shaded instead   
    if (event->message_type == xa_wm_change_state &&
        event->format == 32 && event->data.l[0] == IconicState) 
    { 
#ifdef SHADEICONS
        toggleClientShaded(client);
#else
      client->ignoreUnmap++;
      hideClient(client);
#endif // SHADEICONS
    }	
#endif // NOICONS

#ifdef GNOME
#ifdef SHADE
    // client wants to toggle shade 
    if(event->message_type==xa_windowState && event->format==32 && 
       event->data.l[0]&WIN_STATE_SHADED) 
    { toggleClientShaded(client);
    } 
#endif

    // client wants to toggle sticky
    if(event->message_type==xa_windowState && event->format==32 && 
       event->data.l[0]&WIN_STATE_STICKY) 
      toggleClientSticky(client); 

    // client wants to change to another desktop 
    if(event->message_type==xa_wm_desktop && event->format==32 &&
       event->data.l[0]!=currentDesktop)
      moveClientToDesktop (client,event->data.l[0]);
#endif // GNOME    

#ifdef LAYERS 
 // client wants to change its layer 
  if(event->message_type==xa_windowLayer && event->format==32) 
    setLayer(client, event->data.l[0]); 
#endif
 }// endif client 
#ifdef GNOME
 else 
 { if (event->window==rootWindow)
   { if (event->message_type == xa_wm_desktop && event->format==32)
       changeDesktop(event->data.l[0]);  
   }
 }// end else if client 
#endif 
 
#ifdef TRACE
  trace (-1,"clientMessageHandler"); 
#endif
}// end clientMessageHandler 
#endif // NOT MINIMAL

/***************************************************************************/

#ifdef LOWCOLOR
/* colormapChangeHandler
   keeps track of changing colormaps on focus change
  
   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: no change
   v1.3.0-pre4: no change
   v1.3.0-pre5: no change
*/

void colormapChangeHandler(XColormapEvent *event)
{ Client *client;

#ifdef TRACE
  trace (1,"colormapChangeHandler");
#endif

// DEBUG - PART 
#ifdef DEBUGPARANOID
  client = getClient(event->window, anyWindow);
  if (client) 
  { if (client->name) err("window: %s",client->name);
  }
#endif /* DEBUGPARANOID */

  client = getClient(event->window, childWindow);

  if (client)
   if (event->new) 
   { client->cmap = event->colormap;
     XInstallColormap(display, client->cmap);
   }// end if new colormap 

#ifdef TRACE
  trace(-1,"colormapChangeHandler");
#endif

}// end colormapChangeHandler 
#endif // LOWCOLOR 

/***************************************************************************/

/* propertyChangeHandler
   handles property change notifies
   
   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: removed unnessesary XClearWindow 
   v1.3.0-pre4: no change
   v1.3.1:	added handler for desktop & layers
   v1.3.3:	now caching xa_windowHints
   
   TESTING: when client gets wm_normal_hints, should size be adjusted?
*/

void propertyChangeHandler(XPropertyEvent *event)
{ Client *client;
#ifdef LAYERS
  int oldLayer;
#endif  
  long dummy;

#ifdef TRACE
  trace (1,"propertyChangeHandler"); 
#endif

// DEBUG - PART 
#ifdef DEBUGPARANOID
  client = getClient(event->window, anyWindow);
  if (client) 
  { if (client->name) err("window: %s",client->name);
  }
#endif // DEBUGPARANOID 

  client = getClient(event->window, childWindow);

  if (client) 
  { 
      if (event->atom == xa_windowHints)
      { client->hints=getValuedHint(client->window,xa_windowHints);
      }

#ifdef FONTS    
#ifdef DRAWTITLE

      if (event->atom == XA_WM_NAME)
      {
#ifdef DEBUGPARANOID
        err("Xfreeing client->name in propertyChangeHandler");
#endif
        if (client->name) XFree(client->name);

	ignoreXErrors(XFetchName(display, client->window, &client->name));

	redrawParent(client);
      }// endif XA_WM_NAME
#endif // DRAWTITLE
#endif // FONTS 
      if (event->atom == XA_WM_NORMAL_HINTS)
      { XGetWMNormalHints(display, client->window, client->size, &dummy);
        updateClient(client,UPDATESIZE);
#ifdef DEBUGPARANOID
        err ("got XA_WM_NORMAL_HINTS"); 
#endif
      }// endif XA_WM_NORMAL_HINTS 

#ifdef LAYERS	
      if (event->atom == xa_windowLayer)
      {
        oldLayer=client->layer;
        client->layer=getValuedHint(client->window,xa_windowLayer);

#ifdef DEBUG
        err ("adjusting Layer to: %d",client->layer); 
#endif
// TESTING
        adjustLayer(client,(client->layer>oldLayer));
//        if ( client->layer > oldLayer) raiseClient(client);
//        else 			       lowerClient(client);
      }
#endif		

#ifdef GNOME	
      if (event->atom == xa_wm_desktop)
      {
#ifdef DEBUGPARANOID
        err ("adjusting desktop");
#endif
        moveClientToDesktop(client,getValuedHint(client->window,xa_wm_desktop));
      }
#endif		
  }// end if client 

#ifdef TRACE
  trace (-1,"propertyChangeHandler"); 
#endif
}// end propertyChangeHandler 

/**************************************************************************/

/* enterEventHandler
   handles window enter events
   
   v1.3.0-pre1: initial release
                should other enter events be ignored?
   v1.3.0-pre2: no change
   v1.3.0-pre3: for TESTING: in gnome mode clients get no focus if they don't 
                want it
   v1.3.2:      minimal mode now checking for childWindow directly				
   v1.3.3:	now using caches version of hint
   v1.3.4:	returned to "focus window" since not all appications like it
*/
void enterEventHandler(XCrossingEvent *event)
{ Client *client;
#ifdef TRACE
  trace (1,"enterEventHandler"); 
#endif
  // we may only handle the last event  
  while(XCheckTypedEvent(display, EnterNotify, (XEvent *)event));

  XSetInputFocus(display, event->window, RevertToPointerRoot, CurrentTime);

  // childWindow is not enough if you want to select input boxes...
  client = getClient(event->window, anyWindow);
  
  if (client) 
  { 
#ifdef DEBUG
    if (client->name) err("window: %s",client->name);
    err("clients window: %x",client->window);
    err("events  window: %x",event->window);
#endif

#ifdef LOWCOLOR  
    XInstallColormap(display, client->cmap);
#endif

#ifdef GNOME
    if(client->hints & WIN_HINTS_SKIP_FOCUS) 
      return; 
#endif

// Old behaviour, causes X to raise BadMatch exceptions frequently,

    ignoreXErrors(XSetInputFocus(display, client->window, RevertToPointerRoot, CurrentTime));

//  Other behaviour, but not suitable since some buggy appications don't know
//  which of their windows should get input focus
//  XSetInputFocus(display, event->window, RevertToPointerRoot, CurrentTime);

#ifdef RAISEONCLICK
// sWM is not ready for that task, yet
//    XGrabButton (display, AnyButton, AnyModifier, client->parent, False,
//                 ButtonPressMask, GrabModeSync, GrabModeAsync, None, None);
#endif // RAISEONCLICK
  }// end if client 
  else
  {
#ifdef DEBUGPARANOID
    err("giving input focus to unknown window");
#endif  
    XSetInputFocus(display, event->window, RevertToPointerRoot, CurrentTime);
  }
  
#ifdef TRACE
  trace (-1,"enterEventHandler"); 
#endif

}// end enterEventHandler 

/***************************************************************************/

/* exposeEventHandler
   redraws windows on expose event, this redraw is simple: it will look for
   the last expose event only and redraw the entire window
   
   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: changes to speed up exposure, getClient now only called for
                the last exposeEvent
   v1.3.0-pre4: added debug
*/
void exposeEventHandler(XExposeEvent *event)
{ Client *client;

#ifdef TRACE
  trace (1,"exposeEventHandler"); 
#endif

// DEBUG - PART 
#ifdef DEBUGPARANOID
  client = getClient(event->window, anyWindow);
  if (client) 
  { if (client->name) err("window: %s",client->name);
  }
#endif // DEBUGPARANOID 

  // only look for client and redraw if it is really the last expose-event
  if (event->count==0)
  { client = getClient(event->window, parentWindow);

    if (client)
    {
#ifdef DEBUG
      if (client->name) err("redrawing window: %s",client->name);
#endif
      redrawParent(client);
    }// end if client
  }// end if event->count==0   
  
#ifdef TRACE
  trace (-1,"exposeEventHandler"); 
#endif

}// end ExposeEventHandler 

/***************************************************************************/

#ifdef VERBOSE
/* reparentEventHandler
   currently does nothing
*/
void reparentEventHandler(XReparentEvent *event)
{
#ifdef TRACE
  trace (0,"reparentEventHandler(*) (but doing nothing)"); 
#endif

}// end reparentEventHandler 
#endif // VERBOSE
/***************************************************************************/

/* destroyNotifyHandler
   tries to remove the client that was destroyed

   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: no change
   v1.3.0-pre4: added debug
   v1.3.0-pre5: now using removeParent
*/
void destroyNotifyHandler (XDestroyWindowEvent *event)
{ Client *client;
   
#ifdef TRACE
  trace(1,"destroyNotifyHandler"); 
#endif 

// DEBUG - PART 
#ifdef DEBUGPARANOID
  client = getClient(event->window, anyWindow);
  if (client) 
  { if (client->name) err("window: %s",client->name);
  }
#endif // DEBUGPARANOID 
 
  // only destroy a client if really the child window is destroyed
  client=getClient(event->window, childWindow); 
  if(client)
  { 
    removeParent (client, False); // Don't remap again
  }
#ifdef DEBUG
  else
  {
    err("ERROR: no client, seems to be destroyed already");
  }
#endif  

#ifdef TRACE
  trace(-1,"destroyNotifyHandler"); 
#endif 

}// end destroyNotifyHandler

/***************************************************************************/

/* configureRequestHandler
   handles configure requests
   
   v1.3.0-pre1: intial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: no change
   v1.3.0-pre4: no change
   v1.3.1-pre2: fixed silly else,else bug that prevents clients to move
                vertically
   v1.3.1-pre3: fixed double check for window
   v1.3.1:      fixed layer management, testing sibling if no layers
*/
   
void configureRequestHandler(XConfigureRequestEvent *event)
{ Client *client;
#ifdef LAYERS
  Client *sibling;
#endif
  XWindowChanges wc;

#ifdef TRACE
  trace (1,"configureRequestHandler"); 
#endif

  client = getClient(event->window, childWindow);

  if (client) 
  { 
#ifdef DEBUG
    if (client->name) err("window: %s",client->name);
#endif
  
#ifdef MWM
    if (client->frameState==FRAMESHOWN)
#endif // MWM

      changeGravity(client,-1);

    if (event->value_mask & CWX) 
    { client->x = event->x;
#ifdef RESTRICTAUTORESIZE
      if (client->x < 0 ) client->x=0;
      if (client->x>xmax) client->x=xmax-1;
#endif	
    }

    if (event->value_mask & CWY) 
    { client->y = event->y;
#ifdef RESTRICTAUTORESIZE
      if (client->y < 0) client->y=0;
      if (client->y>ymax) client->y=ymax-1;    
#endif
    }

    if (event->value_mask & CWWidth) 
    { client->width = event->width;
#ifdef RESTRICTAUTORESIZE
      if (client->width+client->x>xmax && (client->x<xmax)) 
        client->width=xmax-client->x;
#endif	  
    }
    
    if (event->value_mask & CWHeight) 
    { client->height = event->height;
#ifdef RESTRICTAUTORESIZE
      if (client->height+client->y>ymax && (client->y<ymax)) 
        client->height=ymax-client->y;
#endif	  
    }
    
#ifdef MWM
    if (client->frameState==FRAMESHOWN)
#endif // MWM
      changeGravity(client,1);

#ifdef ALWAYSCENTER
    client->x=xmax/2-client->width/2;
    client->y=ymax/2-client->height/2;
#endif

    if (event->value_mask & (CWX|CWY|CWWidth|CWHeight))
      updateClient(client,UPDATESIZE);

    if (event->value_mask & CWStackMode)
    { 
#ifdef DEBUG
      err("adjusting stacking order");
#endif  
      wc.stack_mode = event->detail;
#ifdef LAYERS      
      sibling       = getBoundingClient(client->layer,(wc.stack_mode==Above)); 
      if (sibling) wc.sibling = sibling->parent;
//    Testing: event->above seems to hold trash
//      else         
#else
      wc.sibling = event->above;
#endif
      if (wc.sibling)
       XConfigureWindow(display,client->parent, CWStackMode|CWSibling,&wc);
      else  
        XConfigureWindow(display,client->parent,CWStackMode,&wc);
    }// end if raised/lowered
  }// end if (client) 
  else
  { 
#ifdef DEBUG
    err("configuring unknown client / other part of window");
#endif  
    wc.x 	= event->x;
    wc.y 	= event->y;
    wc.width 	= event->width;
    wc.height 	= event->height;
    wc.sibling 	= event->above;
    wc.stack_mode = event->detail;
#ifdef MINIMAL
    XConfigureWindow(display,event->window,event->value_mask,&wc);
#else
    ignoreXErrors(XConfigureWindow(display,event->window,event->value_mask,&wc));
#endif //MINIMAL
  }
#ifdef TRACE
  trace (-1,"configureRequestHandler"); 
#endif  
}// end configureRequestHandler 

/***************************************************************************/

/* keyEventHandler
   manages all incoming key events for swm, keys are usually grabbed to the
   rootWindow   

   v1.3.0-pre1: initial release
   v1.3.0-pre2: window close: moved next-raised stuff to sendExitClient
   v1.3.0-pre3: added exact keys
   v1.3.0-pre4: changed from focusedClient to getFocusedClient
   v1.3.2:      now using keybindings
   v1.3.3:      updated to expose after layer switching,
		now using "subwindow" to determine window, if it is not
		valid, using focusedWindow
*/

#ifdef KEYS
void keyEventHandler (XKeyEvent *event)
{ Client *client;

#ifdef TRACE
  trace(1,"keyEventHandler");
#endif
  if (event->window==rootWindow) 
  {
#ifndef EXACTKEY  
    event->state=event->state&(Mod1Mask|ControlMask|ShiftMask);
#ifdef DEBUGPARANOID
    err("filtered keys");
#endif
#endif

    client=getClient(event->subwindow,anyWindow);
    if (!client) client=getFocusedClient();
#ifdef DEBUG    
    else 
      if (client->name) err("Subwindow: %s",client->name);
#endif
    
#ifndef NORAISE
#ifdef DEBUGPARANOID
    err("before Alt-Cyclekey");
#endif
// ***** Ctrl-CYCLEKEY switches to the next window ******
    if (event->keycode == XKeysymToKeycode(display, XStringToKeysym(CYCLEKEY)) 
        && event->state == ControlMask) 
    { 
#ifdef GNOME
      raiseNextClient();
#ifdef DEBUG
#ifdef DRAWTITLE
      if (raisedClient) 
      { if (raisedClient->name) err ("changed to: %s",raisedClient->name);
        client=getClient(raisedClient->window,childWindow);
#ifdef DEBUGPARANOID	
        if (client) err ("changed to (checked again): %s",client->name);      
#endif	
      } else { err ("changed to no other client"); }
#endif       
#endif

#else // GNOME 
      XCirculateSubwindowsUp(display,rootWindow);
#endif // GNOME 
    } // end if Alt-CYCLEKEY 
#endif

#ifdef GNOME
#ifdef DEBUGPARANOID
    err("before Ctrl-Cyclekey");
#endif

// ****** Alt-CYCLEKEY switches to the next desktop *********
    if (event->keycode == XKeysymToKeycode(display, XStringToKeysym(CYCLEKEY)) 
        && event->state == Mod1Mask) 
    { 
#ifdef DEBUG
      err ("changing from: %i",currentDesktop);
#endif
      if (currentDesktop>NUMBEROFDESKTOPS-2) changeDesktop(0);
      else changeDesktop (currentDesktop+1);
#ifdef DEBUG
      err ("changed to: %i",currentDesktop);
#endif
    }// end if Ctrl-CYCLEKEY
#endif

#ifdef DEBUG
#ifdef DEBUGPARANOID
    err("before Alt-DEBUGKEY");
#endif

    if (event->keycode==XKeysymToKeycode(display,XStringToKeysym(DEBUGKEY)) 
        && event->state == Mod1Mask)		
    { Window focusedWindow;
      int dummy;
      dumpClients();
#ifndef DEBUGPARANOID
      nodebug++;
#endif      
      client=getFocusedClient();
      XGetInputFocus(display,&focusedWindow, &dummy);
#ifndef DEBUGPARANOID
      nodebug--;
#endif      
      err("focused: %s (clientsWin: %#x, reallyFocusedWin: %#x)",client->name,client->window,focusedWindow);
    }// end Alt-DEBUGKEY
#endif        

#ifdef LAYERS
#ifdef DEBUGPARANOID
    err("before Alt-LayerUp");
#endif

// RAISE layer 
    if (event->keycode==XKeysymToKeycode(display,XStringToKeysym(LAYERUP))
        && event->state == Mod1Mask)
    { // now using subwindow instead of getFocusedClient
      // client=getFocusedClient();
      
      // layer=getValuedHint(client->window, xa_windowLayer);
      setLayer (client, client->layer+1);
      redrawParent(client);
    }// end Alt-LAYERUP 

#ifdef DEBUGPARANOID
    err("before Alt-LayerDown");
#endif
    if (event->keycode==XKeysymToKeycode(display,XStringToKeysym(LAYERDOWN))
        && event->state == Mod1Mask)
    { // now using subwindows instead of getFocusedClient
      // client=getFocusedClient();
      // layer=getValuedHint(client->window, xa_windowLayer);
      setLayer (client, client->layer-1);
      redrawParent(client);
    }// end Alt-LAYERDOWN     
#endif // LAYERS
										
#ifdef MWM    
#ifdef DEBUGPARANOID
    err("before Alt-FrameKey");
#endif

    if (event->keycode==XKeysymToKeycode(display,XStringToKeysym(FRAMEKEY)) 
        && event->state == Mod1Mask)		
    { // toggleFrameHidden(getFocusedClient());
      toggleFrameHidden(client);
    }// end Alt-FRAMEKEY
#endif // MWM
    	    
#ifdef DEBUGPARANOID
    err("before Alt-CloseKey");
#endif
    if (event->keycode==XKeysymToKeycode(display,XStringToKeysym(CLOSEKEY)) 
        && event->state == Mod1Mask)		
    { 
#ifdef DEBUG
#ifdef DRAWTITLE
      err ("got Alt+",CLOSEKEY,", closing window: %s",client->name); 
      err ("focused is window: %s",getFocusedClient()->name); 
#endif
#endif
//      sendExitClient(getFocusedClient());
      sendExitClient(client);
    }// end if Alt-CLOSEKEY          

#ifdef KEYRAISE
#ifdef DEBUGPARANOID
    err("before Alt-Raisekey");
#endif
    if (event->keycode==XKeysymToKeycode(display,XStringToKeysym(RAISEKEY)) 
        && event->state == Mod1Mask)		
    { 
#ifdef DEBUG
#ifdef DRAWTITLE
      err ("got Alt+",RAISEKEY,", raising window: %s",client->name); 
      err ("focused is window: %s",getFocusedClient()->name); 
#endif
#endif
//      raiseClient(getFocusedClient());
      raiseClient(client);
      
    }// end if Alt-RAISEKEY 
#endif // KEYRAISE
  }// end if rootWindow 
  else
  { 
#ifdef DEBUG
      err ("*** got a keyboard-event?!? swm should not receive it! ***");  
#endif  
  }// end if event->window

#ifdef TRACE
  trace(-1,"keyEventHandler");
#endif
}// end keyEventHandler
#endif

/*************************************************************************/

/* buttonPressedEventHandler
   handles button presses

   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: fixed a bug preventing to change to the first desktop 
   v1.3.0-pre4: updated some "click to raise" functions (beginning)
   v1.3.1:      eliminated getClickedItem in MINIMAL mode
   V1.3.2:      eliminated backmove in MINIMAL mode
*/
void buttonPressedEventHandler(XButtonEvent *event)
{ Client *client; 
  int clickedItem;

#ifdef TRACE
  trace(1,"buttonPressedEventHandler");
#endif

 // if X has been busy, just take the last action to avoid unexpected behaviour 
 while (XCheckTypedEvent(display,ButtonPress,(XEvent *) event));

#ifdef MOUSEFOCUS
 XSetInputFocus(display,event->window, RevertToPointerRoot, CurrentTime);
#endif

 if (event->window == rootWindow) 
 {
#ifndef MINIMAL
   switch (event->button) 
   { case Button1: system(CONFDIR "/.swm/button1" "&"); break;
     case Button2: system(CONFDIR "/.swm/button2" "&"); break;
     case Button3: system(CONFDIR "/.swm/button3" "&"); break; 
   }	
#endif // MINIMAL 
 } 
 else 
 { client = getClient(event->window, anyWindow);
   if (client) 
   {

#ifdef DEBUG
     if (client->name) err("window: %s",client->name);
#endif

#ifdef RAISEONCLICK
     if (event->subwindow == client->window)
     {
       if (client!=raisedClient) 
       { raiseClient (client);  
        XUngrabPointer (display, CurrentTime);
        XSendEvent(display, swmWindow, False, SubstructureNotifyMask, 
                   (XEvent *) event);
       }
       XAllowEvents (display, ReplayPointer, CurrentTime);
       XAllowEvents (display, SyncPointer, CurrentTime);
     }
     else
     {
#endif // RAISEONCLICK 

// 0 should be normal titlebar, 1 closebox, 2 maxbox, 3 sticky, 4 windowbody
#ifdef PIXMAPS
     clickedItem=getClickedItem(client,event->window,event->y);
#else // PIXMAPS 
#ifdef MINIMAL
     clickedItem=((client->width-event->x)/TITLEBARHEIGHT)+1;
     if (clickedItem!=CLOSEBOX) clickedItem=TITLEBAR;
#else
     clickedItem=getClickedItem(client,event->x,event->y);
#endif // endif MINIMAL
#endif // PIXMAPS 
	     
#ifdef DEBUGPARANOID
       err("clicked item: %#x",clickedItem);
#endif
       motionStartingX=event->x_root-client->x;
       motionStartingY=event->y_root-client->y;     

       switch (event->button) 
       {
         case Button1:
#ifdef GNOME
             if (clickedItem==STICKYBOX)
             { toggleClientSticky(client);
             }
#endif // GNOME     
#ifdef MAXIMIZE
             if (clickedItem==MAXBOX)
             { maximizeClient(client);
             }
#endif // MAXIMIZE 
             if (clickedItem==CLOSEBOX)
	     { sendExitClient(client);
	     }// end if CLOSEBOX
	     
             if (clickedItem==TITLEBAR)
             { //Beginning window movement, raising it
	       raiseClient(client);
	       moveClient(client);
             }
#ifndef MINIMAL	     
             if (clickedItem==WINDOWBODY)
             { //Beginning window movement, raising it
	       moveClient(client);
             }
#endif	     
             break;

#ifndef MINIMAL
        case Button2: 
             if (clickedItem==CLOSEBOX) 
	     { lowerClient(client);
	     }
#ifdef SHADE	   
             if (clickedItem==TITLEBAR) 
	     { 
	       toggleClientShaded(client); 
	     } 
#endif // SHADE   
	     if (clickedItem==WINDOWBODY)
	     { raiseClient (client);
	       moveClient  (client);
	     } 
#ifdef GNOME
             if (clickedItem==STICKYBOX)
             { if (currentDesktop==0)
	        moveClientToDesktop(client,NUMBEROFDESKTOPS-1);
	       else 
	        moveClientToDesktop(client,currentDesktop-1);
             }
#endif // GNOME    	     	     
	     break;
#endif // MINIMAL 
        case Button3: 
             if (clickedItem==CLOSEBOX) 
	     { //Beginning window resize
#ifdef NORESIZEWARP
	       handledClient_old_y=client->y+client->height;
#endif	     
	       resizeClient (client);	   
	     }
#ifdef MAXIMIZE		   	     
	     if (clickedItem==MAXBOX) 
	     { 
	       unmaximizeClient(client);
	     } 
#endif // MAXIMIZE	     

#ifndef MINIMAL
	     if (clickedItem==TITLEBAR)
	     { // Beginning window movement in background
               moveClient (client);
	     } 
	     if (clickedItem==WINDOWBODY)
	     { // Beginning window resizement im hintergrund 
#ifdef NORESIZEWARP
	       handledClient_old_y=false;
#endif
               resizeClient (client);
	     } 
#endif // MINIMAL
#ifdef GNOME
             if (clickedItem==STICKYBOX)
             { if (currentDesktop<NUMBEROFDESKTOPS-1)
	        moveClientToDesktop(client,currentDesktop+1);
	       else 
	        moveClientToDesktop(client,0);
             }
#endif // GNOME    
	     break;
        }// end switch button 
#ifdef RAISEONCLICK       
      }// end if not client window 
#endif
    }// end if client 
  }// end else if rootwin 

#ifdef TRACE
  trace(-1,"buttonPressEventHandler");
#endif

}// end buttonPressEventHandler 

/*************************************************************************/

/* mouseMotionEventHandler
   handles mouse movement while moveing or resizing clients

   v1.3.0-pre1: initial release
   v1.3.0-pre2: window move/resize now uses updateClient directly
   v1.3.0-pre3: updated to support FAST again
   v1.3.0-pre4: no change
   v1.3.0-pre5: no change
   v1.3.0-pre6: no change
   v1.3.0:      no change
   v1.3.1-pre1: added NORESIZEWARP
*/

void mouseMotionEventHandler(XMotionEvent *event)
{
#ifdef TRACE
  trace(1,"mouseMotionEventHandler");
#endif

#ifndef MINIMAL
  while (XCheckTypedEvent (display, MotionNotify, (XEvent *) event));
#endif

  if (handledClient) 
  { if (pointerMode==POINTERMOVEMODE)
    { 
#ifdef FAST
      drawOutline(handledClient);
#endif      

      handledClient->x=event->x_root-motionStartingX;
      handledClient->y=event->y_root-motionStartingY;

#ifndef MINIMAL
#ifndef FAST 
      updateClient (handledClient,UPDATESIZE);	
#else
      drawOutline(handledClient);
#endif	
#endif // MINIMAL 
    }// end if POINTERMOVEMODE
    if (pointerMode==POINTERRESIZEMODE)
    { 
#ifdef FAST
      drawOutline(handledClient);
#endif	
      handledClient->width=event->x_root-handledClient->x;
      if (handledClient->width<MINWINDOWWIDTH) handledClient->width=MINWINDOWWIDTH;
      handledClient->height=event->y_root-handledClient->y;
      if (handledClient->height<0) handledClient->height=0;

#ifndef MINIMAL
#ifndef FAST
      updateClient (handledClient,UPDATESIZE); 
#else
      drawOutline (handledClient);
#endif	
#endif // MINIMAL 
    }// end if POINTERRESIZEMODE
#ifdef NORESIZEWARP    
    if (pointerMode==POINTERBOXRESIZEMODE)
    { 
#ifdef FAST
      drawOutline(handledClient);
#endif	
      handledClient->width = event->x_root-handledClient->x;
      if (handledClient->width<MINWINDOWWIDTH) handledClient->width=MINWINDOWWIDTH;
      
      handledClient->y=event->y_root+TITLEBARHEIGHT;
      handledClient->height=handledClient_old_y-event->y_root-TITLEBARHEIGHT;
      if (handledClient->height<0) handledClient->height=0;

#ifndef MINIMAL
#ifndef FAST
      updateClient (handledClient,UPDATESIZE); 
#else
      drawOutline (handledClient);
#endif	
#endif // MINIMAL
    }
#endif // NORESIZEWARP    
  }// end if andledClient 
#ifdef TRACE
  trace(-1,"mouseMotionEventHandler");
#endif

}// end mouseMotionEventHandler 

/*************************************************************************/

/* buttonReleaseEventHandler
   handles button releases and finishes running actions

   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: updated to support FAST again, skiping closed window
*/
void buttonReleaseEventHandler(XButtonEvent *event)
{ 
#ifdef TRACE
  trace(1,"buttonReleaseEventHandler");
#endif

   if (handledClient) 
   {
#ifdef DEBUGPARANOID
     if (handledClient->name) err("window: %s",handledClient->name);
#endif
     if (pointerMode!=POINTERNORMALMODE)
     { pointerMode=POINTERNORMALMODE;
       XUngrabPointer(display,CurrentTime);
#ifdef FAST
       // clear window border again
#ifndef MINIMAL
       drawOutline(handledClient);
#endif // MINIMAL
#endif      
       updateClient(handledClient,UPDATESIZE);
       handledClient=NULL;
     }// end if pointernormalmode   
   }// end if handledClient 

#ifdef TRACE
  trace(-1,"buttonReleaseEventHandler");
#endif

}// end buttonReleaseEventHandler 

/*************************************************************************/

/* swmEventLoop
   is the main part of swm, receiving all event
   
   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: no change
   v1.3.0-pre4: showEvents is now DEBUGPARANOID
   v1.3.0-pre5: no change
   v1.3.2:      now skipping clientMessageHandler
   v1.3.4:	only running reparentEventHandler in VERBOSE mode
*/

void swmEventLoop()
{ XEvent event;
#ifdef TRACE
  trace(1,"swmEventLoop");
#endif

  while (!exitSWM) 
  { 
      XNextEvent(display, &event); 

#ifdef DEBUGPARANOID
      showEvents(event);
#endif
      switch (event.type) 
      { case ButtonPress  : buttonPressedEventHandler  	(&event.xbutton); 
             break;
        case ButtonRelease: buttonReleaseEventHandler	(&event.xbutton); 
             break;
        case MotionNotify : mouseMotionEventHandler    	(&event.xmotion);    
             break; 
        case EnterNotify  : enterEventHandler	     	(&event.xcrossing); 
             break;
        case ConfigureRequest:configureRequestHandler	(&event.xconfigurerequest); 
             break;
        case MapRequest	  : mapRequestHandler	   	(&event.xmaprequest);  
             break;
        case UnmapNotify  : unmapEventHandler	   	(&event.xunmap); 
             break;
#ifndef MINIMAL	     
        case ClientMessage: clientMessageHandler	(&event.xclient); 
             break;
#endif
        case PropertyNotify:propertyChangeHandler    	(&event.xproperty); 
             break;
        case Expose       : exposeEventHandler 	   	(&event.xexpose); 
             break;
#ifdef VERBOSE
        case ReparentNotify: reparentEventHandler	(&event.xreparent); 
             break;
#endif //VERBOSE
        case DestroyNotify: destroyNotifyHandler 	(&event.xdestroywindow); 
	     break;
#ifdef LOWCOLOR      
        case ColormapNotify: 
	                    colormapChangeHandler   	(&event.xcolormap); 
             break;
#endif
	case KeyPress  	  : 
#ifdef KEYS
	                    keyEventHandler  		(&event.xkey); 
#endif
             break;
      }// end switch 
  }// end while not exitSWM 

#ifdef TRACE
  trace(-1,"swmEventLoop");
#endif
}// end swmEventLoop 

/***************************************************************************/
