/***************************************************************************
                        errorHandler.c  -  description			  
                        ------------------------------

   begin                : Sam Jul 22 11:40:05 CEST 2000
   copyright            : (C) 2000-2002 by Robert Sperling
   email                : sperling@small-window-manager.de
   version              : v1.3.4
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef TRACE
#define DEBUG
#endif

#ifndef MINIMAL
#define ignoreXErrors(statement) (\
	XSync(display,0), XSetErrorHandler(expectedXErrorHandler),	\
	statement,	\
	XSetErrorHandler(xErrorHandler))
#endif

#ifdef DEBUG
#include <stdarg.h>

#ifndef MINIMAL
static int debuglevel = 0;
static int nodebug    = 0;
#endif

void err(char *fmt, ...)
{
  int counter;
  va_list argp;

  if (!nodebug)
  { for (counter=0 ; counter<debuglevel ; counter++) 
      fprintf(stderr," ");

    fprintf(stderr, "swm: > ");
    va_start(argp, fmt);
    vfprintf(stderr, fmt, argp);
    va_end(argp);
    fprintf(stderr, "\n");
  }// end if nodebug 
}
#endif

/***************************************************************************/

#ifdef TRACE
void trace(int level, char *fmt, ...)
{
  int counter;
  va_list argp;

  if (!nodebug)
  { if (level<0) { debuglevel=debuglevel+level; }
    if (debuglevel<0) fprintf(stderr,"panic!!");

    for (counter=0 ; counter<debuglevel; counter++) 
      fprintf(stderr," ");
  
    fprintf(stderr, "SWM: ");
  
    if (level>=0) 
    { fprintf (stderr,"entered: ");
      debuglevel=debuglevel+level;
    }
    else
    { fprintf (stderr,"leaving: ");
    }

    va_start(argp, fmt);
    vfprintf(stderr, fmt, argp);
    va_end(argp);
    fprintf(stderr, "\n");
  }// end if !nodebug     
}
#endif

/***************************************************************************/

#ifdef DEBUG
/* showEvents
   displays the event received

   v1.3.0-pre1: initial release
   v1.3.0-pre4: added some Events

*/
void showEvents(XEvent e)
{ char *s;
  Window w;
  switch (e.type) {
/* Mouse */
  case ButtonPress:
  s = "ButtonPress"; w = e.xbutton.window; break;
  case ButtonRelease:
  s = "ButtonRelease"; w = e.xbutton.window; break;
  case MotionNotify:
  s = "MotionNotify"; w = e.xmotion.window; break;
/* Keyboard */
  case KeyPress:
#ifdef KEYS			
  s = "KeyEvent"; w = e.xkey.window; 
#endif
       break;
  case KeyRelease:
#ifdef KEYS			
  s = "KeyRelease"; w = e.xkey.window; 
#endif
       break;
  case KeymapNotify:
#ifdef KEYS			
  s = "KeymapNotify"; w = e.xkey.window; 
#endif
       break;
  case ClientMessage:
  s = "ClientMessage"; w = e.xclient.window; break;
  case ColormapNotify:
  s = "ColormapNotify"; w = e.xcolormap.window; break;
  case ConfigureNotify:
  s = "ConfigNotify"; w = e.xconfigure.window; break;
  case ConfigureRequest:
  s = "ConfigRequest"; w = e.xconfigurerequest.window; break;
  case CreateNotify:
  s = "CreateNotify"; w = e.xcreatewindow.window; break;
  case DestroyNotify:
  s = "DestroyNotify"; w = e.xdestroywindow.window; break;
/* Window change */
  case EnterNotify:
  s = "EnterNotify"; w = e.xcrossing.window; break;
  case LeaveNotify:
  s = "*unhandled LeaveNotify"; w = e.xcrossing.window; break;
  case FocusIn:
  s = "FocusIn"; w = e.xfocus.window; break;
  case FocusOut:
  s = "FocusOut"; w = e.xfocus.window; break;
  case Expose:
  s = "ExposeEvent"; w = e.xexpose.window; break;
  case GraphicsExpose:
  s = "GraphicsExposeEvent (unhandled)"; w = e.xexpose.window; break;
  case NoExpose:
  s = "NoExposeEvent (unhandled)"; w = e.xnoexpose.drawable; break;
  case MapNotify:
  s = "MapNotify"; w = e.xmap.window; break;
  case MapRequest:
  s = "MapRequest"; w = e.xmaprequest.window; break;
  case MappingNotify:
  s = "MappingNotify"; w = e.xmapping.window; break;
  case VisibilityNotify:
  s = "VisibilityNotify"; w = e.xvisibility.window; break;
  case GravityNotify:
  s = "GravityNotify"; w = e.xgravity.window; break;
  case PropertyNotify:
  s = "PropertyNotify"; w = e.xproperty.window; break;
  case ReparentNotify:
  s = "ReparentNotify"; w = e.xreparent.window; break;
  case ResizeRequest:
  s = "ResizeRequest"; w = e.xresizerequest.window; break;
  case UnmapNotify:
  s = "UnmapNotify"; w = e.xunmap.window; break;
  case CirculateNotify:
  s = "CirculateNotify" ; w = e.xcirculate.window; break;
  case CirculateRequest:
  s = "CirculateRequest" ; w = e.xcirculate.window; break;
  default:
  s = "unknown event"; w = None; break;
}/* end showEvents */

  err("recieved %s,\twindow = %#x", s, w);
}/* end showEvents */
#endif

/***************************************************************************/

#ifndef MINIMAL
int debug_getWmState(Client *client)
{ Atom real_type;
  int real_format, state;
  unsigned long n, extra;
  unsigned char *data;
  int returnState;
 
  ignoreXErrors(returnState=XGetWindowProperty(display, client->window, 
                                 xa_wm_state, 0L, 2L, False,
                                 AnyPropertyType, &real_type, 
				 &real_format, &n, &extra, &data));
  if (returnState == Success && n) 
  { state = *(int *)data;
    if (data) XFree(data);
    return state;
  }// end if XGetWindowProperty
  
  return WithdrawnState;
}// end debug_getWmState
#endif

/***************************************************************************/

#ifdef DEBUG
void dumpClients()
{ Client *client;
  int counter=0;
  fprintf (stderr,"rootwin: (%#lx)\n",rootWindow);

  XGrabServer(display);  
  fprintf(stderr,"*****************************************************************\n");
  client = headClient;
  while (client)
  { counter++;
    if (client->name) fprintf (stderr,"*%s\n",client->name);
    else fprintf(stderr,"*unknown window/name\n");
    fprintf(stderr," state:%d,",debug_getWmState(client));
    fprintf(stderr,"iUnmaps:%d,",client->ignoreUnmap);

    if (client->window) fprintf (stderr,"win: (%#lx),",client->window);
    else fprintf (stderr,"nowindow,");
    if (client->parent) fprintf (stderr,"par: (%#lx),",client->parent);
    else fprintf (stderr,"noparent,");
#ifdef LAYERS
    nodebug++;
    fprintf(stderr," layer:%ld",getValuedHint(client->window,xa_windowLayer));
    fprintf(stderr," curlayer:%d",client->layer);
    nodebug--;
#endif
//    err(" %#x (%#x) @ %d,%d", 
//	client->x, client->y);
   fprintf(stderr,"\n");
   client=client->next;
  }	
  fprintf(stderr,"*****************************************************************\n");
  XUngrabServer(display);
  fprintf(stderr,"ClientCounter  : %d\n",clientCounter);
  fprintf(stderr,"Clients in List: %d\n",counter);
}
#endif

/* xErrorHandler
   should handle alle swm-internal errors
*/
int xErrorHandler(Display *display, XErrorEvent *event)
{ 
  Client 	*client;
#ifdef DEBUG
  char 		errorMessage[80];
#endif

#ifdef TRACE
  trace(1,"********************** xErrorHandler *************************");
#endif

  if (event->error_code == BadAccess && event->resourceid == rootWindow) 
  { 
#ifdef STD_IO
    fprintf(stderr,"root window unavailible (maybe another wm is running?)\n");
#endif

#ifndef NOROOTCHECK
    exit(1);
#endif

  }// end if rootWin unavailable 
  else
  { 
#ifdef DEBUG
    XGetErrorText(display, event->error_code, errorMessage,
                  sizeof(errorMessage));
    err("> X error (%#x): %s", event->resourceid, errorMessage);
    nodebug++;
#endif      
    client=getClient(event->resourceid,anyWindow);
#ifdef DEBUG
    nodebug--;
#endif        
    if (client)
    { 
#ifdef DRAWTITLE
      if (client->name) 
      { 
#ifdef DEBUG      
        err("> error caused by client: %s\n",client->name);
#endif /* DEBUG */
      }
#endif /* DRAWTITLE */

#ifdef DEBUGPARANOID
      err ("> getting error code");
#endif      

#ifdef DEBUG
      XGetErrorText(display, event->error_code, errorMessage,
                    sizeof(errorMessage));
      err("> X error (%#x): %s", event->resourceid, errorMessage);
#endif      

/* Ich hoffe dies wird nicht mehr notwendig sein... */
// if (event->resourceid==client->window) removeClient(client, 0);             
 if (event->resourceid==client->window) removeParent(client, false);             

    }// end if client 
  }// end else if rootwin 

#ifdef TRACE
  trace(-1,"*********************** xErrorHandler **************************");
#endif
  return 0;
}// end xErrorHandler

/**********************************************************************/

/* cleanUpErrorHandler
   is only here for debugging - I hate this really

*/
#ifndef MINIMAL
int cleanUpErrorHandler(Display *display, XErrorEvent *event)
{ 
#ifdef DEBUG	
  char errorMessage[80];
#endif

  Client *client;
  client=getClient(event->resourceid,anyWindow);

#ifdef DEBUG

  XGetErrorText(display, event->error_code, errorMessage, 
                sizeof(errorMessage));
  err("* cleanup error (%#x): %s", event->resourceid, errorMessage);
  if (client && client->name) err("* client: %s",client->name);  

  XGetErrorText(display, event->request_code, errorMessage, 
                sizeof(errorMessage));
  err("* request: %s", errorMessage);
#endif

  if (client && client->window==event->resourceid) client->window=0;
  
#ifdef PIXMAP
//  if (client && client->closebox==event->resourceid) client->closebox=0;
//#ifdef MAXIMIZE
//  if (client && client->maxbox==event->resourceid) client->maxbox=0;
//#endif

//#ifdef GNOME
//  if (client && client->stickybox==event->resourceid) client->stickybox=0;
//#endif  
#endif
  return 0;
}// end cleanUpErrorHandler
#endif // NOT MINIMAL

/**********************************************************************/

/* expectedErrorHandler
   carefully ignores some errors. This functions is important for handling
   unmanaged windows

*/
int expectedXErrorHandler(Display *display, XErrorEvent *event)
{ 
#ifdef DEBUG	
  char errorMessage[80];
#endif
  
#ifdef DEBUG
  XGetErrorText(display, event->error_code, errorMessage, 
                sizeof(errorMessage));

//  err("* cleanup error (%#x): %s", event->resourceid, errorMessage);
//  XGetErrorText(display, event->request_code, errorMessage, 
//                sizeof(errorMessage));
  
#endif
  return 0;
}// end expectedErrorHandler
