/***************************************************************************
                           client.c  -  description
                           ------------------------
    begin                : Wed May 22 10:12:15 CEST 2001
    copyright            : (C) 2000-2002 by Robert Sperling
    email                : sperling@small-window-manager.de
    version              : v1.3.4
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


/***************************************************************************
 * description: this file contains functions to manipulate clients and     *
 *              windows                                                    *
 *                                                                         *
 * - client->y|height show the childWindows coordinates                    *
 *   but y has to be set to TITLEBARHEIGHT within parent window            *
 ***************************************************************************/

/* sendConfig
   updates the clients parameters
   
   v1.3.0-pre1: initial release
*/

void sendConfig(Client *client)
{ XConfigureEvent cevent;

#ifdef TRACE
  trace(1,"sendConfig");
#endif

#ifdef DEBUGPARANOID
  err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

  cevent.type 		= ConfigureNotify; 
  cevent.event 		= client->window;
  cevent.window 	= client->window;
  cevent.x 		= client->x;
  cevent.y 		= client->y;
  cevent.width 		= client->width;
  cevent.height 	= client->height;
  cevent.border_width 	= 2;
  cevent.above 		= None;
  cevent.override_redirect = 0;
  XSendEvent(display, client->window, False, StructureNotifyMask, 
             (XEvent *)&cevent);

#ifdef TRACE
  trace(-1,"sendConfig");
#endif
}// end sendConfig

/*************************************************************************/

/* redrawParent
   redraws the windows titlebar
   
   v1.3.0-pre1: initial release
   v1.3.0-pre2: updated to NOBORDER
   v1.3.0-pre3: updated pixmap support
   v1.3.0-pre4: used stringGC fir border, now fixed
   v1.3.1:      eliminated XClearWindow in MINIMAL mode, eliminated NOBORDER
   v1.3.3:      now only redrawing if client is on current desktop
*/

void redrawParent(Client *client)
{ 
#ifndef PIXMAPS
  unsigned int x,y=TITLEBARHEIGHT/2;
#endif  

#ifdef LAYERS
  char stringDummy[512];
#endif

#ifdef TRACE
  trace(1,"redrawParent");
#endif

#ifdef DEBUG
  if (client)
  {
#endif

#ifdef DEBUGPARANOID
    err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

#ifdef GNOME
    if (client->desktop==currentDesktop)
    {
#endif
    
#ifdef DRAWTITLE
#ifdef DEBUGPARANOID
      if (client->name) err("redrawing window: %s",client->name);
#endif
#endif

#ifndef MINIMAL
      XClearWindow(display,client->parent);
#endif

#ifdef MWM
      if (client->frameState==FRAMESHOWN)
      {
#endif // MWM

#ifdef DEBUGPARANOID
        err("frame shown");
#endif

        // line below titlebar   
#ifndef MINIMAL
        XDrawLine(display,client->parent,borderGC,0,TITLEBARHEIGHT-1,client->width+1,TITLEBARHEIGHT-1);
#endif

#ifndef MINIMAL
        // Outer Border 
        XDrawRectangle(display, client->parent, borderGC, 0, 0, client->width+1, client->height+TITLEBARHEIGHT);
#endif

#ifdef PIXMAPS
        XClearWindow(display,client->closebox);
#ifdef MAXIMIZE     
        XClearWindow(display,client->maxbox);
#endif // MAXIMIZE 

#ifdef GNOME     
        XClearWindow(display,client->stickybox); 
#endif // GNOME      

#else // PIXMAPS 
        // closebox 
        x=client->width-TITLEBARHEIGHT+1;
        XDrawLine(display, client->parent, borderGC, x, 0, x, TITLEBARHEIGHT);
    
        x=client->width-TITLEBARHEIGHT/2+1;
        // x-Box  
        XDrawLine(display, client->parent, borderGC,x-4,y-3,x+3,y+4);
        // x-Box  
        XDrawLine(display, client->parent, borderGC,x+3,y-4,x-4,y+3);

#ifdef MAXIMIZE
        x=client->width - 3*TITLEBARHEIGHT/2+1;
        // +-Box left down-line 
        XDrawLine(display, client->parent, borderGC, 
                  client->width-2*TITLEBARHEIGHT, 0,
                  client->width-2*TITLEBARHEIGHT, TITLEBARHEIGHT);

        // +-Box down line of +  
        XDrawLine(display, client->parent, borderGC, x-4, y, x+3,y);
        // +-Box - 
        XDrawLine(display, client->parent, borderGC, x-1, y-3, x-1,y+4);
#endif // MAXIMIZE 

#ifdef GNOME
#ifdef MAXIMIZE
        x=client->width - 5*TITLEBARHEIGHT/2;
#else
        x=client->width - 3*TITLEBARHEIGHT/2+2;
#endif // MAXIMIZE

        // +-Box left down-line 
        XDrawLine (display, client->parent, borderGC, 
                   x-TITLEBARHEIGHT/2, 0,
                   x-TITLEBARHEIGHT/2, TITLEBARHEIGHT);
        XDrawRectangle(display, client->parent, borderGC, x-4, y-3, 6,6);
        if (client->sticky)
        { XDrawLine (display, client->parent, borderGC, x-4,y-4,x-1,y+1);
          XDrawLine (display, client->parent, borderGC, x-1,y+1,x+5,y-7);
        }
#endif // GNOME
#endif // PIXMAPS 

#ifdef FONTS
#ifdef DRAWTITLE
        if (client->name)
        { 
#ifdef SHOWLAYERS
          if (client->layer==WIN_LAYER_NORMAL)
#endif // SHOWLAYERS
            XDrawString(display, client->parent, stringGC, 2,
                        swmFont->ascent+1, client->name, strlen(client->name));
#ifdef SHOWLAYERS
          else
          { sprintf (stringDummy,"(%d)%s",client->layer-WIN_LAYER_NORMAL,client->name);
            XDrawString(display, client->parent, stringGC, 2,
                        swmFont->ascent+1, stringDummy, strlen(stringDummy));
          }
#endif // SHOWLAYERS
        }// end if client name
#endif // DRAWTITLE
#endif // FONTS

#ifdef MWM
      }// end if frameShown
      else
      {
        // Outer Border 
        XDrawRectangle(display, client->parent, borderGC, 0, 0, client->width+1,client->height+1);
      } // endelse frameshown
#endif // MWM

#ifdef GNOME
    }//desktop==currentdesktop
#endif

#ifdef DEBUG
  } // end if client 
#endif

#ifdef HEAVYSYNC
  XSync(display,false);
#endif

#ifdef TRACE
  trace(-1,"redrawParent");
#endif
} // end redrawParent 

/*************************************************************************/

/* drawOutline
   redraws the windows border in resize/move mode if FAST
   
   v1.3.0-pre3: initial release
   v1.3.0-pre4: moved rectangle out of the window to avoid expose problems
*/

//#ifdef FAST
void drawOutline(Client *client)
{ 
#ifdef MWM
  if (client->frameState==FRAMESHOWN)
#endif // MWM  
    XDrawRectangle(display, rootWindow, invertGC, 
                   client->x-2, client->y-TITLEBARHEIGHT-3, 
                   client->width+3, client->height+TITLEBARHEIGHT+2);
#ifdef MWM
  else
    XDrawRectangle(display, rootWindow, invertGC, 
                   client->x-1, client->y-1, 
                   client->width+2, client->height+2);
#endif // MWM

}// end drawOutline 
//#endif //FAST

/***************************************************************************/

/* updateClient
   changes Client window according to Client record

   v1.3.0-pre1: initial release
   v1.3.0-pre2: updated to NOBORDER option, updated SHADED
   v1.3.0-pre3: updated pixmap support
   v1.3.0-pre4: border messages now DEBUGPARANID
   v1.3.1:      added MAXRESTRICT, ALWAYSMAX
   v1.3.4:      added HEAVYSYNC
*/

void updateClient(Client *client, int whatToUpdate)
{ int basex, basey;
#ifdef TRACE
  trace (1,"updateClient");
#endif

#ifdef DEBUG
  err("updateClientWin:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

  if (whatToUpdate==UPDATESIZE)
  { 
    if (client->size->flags & PResizeInc) 
    { basex = (client->size->flags & PBaseSize) ? client->size->base_width :
              (client->size->flags & PMinSize) ? client->size->min_width : 0;
      basey = (client->size->flags & PBaseSize) ? client->size->base_height :
              (client->size->flags & PMinSize) ? client->size->min_height : 0;
               client->width -= (client->width - basex) % client->size->width_inc;
               client->height -= (client->height - basey) % client->size->height_inc;
    }// end if PResizeInc 

#ifdef ALWAYSMAX
      if (client->size->flags & PMaxSize)
      { // FIXME: Not implemented, yet 
      } else
      { client->x=0;
        client->width=xmax;
#ifdef MWM
        if (client->frameState!=FRAMESHOWN)
	{ client->y=0;
	  client->height=ymax;
	} else {
#endif // MWM
	  client->height=ymax-TITLEBARHEIGHT;
          client->y=TITLEBARHEIGHT;
#ifdef MWM
        }// end else FRAMESHOWN
#endif // MWM	  
      }// elseif MaxSize 
#endif // ALWAYSMAX	       

#ifdef ALWAYSCENTER
    client->x=xmax/2-client->width/2;
    client->y=ymax/2-client->height/2;
#endif

#ifdef MAXRESTRICT
    if (client->x < 0)    client->x=0;
    if (client->y < 0)    client->x=0;
    if (client->x > xmax) client->x=xmax-TITLEBARHEIGHT;
    if (client->y > ymax) client->y=ymax-TITLEBARHEIGHT;    

    if (client->width+client->x>xmax && (client->x<xmax)) 
      client->width=xmax-client->x;
    if (client->height+client->y>ymax && (client->y<ymax)) 
      client->height=ymax-client->y;
#endif // MAXRESTRICT

#ifdef MWM
    if (client->frameState!=FRAMESHOWN)
    {
#ifdef DEBUGPARANOID
      err("updated: frame not shown, border");
#endif // DEBUGPARANOID

      XMoveResizeWindow(display, client->parent, 
                        client->x-1, client->y-3, 
                        client->width+2, client->height+2);
      XMoveResizeWindow(display, client->window, 1, 1,
                        client->width, client->height);
    }				 
    else
    {
#endif // MWM    

#ifdef DEBUGPARANOID
      err("updated: frame shown");
#endif

#ifdef SHADE      
      if (client->shaded)
      XMoveResizeWindow(display, client->parent, client->x-1,client->y-TITLEBARHEIGHT-2, client->width+2, TITLEBARHEIGHT);
      else
#endif
       XMoveResizeWindow(display, client->parent, client->x-1, client->y-TITLEBARHEIGHT-2, client->width+2, client->height+TITLEBARHEIGHT+1);

#ifdef PIXMAPS
      XMoveResizeWindow(display, client->closebox, client->width-TITLEBARHEIGHT+2,0, TITLEBARHEIGHT,TITLEBARHEIGHT);
#ifdef MAXIMIZE
      XMoveResizeWindow(display, client->maxbox, client->width-2*TITLEBARHEIGHT+2,0, TITLEBARHEIGHT,TITLEBARHEIGHT);
#endif				 

#ifdef GNOME
#ifdef MAXIMIZE
      XMoveResizeWindow(display, client->stickybox, client->width-3*TITLEBARHEIGHT+2,0, TITLEBARHEIGHT,TITLEBARHEIGHT);
#else // MAXIMIZE
      XMoveResizeWindow(display, client->stickybox, client->width-2*TITLEBARHEIGHT+2,0, TITLEBARHEIGHT,TITLEBARHEIGHT);
#endif // MAXIMIZE				 
#endif // GNOME	
			 
#endif // PIXMAP
      XMoveResizeWindow(display, client->window, 1, TITLEBARHEIGHT, client->width, client->height);
				 
#ifdef MWM
    }// end else if frameHidden 
#endif // MWM
    sendConfig(client);
  }// end if UPDATESIZE

#ifdef HEAVYSYNC
  XSync(display,false);
#endif

#ifdef TRACE
  trace (-1,"updateClient");
#endif

}// end updateClient

/****************************************************************************/

#ifdef MAXIMIZE
/* maximizeClient 
   resizes the client to full screen. If gnome is enabled, windowState is
   set to both WINSTATE_MAXIMIZED_ horizontal & vertical

   v1.3.0-pre1: initial release
*/
void maximizeClient(Client *client)
{ 

#ifdef TRACE
  trace(1,"maximizeClient");
#endif

#ifdef DEBUG  
  if (client) 
  { 
#endif

#ifdef DEBUGPARANOID
  err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

    if (!client->maximized)
    { client->normalX		= client->x;
      client->normalY		= client->y;
      client->normalWidth	= client->width;
      client->normalHeight	= client->height;
      client->maximized		= true;

#ifdef GNOME
      setHint (client->window, xa_windowState, WIN_STATE_MAXIMIZED); 
#endif    

    }// end if not maximized

    client->x			= 0;
    client->width		= xmax;
    
#ifdef MWM    
    if (client->frameState!=FRAMESHOWN)
    { client->y			= 0;
      client->height		= ymax;
    }
    else
    {
#endif // MWM   
      client->y			= TITLEBARHEIGHT;
      client->height		= ymax-TITLEBARHEIGHT;
#ifdef MWM
    } // endelse !FRAMESHOWN   
#endif // MWM    

    if (client->size->flags & PMaxSize) 
    { if (client->width > client->size->max_width) 
        client->width = client->size->max_width;
      if (client->height > client->size->max_height) 
        client->height = client->size->max_height;
    }// end if client size hints

    updateClient(client,UPDATESIZE);

#ifdef DEBUG
  }// end if client 
#endif

#ifdef TRACE  
  trace(-1,"maximizeClient");
#endif  

}// end maximizeClient
#endif // MAXIMIZE

/***************************************************************************/

/* unMaximizeClient 
   resizes the client to the orginal size

   v1.3.0-pre1: initial release
*/

#ifdef MAXIMIZE
void unmaximizeClient(Client *client)
{ 

#ifdef TRACE
  trace(1,"unmaximizeClient");
#endif

#ifdef DEBUG  
  if (client) 
  {
#endif

#ifdef DEBUGPARANOID
  err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

    if (client->maximized)
    { client->x=client->normalX;
      client->y=client->normalY;
      client->width=client->normalWidth;
      client->height=client->normalHeight;
      client->maximized=false;  
// TESTING not grabbing Server tries to avoid spinlocks
//      XGrabServer(display);
      updateClient(client,UPDATESIZE);
      sendConfig(client);
//      XUngrabServer(display);
#ifdef GNOME
// delete Property WIN_STATE_MAXIMIZED
      deleteHint (client->window, xa_windowState, WIN_STATE_MAXIMIZED); 
#endif    
    }// end if maximized 

#ifdef DEBUG
  }// end if client 
#endif

#ifdef TRACE  
  trace(-1,"unmaximizeClient");
#endif  

}// end unmaximizeClient 

#endif // MAXIMIZE

/***************************************************************************/

#ifdef SHADE
/* toggleClientShaded
   shades the window up/down, ignoring any action if the client has no frame
   
   v1.3.0-pre1: initial release, shading is done without updateClient
                unshading uses updateClient
   v1.3.0-pre2: fixed some cosmetics, now using fully updateClient
   v1.3.0-pre3: no change
   v1.3.0-pre4: added XSync after updateClient to ensure proper display
   v1.3.4:      XSyncing now only if HEAVYSYNC is enabled
                sendConfig(client); after updateClient not nessasary anymore
*/

void toggleClientShaded(Client *client) 
{ 
#ifdef TRACE
  trace(1,"toggleClientShaded");
#endif

#ifdef DEBUG  
  if (client) 
  {
#endif

#ifdef DEBUGPARANOID
  err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

#ifdef MWM	  
    if (!client->frameState) 
    {
#endif // MWM	    

#ifdef GNOME
    toggleHint(client->window, xa_windowState, WIN_STATE_SHADED); 
#endif // GNOME

      if (!client->shaded) 
        client->shaded = true;
      else 
        client->shaded = false;
      
      updateClient(client,UPDATESIZE);

#ifdef HEAVYSYNC
      XSync (display,false);
#endif

#ifdef MWM      
    }// end if frameHidden 
#endif // MWM

#ifdef DEBUG
  }// end if client
#endif

#ifdef TRACE
  trace(-1,"toggleClientShaded");
#endif
}// end toggleClientShaded 
#endif // SHADE 

/***************************************************************************/

#ifdef MWM

/* toggleFrameHidden
   hides/shows the titlebar
   
   v1.3.0-pre1: initial release
   v1.3.0-pre2: updated to FRAMELESS
   v1.3.0-pre3: updated pixmap support
   v1.3.4:	HEAVYSYNC included
                sendConfig(client); after updateClient not needed anymore

*/

void toggleFrameHidden(Client *client) 
{ 
#ifdef TRACE
  trace(1,"toggleFrameHidden");
#endif

#ifdef DEBUG  
  if (client) 
  {
#endif

#ifdef DEBUGPARANOID
  err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

#ifdef SHADE
    if ((!client->shaded) && (client->frameState!=FRAMELESS))
    {
#endif	    
      if (!client->frameState) 
      { client->frameState = FRAMEHIDDEN;
        changeGravity(client,-1);
#ifdef PIXMAPS
	XUnmapWindow (display,client->closebox);
#ifdef MAXIMIZE
	XUnmapWindow (display,client->maxbox);
#endif	
#ifdef GNOME
	XUnmapWindow (display,client->stickybox);
#endif	
#endif      

#ifdef HEAVYSYNC
	XSync(display,false);	
#endif

        updateClient(client,UPDATESIZE);
	
      }// end if not frameHidden 
      else 
      { client->frameState = FRAMESHOWN;
        changeGravity(client,1);
#ifdef PIXMAPS
	XMapWindow (display,client->closebox);
#ifdef MAXIMIZE
	XMapWindow (display,client->maxbox);
#endif	
#ifdef GNOME
	XMapWindow (display,client->stickybox);
#endif // GNOME 
#endif // PIXMAPS 
        updateClient(client,UPDATESIZE);
      }
      sendConfig(client);
#ifdef SHADE      
    }// end if not shaded
#endif  
  
#ifdef DEBUG
  }// end if client 
#endif

#ifdef TRACE  
  trace(-1,"toggleFrameHidden");
#endif
}// end toggleFrameHidden 

#endif // MWM

/***************************************************************************/

/* hideClient
   hides the client by unmapping its windows
   
   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: updated pixmap support
*/
void hideClient(Client *client)
{ 
#ifdef TRACE
   trace(1,"hideClient");
#endif

#ifdef DEBUGPARANOID
   err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
   if (client) 
   {
#endif
    client->ignoreUnmap++;
    XUnmapWindow(display, client->parent);

    //We should now tell the client that it is now unmapped
    XUnmapWindow(display, client->window);    
    setValuedHint (client->window, xa_wm_state, IconicState);
#ifdef DEBUGPARANOID
   }// if client
#endif

#ifdef TRACE   
   trace(-1,"hideClient");
#endif  
}// end hideClient 

/***************************************************************************/

/* unhideClient
   shown the client again after it was unmapped. xm_state is set to Normal

   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: updated pixmap support
   v1.3.0-pre4: moved mapping of buttons to this function
                removed silly typo, showing frame all the time
   v1.3.1:      hmm, silly always mapped parentwin instead of boxes
*/

void unhideClient(Client *client)
{ 
#ifdef TRACE
  trace(1,"unhideClient");
#endif

#ifdef DEBUGPARANOID
  if (client) 
  { err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

    // tell the client that it should show up again
    setValuedHint (client->window, xa_wm_state, NormalState);
    XMapWindow(display, client->window);
    XMapWindow(display, client->parent);
    
#ifdef MWM
    if (client->frameState==FRAMESHOWN)
    {
#endif // MWM

#ifdef PIXMAP
      XMapWindow(display, client->closebox);
#ifdef MAXIMIZE    
      XMapWindow(display, client->maxbox);
#endif // MAXIMIZE
#ifdef GNOME    
      XMapWindow(display, client->stickybox);    
#endif // GNOME   
#endif // PIXMAPS

#ifdef MWM
    }
#endif // MWM

#ifdef DEBUGPARANOID
  }// endif client
#endif

#ifdef TRACE
  trace (-1,"unhideClient");
#endif

}// end unhideClient

/***************************************************************************/
/* addClientEntry
   adds the new window to the client list
   
   v1.3.0-pre6: initial release
*/
Client *addClientEntry(Window givenWin)
{ Client *client;
#ifdef TRACE
  trace(1,"addClientEntry");
#endif

  client = malloc(sizeof *client);

  if (client!=NULL)
  { if ((client->size = XAllocSizeHints())==NULL)
    { return NULL;
#ifdef DEBUGPARANOID
      exit(1);
#endif    
    }// end if no memory available for size hints 
    // putting it into the queue 
    client -> next 	= headClient;
    headClient 		= client;
#ifndef MINIMAL
    client->destroyed	= false;
#endif
#ifdef GNOME
    clientCounter++;
#endif
    client->ignoreUnmap = 0;
#ifdef LAYERS
    client->layer	= WIN_LAYER_NORMAL;
#endif    

#ifdef DEBUGPARANOID
    err("getting name");
#endif
#ifdef DRAWTITLE
    XFetchName(display, givenWin, &client->name);
#endif

#ifdef DEBUGPARANOID
    if(client->name) err("name is: %s",client->name);
#endif

#ifdef MAXIMIZE
    client->maximized	= false;
#endif    
#ifdef MWM

    client->frameState= false;
#endif // MWM   

#ifdef TRACE
    trace(-1,"addClientEntry (with client)");
#endif
    return client;
  }// end if client !=null

#ifdef TRACE
  trace(-1,"addClientEntry (with NULL)");
#endif
  return NULL;
}// end addClientEntry

/***************************************************************************/
/* frameWindow
   adds the frame around the window
   
   v1.3.0-pre6: initial release
*/
void frameWindow (Client *client)
{ XSetWindowAttributes   setAttr;

#ifdef TRACE
  trace(1,"frameWindow");
#endif

  setAttr.override_redirect 	= True;
  setAttr.background_pixel 	= backgroundColor.pixel;
  setAttr.border_pixel 		= borderColor.pixel; 

// Old behaviour of pre 1.3.x versions, not needed anymore
// setAttr.event_mask = ChildMask | ButtonPressMask | 
//                      ExposureMask | EnterWindowMask |
//			ButtonReleaseMask;

// was TESTING, I think it seems to be stable by now
    setAttr.event_mask 		= ChildMask |
				  ExposureMask |     // repaint overwritten
				                     // parent windows
                                  EnterWindowMask |  // needed to change input
				                     // focus if mouse entered
                                  ButtonPressMask;   // needed to manipulate
                                                     // window with mouse 

    client->parent = XCreateWindow(display, rootWindow, client->x-1, 
    				   client->y - TITLEBARHEIGHT-1, 
                                   client->width+1, 
				   client->height + TITLEBARHEIGHT+1,
	 	                   0, DefaultDepth(display, screen), 
				   CopyFromParent, 
				   DefaultVisual(display, screen),
                                   CWOverrideRedirect | CWBackPixel | CWBorderPixel | CWEventMask,
				   &setAttr);

#ifndef MINIMAL
    XAddToSaveSet(display, client->window);
    XSetWindowBorderWidth(display, client->window, 0);
#endif

    // reparents the client and sets its initial coordinaten IN the parents window to 0,0
#ifdef MWM
    if (client->frameState==FRAMEHIDDEN)
      XReparentWindow(display, client->window, client->parent, 1, 1);
    else
#endif
      XReparentWindow(display, client->window, client->parent, 1, TITLEBARHEIGHT);

#ifdef PIXMAPS
    XSetWindowBackgroundPixmap(display, client->parent, backgroundPix.pixmap); 

    client->closebox = XCreateWindow(display, client->parent, client->width-TITLEBARHEIGHT+1, 1, 
                                     TITLEBARHEIGHT, TITLEBARHEIGHT-2, 0, DefaultDepth(display, screen), 
                                     CopyFromParent, DefaultVisual(display, screen),
                                     CWOverrideRedirect | CWBackPixel | CWBorderPixel | CWEventMask,
				     &setAttr);
#ifdef MWM				    
    if (client->frameState==FRAMESHOWN)
#endif // MWM   
     XMapWindow(display,client->closebox);
    XSetWindowBackgroundPixmap(display, client->closebox, closeBoxPix.pixmap); 

#ifdef MAXIMIZE
    client->maxbox = XCreateWindow(display, client->parent, client->width-2*TITLEBARHEIGHT+1, 1, 
                                   TITLEBARHEIGHT-2, TITLEBARHEIGHT-2,0, DefaultDepth(display, screen), 
                                   CopyFromParent, DefaultVisual(display, screen),
                                   CWOverrideRedirect | CWBackPixel | CWBorderPixel | CWEventMask,
				   &setAttr);
#ifdef MWM
    if (client->frameState==FRAMESHOWN)
#endif // MWM   
     XMapWindow(display,client->maxbox);
    XSetWindowBackgroundPixmap(display, client->maxbox, maxBoxPix.pixmap); 
#endif // MAXIMIZE 

#ifdef GNOME
    client->stickybox = XCreateWindow(display, client->parent, client->width-2*TITLEBARHEIGHT+1, 1, 
                                      TITLEBARHEIGHT-2, TITLEBARHEIGHT-2, 0, DefaultDepth(display, screen), 
                                      CopyFromParent, DefaultVisual(display, screen),
                                      CWOverrideRedirect | CWBackPixel | CWBorderPixel | CWEventMask,
				      &setAttr);
    if (client->frameState==FRAMESHOWN) XMapWindow(display,client->stickybox);

    if (client->sticky) XSetWindowBackgroundPixmap(display, client->stickybox, stickyBoxPix.pixmap); 
    else XSetWindowBackgroundPixmap(display, client->stickybox, unStickyBoxPix.pixmap); 
#endif // GNOME 
#endif // PIXMAPS 

#ifdef TRACE
  trace(-1,"frameWindow");
#endif

}// end frameWindow 

/***************************************************************************/

/* createNewClient
   makes swm manage a new window

   Basic functions:
   * collect all known/useful window parameters
   * initialize client record in list

   v1.3.0-pre1: initial release  
   v1.3.0-pre2: updated to NOBORDER, added CENTERNEW   
   v1.3.0-pre3: updated pixmap support
   v1.3.0-pre4: no change
   v1.3.0-pre5: no change
   v1.3.0-pre6: fixed some bugs, compressed a bit
   v1.3.4:	remove sendConfig after updateClient,
   		eliminated focusClient
*/    

void createNewClient (Window givenWin)
{ Client 		*client;
  XWindowAttributes 	 attr;
  XWMHints 		*hints;
#ifdef MWM
  PropMwmHints		*mwmHints;
  long			 itemsRead, itemsLeft;
  int			 realFormat;
  Atom			 realType;
#endif	  
  long  		 dummy;
  
#ifdef TRACE
  trace(1,"createNewClient");
#endif
  
  XSetErrorHandler(expectedXErrorHandler);

  client = addClientEntry(givenWin);

  if (client==NULL)
  { 
#ifdef DEBUG
    err("ERROR: allocating memory failed (PANIC)");
#endif  
#ifdef TRACE
    trace(-1,"createNewClient (aborted)");
#endif
    return;
  }// endif client=NULL

  XGetWindowAttributes(display, givenWin, &attr);
  hints 	     = XGetWMHints(display, givenWin);
  XGetWMNormalHints   (display, givenWin, client->size, &dummy);

  client->window     = givenWin;
  client->x 	     = attr.x;
  client->y 	     = attr.y;
  client->width      = attr.width;
  client->height     = attr.height+1;

#ifdef MAXIMIZE
  client->normalX    = attr.x;
  client->normalY    = attr.y;
  client->normalWidth= attr.width;
  client->normalHeight= attr.height;
#endif

  if (attr.map_state != IsViewable)
  {
#ifdef CENTERNEW
    if (!(client->size->flags & (PPosition | USPosition)))
    { if (!scanWindows && client->x==0 && client->y==0) 
      { client->x=xmax/2-client->width/2;
        client->y=ymax/2-client->height/2;
      }	    
    }//endif no position given
#endif
  }// endif not Viewable
      
#ifdef ALWAYSCENTER
  //position? That don't impress me much...
  client->x=xmax/2-client->width/2;
  client->y=ymax/2-client->height/2;
#endif

#ifdef LOWCOLOR
  client->cmap 	= attr.colormap;
#endif

// Window attributes 
#ifdef SHADE
#ifdef GNOME
  if ((getValuedHint(client->window, xa_windowState) & WIN_STATE_SHADED)==true)
    client->shaded	= true;
  else
#endif // GNOME    
    client->shaded	= false;
#endif // SHADE    

#ifdef GNOME
  client->desktop	= currentDesktop;   
  setValuedHint 	(givenWin, xa_wm_desktop, client->desktop);
  if (getValuedHint(client->window, xa_windowState)&WIN_STATE_STICKY)
    client->sticky	= true;
  else
    client->sticky	= false;
#endif // GNOME 


// MWM compliance 
#ifdef MWM
  if (XGetWindowProperty(display, givenWin, xa_mwm_wm_hints, 0L, 20L, False,
      xa_mwm_wm_hints, &realType, &realFormat, &itemsRead,
      &itemsLeft, (unsigned char **) &mwmHints)==Success)
  { if (mwmHints)
    { if ((mwmHints->flags&MWM_HINTS_DECORATIONS) && !(mwmHints->decorations&MWM_DECOR_ALL))
      { 
#ifdef DEBUGPARANOID
        err("there are decors");
#endif
        if (mwmHints->decorations&(MWM_DECOR_BORDER|MWM_DECOR_TITLE))
          client->frameState=FRAMESHOWN;
        else 
        {
#ifdef DEBUGPARANOID
	  err("client is frameless");
#endif // DEBUGPARANOID
	  client->frameState=FRAMELESS;
        }// endelse frameshown 
      }// endif decorations 
      XFree(mwmHints);
    }// endif mwmHints
  }// if properties read   
#endif // MWM    

    // if the client is already mapped, ignore one unmap event 
    if (attr.map_state == IsViewable)
    { client->ignoreUnmap++;
    }
    else
    { // FIXME: initialize window position
      setValuedHint (client->window, xa_wm_state, NormalState);
      if (hints)
      { if (hints->flags & StateHint)
          setValuedHint(client->window, xa_wm_state, hints->initial_state);
      }// endif hints
    }// end if not viewable

#ifdef MWM
    if (client->frameState==FRAMESHOWN)
#endif
      changeGravity(client,1);
     
#ifdef LOWCOLOR 
    XSelectInput(display, givenWin, ColormapChangeMask | EnterWindowMask | 
                                    PropertyChangeMask);
#else
    XSelectInput(display, givenWin, PropertyChangeMask | FocusChangeMask);
#endif

// **** reparenting **** 
    frameWindow(client);
    updateClient(client,UPDATESIZE);

//    sendConfig(client); not needed anymore

#ifdef LAYERS
  client->layer=getValuedHint(client->window,xa_windowLayer);
#ifdef DEBUG
  err("layer: %d",client->layer);
#endif // DEBUG  
#endif // LAYERS

    if (attr.map_state == IsViewable) 
    { if (getValuedHint(client->window,xa_wm_state) == IconicState) 
      { client->ignoreUnmap++;
        XUnmapWindow(display,client->window);
// TESTING: Unmapping other windows too, parent should be enough
	XUnmapWindow(display,client->parent);
      }
      else 
      { XMapWindow (display, client->window);
        raiseClient(client);
        setValuedHint(client->window,xa_wm_state,NormalState);

#ifdef FOCUSNEW
#ifdef GNOME
        if (!getValuedHint(client->window,xa_windowHints)&WIN_HINTS_SKIP_FOCUS)
#endif // GNOME
#ifdef KEYS      
          XSetInputFocus(display, client->window, 
                         RevertToPointerRoot, CurrentTime); 

#endif // KEYS	  
#endif // FOCUSNEW       
      }// end else IconicState 
    }// end if IsViewable
    else // now not Viewable but normal State
    { if (getValuedHint(client->window,xa_wm_state)==NormalState)
      { XMapWindow(display,client->window);
        raiseClient(client);
      }// endif NormalState
    }// endelse not Viewable

#ifdef CURSORS
    XDefineCursor(display,client->parent,bodyCursor);
    XDefineCursor(display,client->window,windowCursor);
#endif

#ifdef GNOME
    updateClientList();
#endif    

// Doing cleanup 
    if (hints) 
    {
#ifdef DEBUG
      err("Xfreeing memory in createNewClient");
#endif
      XFree(hints);
    }
 
#ifdef PDA
  maximizeClient(client);
#endif

  XSetErrorHandler(xErrorHandler);
#ifdef TRACE
  trace(-1,"createNewClient");
#endif
 
}// end createNewClient

/***************************************************************************/

/* raiseClient
   raises a client

   v1.3.0-pre1: initial release
   v1.3.0-pre2: client now won't be raised using XRaiseWindow if Layers are
                supported
   v1.3.0-pre6: adjusting layer was not enough - now really raising
   v1.3.1:      layer management fixed, using adjustLayer
*/

void raiseClient(Client *client) 
{
#ifdef TRACE 
  trace(1,"raiseClient"); 
#endif 

#ifdef DEBUGPARANOID
  if (client)
  { err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

    unhideClient(client); 

#ifdef LAYERS
    adjustLayer(client,Above);
#else
    XRaiseWindow(display,client->parent);
#endif

#ifdef GNOME
#ifndef NORAISE
    raisedClient=client;
#endif    
#endif

#ifdef DEBUGPARANOID
  }// endif client 
#endif  

#ifdef TRACE 
  trace(-1,"raiseClient"); 
#endif 

}// end raiseClient  

/***************************************************************************/

/* lowerClient
   moves a client to the background

   v1.3.0-pre2: initial release
   v1.3.0-pre3: no change
*/

#ifndef MINIMAL
void lowerClient(Client *client) 
{ 
#ifdef TRACE 
  trace(1,"lowerClient"); 
#endif 

#ifdef DEBUGPARANOID
  if (client)
  {  err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif
    unhideClient(client); 
#ifdef LAYERS 
    adjustLayer(client,False);
#else
    XLowerWindow(display,client->parent);
#endif

#ifdef GNOME
#ifndef NORAISE
// FIXME get raised client
    if (!raisedClient) raisedClient=headClient;
    if (raisedClient==client) 
     raisedClient=getFocusedClient();
#endif // NORAISE     
#endif // GNOME     

#ifdef DEBUGPARANOID
  }// end client
#endif  

#ifdef TRACE 
  trace(-1,"lowerClient"); 
#endif 
}// end lowerClient
#endif // MINIMAL 

/***************************************************************************/

/* removeClientEntry
   removes a clients entry from swm's list

   v1.3.0-pre5: initial release
*/

void removeClientEntry (Client *client)
{ Client *previous;
#ifdef TRACE
  trace(1,"removeClientEntry");
#endif

  // this should be watched carefully - the head client may be NULL

  if (headClient == client) headClient = client->next;
  else
  { previous=headClient;
    while ((previous->next) && (previous->next!=client))
    { previous=previous->next; 
    }
    if (previous->next) previous->next=client->next;
  }// end else if headClient=client  

#ifdef TRACE
  trace(-1,"removeClientEntry");
#endif
}// end removeClientEntry 

/***************************************************************************/

/* removeParent
   removes a clients frame carefully

   v1.3.0-pre5: initial release
   v1.3.2:      in MINIMAL mode, now not using safesets anymore, compressed,
                now using only expectedXErrorHandler
*/

void removeParent(Client *client, int mapAgain)
{
#ifdef TRACE
  trace(1,"removeParent");
#endif

#ifdef DEBUGPARANOID
  err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

#ifndef MINIMAL
  XSync (display,false);
#endif  
  
#ifdef MINIMAL
  XSetErrorHandler(expectedXErrorHandler);
#else
  XSetErrorHandler(cleanUpErrorHandler);
#endif

#ifdef DEBUGPARANOID
  err("now grabbing server");
#endif
  XGrabServer(display);
  
  if (client->window)
  {
#ifndef MINIMAL  
    XRemoveFromSaveSet(display, client->window);
#endif

#ifdef MWM
    if (client->frameState==FRAMESHOWN)
#endif
      changeGravity(client,-1);

    XReparentWindow(display, client->window, rootWindow, 
                    client->x,client->y);
#ifndef MINIMAL		    
    XSetWindowBorderWidth(display, client->window, 1);
#endif

    if (mapAgain)
    { XMapWindow (display, client->window);
    }
    else
    { setValuedHint (client->window, xa_wm_state, WithdrawnState); 
#ifndef MINIMAL
      ignoreXErrors(XSync(display,false));
#endif
    }
  }// end if window valid

  XDestroyWindow(display, client->parent);

#ifdef PIXMAPS
  if (client->closebox) XDestroyWindow(display, client->closebox);
#ifdef MAXIMIZE    
  if (client->maxbox)  XDestroyWindow(display, client->maxbox);
#endif    
#ifdef GNOME
  if (client->stickybox)  XDestroyWindow(display, client->stickybox);
#endif    
#endif    
    
#ifdef DEBUG
  err("ungrabbing in removeClient");
#endif

  XUngrabServer(display);

#ifdef HEAVYSYNC
  err("syncing");
  XSync(display,false);
#endif

  removeClientEntry (client);

  XSetErrorHandler(xErrorHandler);

#ifdef GNOME
  updateClientList();
#endif
   
#ifdef TRACE  
   trace(-1,"removeParent");
#endif
}// end removeParent 

/***************************************************************************/

/* sendExitClient
   sends the client a message to quit itself nicely, if it doesn`t listen to
   xa_wm_delete, we try to kill it as nicely as possible.

   v1.2.6 initial release
   v1.3.0-pre1: removed old "ignore" stuff
   v1.3.0-pre2: freeing (forgotten) protocols
                included raise/focus management
   v1.3.0-pre3: no change
   v1.3.0-pre4: inserted some fine tuning for minimal mode
   v1.3.4:      added heavysync
*/

void sendExitClient(Client *client)
{ int count, maxcount, found = 0;
  Atom *protocols;

#ifdef TRACE  
  trace(1,"sendExitClient");
#endif

#ifdef DEBUGPARANOID
  if (client)
  { err("win:(%#lx),par:(%#lx),client: %s",client->window,client->parent,client->name);
#endif

#ifdef GNOME
#ifndef NORAISE
    if (raisedClient==client) raisedClient=client->next;
    if (!raisedClient) raisedClient=headClient;
#endif // NORAISE 
#endif // GNOME 

    if (XGetWMProtocols(display, client->window, &protocols, &maxcount))
    { for (count=0; count<maxcount; count++) 
      { if (protocols[count] == xa_wm_delete) found++;
      }
    if (protocols) XFree(protocols);
    
    }
    if (found) 
    { 
#ifdef DEBUG
      err ("sending client message to quit nicely");
#endif    
      sendXMessage(client->window, xa_wm_protos, xa_wm_delete);
    }
    else 
    { 
#ifdef DEBUGPARANOID
    err("pre-syncing");
#endif    

#ifdef HEAVYSYNC
    XSync (display,false);
#endif
#ifdef DEBUGPARANOID
      err ("sending XKillClient to kill client");
#endif    
      XKillClient(display, client->window);

#ifndef MINIMAL
      client->destroyed=true;
#endif
    }// end else if found

#ifdef DEBUGPARANOID
  }// end if(client)
  else
  { err ("error: trying to delete nonexisting client"); 
  }
#endif

#ifdef TRACE
  trace(-1,"sendExitClient");
#endif
}// end sendExitClient

  
/***************************************************************************/

/* moveClient
   handles window movement - start, moving, end

   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: updated to support FAST again, added handledClient 
   v1.3.1:      removed old STARTACTION stuff
*/

void moveClient(Client *client)
{
#ifdef TRACE
  trace (1,"moveClient");
#endif

#ifdef DEBUGPARANOID
  if (client) 
  {
#endif   
    pointerMode = POINTERMOVEMODE;

#ifdef CURSORS
    XGrabPointer(display, client->parent, False, 
                 PointerMotionMask | ButtonReleaseMask, GrabModeAsync, 
		 GrabModeAsync, None, moveCursor, CurrentTime); 
#else // CURSORS
    XGrabPointer(display, client->parent, False, 
                 PointerMotionMask | ButtonReleaseMask, GrabModeAsync, 
		 GrabModeAsync, None, None, CurrentTime); 
#endif // CURSORS 

    handledClient=client;

#ifdef FAST
    drawOutline(client);
#endif    

#ifdef DEBUGPARANOID
  }// end if client 
  else
  { err ("ERROR: client not valid");
  }
#endif

#ifdef TRACE
  trace (-1,"moveClient");
#endif
}// end moveClient

/***************************************************************************/

/* resizeClient
   handles window resizeing - start, resizeing, end

   v1.3.0-pre1: initial release
   v1.3.0-pre2: no change
   v1.3.0-pre3: updated to support FAST again, added handledClient 
   v1.3.0-pre4: added TRACE, added check for valid client
   v1.3.0-pre5: no change
   v1.3.0-pre6: no change
   v1.3.0:      no change
   v1.3.1:      added NORESIZEWARP, removed old STARTACTION stuff
*/

void resizeClient(Client *client)
{
#ifdef TRACE
  trace (1,"resizeClient");
#endif

#ifdef NORESIZEWARP
  if (handledClient_old_y) pointerMode = POINTERBOXRESIZEMODE;
  else
#endif  
    pointerMode = POINTERRESIZEMODE;

#ifdef DEBUGPARANOID
  if (client)
  {
#endif

#ifdef CURSORS
    XGrabPointer(display, client->parent, False, 
                 PointerMotionMask | ButtonReleaseMask, GrabModeAsync,   
                 GrabModeAsync, None, resizeCursor, CurrentTime); 
#else // CURSORS
    XGrabPointer(display, client->parent, False, 
                 PointerMotionMask | ButtonReleaseMask, GrabModeAsync,   
  	         GrabModeAsync, None, None, CurrentTime); 
#endif

#ifndef NORESIZEWARP
    XWarpPointer(display,None,client->window,0,0,0,0,
                 client->width+1,client->height+1);
#endif

#ifdef FAST
    updateClient(client,UPDATESIZE);
    drawOutline(client);
#endif	     

    handledClient=client;
#ifdef DEBUGPARANOID
  }// end if client
  else
  { err ("ERROR: client not valid");
  }
#endif

#ifdef TRACE
  trace (-1,"resizeClient");
#endif
}// end resizeClient
