#include "Date.hpp"

#include <time.h>
#include <sys/time.h>
#include <unistd.h> 
#include <sys/timeb.h> 

#include <iostream.h>

#include "Date.hpp"

int main() {
  cout << "Some date, time and time zone tests" << endl;

  tzset(); 
  cout << "Variable timezone: " << timezone << endl;
  
  cout << "Variable daylight: " << daylight << endl;

  struct timeval tv;
  struct timezone tz;
  gettimeofday( &tv, &tz);
  cout << "timezone-Struktur aus gettimeofday() (2): " << tz.tz_minuteswest << endl;  

  struct timeb tp;
  ftime( &tp);
  cout << "Zeitzone aus timeb-Struktur [ftime() (3)]: " << tp.timezone << endl;


  cout << "Class Date / Libc " << endl
       << "  ISO 8601 date [ISO C 9x ext.]  now: " << Date().toString( "%F") << endl
       << "  Local time, preferred format (date) " << Date().toString( "%x") << endl;
 
  cout << "Class TimeZone:" << endl; 
  const TimeZone& TZ= TimeZone::UTC;
  cout << "  " << TZ.toString() << endl;
  
  cout << "Class Date / TimeZone:" << endl;
  cout << "  now (local time): " << Date().toString() << endl;
  cout << "  now (UTC)         " << Date().toString( TimeZone::UTC) << endl;
}
