// The text library -- conversions from built-in types to strings
// Copyright (c) 1999 Michael Weers.
// Distributed under the terms of the GNU Library General Public License 

#ifndef text_format_h__
#define text_format_h__

#include <string>
#include <cstdio>

namespace text {

  /* This is a wrapper around the C Library's sprintf function, to make 
     it more usable with the C++ string class. This function was written
     because my system doesn't have the C++ string streams yet and will
     hopefully be replaced in future.
     
     This function is as unsafe as sprintf itself! The format string must
     be given with exactly one %... conversion specifier and that one must be
     suitable for the value parameter!!! 
     Additionally, the user must use the function such that the resulting 
     string does not get larger than 255 chars!!!!!
      
     @parameter fmt  The (s)printf-like format. 
     @parameter value  The value to be converted into a string
   */
  template<typename T>
  string format( const char* fmt, T value) {
    char str[256];
    std::sprintf( str, fmt, value);
    return str;
  }
    
//   class Formatter {
//                  string fmt;
//     
//     public:
//                  Formatter( const string& fmt);
//                  
//                  template<typename T>
//                  string format( T& e) {
//                    char str[256];
//                    std::sprintf( str, fmt.c_str(), e);
//                    return str;
//                  }
//   
//   };
} //namespace text

#endif
