#ifndef UnixDirectoryLister_hpp
#define UnixDirectoryLister_hpp

#include <sys/types.h>
#include <dirent.h>

#include "UnixFile.hpp"

using namespace std;


/** 
 *  @short A helper class for reading entries from a file system's directory
 *  @author Michael Weers
 *  @version 0.51
 */ 

class UnixDirectoryLister {
   private:
                        DIR* dir_descr;
                        UnixFile* dir;
                        bool list_hidden_files;
   public:
                        int errorcode; // Error code of last operation

   public:
                        /** The constructor.
			    @param dir The directory whose contents are to be
  			    listed
			    @param list_hidden Determines if hidden 
			    files (beginning with a dot) should be listed or not
			  */ 

                        UnixDirectoryLister( UnixFile& dir, bool list_hidden= false);

             virtual    ~UnixDirectoryLister();

                        bool isOpen()  const { return dir_descr != NULL; }

                        /** Attempts to read the directory's next entry
			    @return file (new instance) or NULL if no more
			    entries exist.
			  */
             virtual    UnixFile* getEntry();   

             
};

#endif
