#include "UnixDirectoryLister.hpp"

#include <errno.h>


UnixDirectoryLister::UnixDirectoryLister( UnixFile& dir, bool list_hidden= false) {
  this->dir= new UnixFile( dir.getFullName());  // noch ndern
  this->list_hidden_files= list_hidden;

  dir_descr= opendir( dir.getFullName().c_str() );
  if (dir_descr == NULL)               // error: directory cannot be opened.
    this->errorcode= errno;            // change this: maybe use exceptions.
}
             
UnixDirectoryLister::~UnixDirectoryLister() {
  if (isOpen())  closedir( dir_descr);
  delete dir;
}

// isOpen() defined in header

UnixFile* UnixDirectoryLister::getEntry() {
  dirent* entry;

  if (!isOpen())  return NULL;

  errorcode= 0;
  do {
    entry= readdir( dir_descr);
  } while ( entry != NULL && !list_hidden_files && entry->d_name[0] == '.');    

  if (entry != NULL) {
    UnixFile* f= new UnixFile( dir->getFullName() + UnixFile::separator + entry->d_name);
    return f;
  }
  else {
    errorcode= errno;
    return NULL;
  }
}



