// Ultrix-Compatibility.hpp
// Some things missing on DEC Ultrix platform, needed by the 
// File-Date-StringUtils library and NDir.
// This is C++ code and maybe not legal in C !
// Copyright (C) 1999 Michael Weers
#ifndef Ultrix_Compatibility_hpp
#define Ultrix_Compatibility_hpp


#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

// Some function declarations for functions from libc, POSIX...

extern "C" {
  int readlink( const char *path, char *buf, size_t bufsiz);

  char* getenv( const char* );
  
  // ioctl's 3rd argument should be char*. But we are using a pointer to a specific
  // struct somewhere and for C++ this is not compatible to char*.
  // So here a void* is used.
  int ioctl(int d, int request, void *argp);

  int lstat( const char* , struct stat*);
}


// The S_ISSOCK function for testing if a file is a socket.
// Here, it's a function instead of a preprocessor macro. 
// DEC Ultrix has the S_IFSOCK bitmask, but not that macro.

inline bool  S_ISSOCK( mode_t mode) {
  return ( (mode & S_IFMT) == S_IFSOCK) != 0;
}

#endif
