#ifndef StringUtils_hpp
#define StringUtils_hpp

#include <string>
#include <stdio.h>   // sprintf()

using namespace std;
/** A StringTokenizer breaks strings into tokens that ocurred in the string,
    separated by tokens. All neccessary parameters are set in the constructor.

    Note: Delimiter escaping is not yet supported! */
class StringTokenizer {
  protected:
       const      string s;
       const      string delimiters;
       const      string delimiter_escapes;
                  
                  string::size_type currentPos;
                  bool at_end;
  public:
                  StringTokenizer( const string& s, 
                                   const string& delimiters, 
                                   const string& delimiter_escapes= "",
                                   string::size_type startPos= 0);
         bool     hasMoreTokens();         
         string   getNextToken();
         
  protected:

};

/** Un-escape C-style character escapes */
//string unescape( string);


/** Compare two strings case-insensitive and return their order.

    The current version totally relys on the Libc function 'strcoll' to do 
    a case-insensitive comparison. Therefore, it cannot be guaranteed 
    that comparison is really done case-insensitive. See the souce file
    for a work-around.
    
    @return A value <0/=0/>0 if s1 is found to be, respectively,
            less/equal/greater than s2
  */
int icompare( const string& s1, const string& s2);


// determines if suffix is a suffix of string s
inline bool endsWith( string s, const string& suffix) {
  return ( s.substr( s.size()-suffix.size()) == suffix );
}

const short int LEFT=1, FRONT=1, CENTER= 2, RIGHT=3, BACK= 3;

string align( string s, string::size_type length, short int alignment);

/** Converts a long int to a string containing the decimal representation*/
inline string numString( long int n) {
  string s;
  char c[40];
  sprintf( c, "%ld", n);
  s= c;
  return s;
}


#endif
